/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.types.KotlinType;

public class TracingStrategyForInvoke
extends AbstractTracingStrategy {
    private final KotlinType calleeType;

    public TracingStrategyForInvoke(@NotNull KtExpression reference, @NotNull Call call2, @NotNull KotlinType calleeType) {
        if (reference == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(0);
        }
        if (call2 == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(1);
        }
        if (calleeType == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(2);
        }
        super(reference, call2);
        this.calleeType = calleeType;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        if (trace == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(3);
        }
        if (call2 == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(4);
        }
        if (this.reference instanceof KtSimpleNameExpression) {
            return;
        }
        trace.record(BindingContext.CALL, this.reference, call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        KtElement callElement;
        if (trace == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(5);
        }
        if (resolvedCall2 == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(6);
        }
        if ((callElement = this.call.getCallElement()) instanceof KtReferenceExpression) {
            trace.record(BindingContext.REFERENCE_TARGET, (KtReferenceExpression)callElement, resolvedCall2.getCandidateDescriptor());
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        if (trace == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(7);
        }
        if (resolvedCall2 == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(8);
        }
        if (this.reference instanceof KtSimpleNameExpression) {
            return;
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(9);
        }
        this.functionExpectedOrNoReceiverAllowed(trace);
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        if (trace == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(10);
        }
        if (candidates == null) {
            TracingStrategyForInvoke.$$$reportNull$$$0(11);
        }
        this.functionExpectedOrNoReceiverAllowed(trace);
    }

    private void functionExpectedOrNoReceiverAllowed(BindingTrace trace) {
        if (FunctionTypesKt.isNonExtensionFunctionType(this.calleeType)) {
            trace.report(Errors.NO_RECEIVER_ALLOWED.on(this.reference));
        } else {
            trace.report(Errors.FUNCTION_EXPECTED.on(this.reference, this.reference, this.calleeType));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeType";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForInvoke";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "bindCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "bindReference";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "bindResolvedCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "unresolvedReference";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "unresolvedReferenceWrongReceiver";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

