/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.PurifyObjectInstanceGettersLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0013H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\nH\u0002J\u0014\u0010\u0018\u001a\u00020\u0016*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\bH\u0002J\u0014\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012*\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R3\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PurifyObjectInstanceGettersLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "<set-?>", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "instanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInstanceField", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrField;", "setInstanceField", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "instanceField$delegate", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "isObjectConstructor", "", "isPureObject", "isPureStatementForObjectInitialization", "Lorg/jetbrains/kotlin/ir/IrStatement;", "owner", "purifyObjectGetterIfPossible", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "purifyObjectInstanceFieldIfPossible", "removeInstanceFieldInitializationIfPossible", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPurifyObjectInstanceGettersLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurifyObjectInstanceGettersLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PurifyObjectInstanceGettersLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1726#2,3:108\n*S KotlinDebug\n*F\n+ 1 PurifyObjectInstanceGettersLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PurifyObjectInstanceGettersLowering\n*L\n95#1:108,3\n*E\n"})
public final class PurifyObjectInstanceGettersLowering
implements DeclarationTransformer {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final Mapping.Delegate instanceField$delegate;

    public PurifyObjectInstanceGettersLowering(@NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.instanceField$delegate = this.context.getMapping().getObjectToInstanceField();
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    private final IrField getInstanceField(IrClass $this$instanceField) {
        return (IrField)this.instanceField$delegate.getValue((IrDeclaration)$this$instanceField, $$delegatedProperties[0]);
    }

    private final void setInstanceField(IrClass $this$instanceField, IrField irField) {
        this.instanceField$delegate.setValue((IrDeclaration)$this$instanceField, $$delegatedProperties[0], (Object)irField);
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        List<IrDeclaration> list2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(IrJsUtilsKt.isObjectInstanceGetter(declaration) || IrJsUtilsKt.isObjectInstanceField(declaration) || this.isObjectConstructor(declaration))) {
            return null;
        }
        IrDeclaration irDeclaration2 = declaration;
        if (irDeclaration2 instanceof IrSimpleFunction) {
            list2 = this.purifyObjectGetterIfPossible((IrSimpleFunction)declaration);
        } else if (irDeclaration2 instanceof IrField) {
            list2 = this.purifyObjectInstanceFieldIfPossible((IrField)declaration);
        } else if (irDeclaration2 instanceof IrConstructor) {
            list2 = this.removeInstanceFieldInitializationIfPossible((IrConstructor)declaration);
        } else {
            throw new IllegalStateException(("Unexpected IR type " + Reflection.getOrCreateKotlinClass(declaration.getClass()).getQualifiedName()).toString());
        }
        return list2;
    }

    private final List<IrDeclaration> removeInstanceFieldInitializationIfPossible(IrConstructor $this$removeInstanceFieldInitializationIfPossible) {
        block0: {
            IrBody irBody;
            Object object;
            if (!this.isPureObject(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$removeInstanceFieldInitializationIfPossible))) || (object = (irBody = $this$removeInstanceFieldInitializationIfPossible.getBody()) instanceof IrBlockBody ? (IrBlockBody)irBody : null) == null || (object = object.getStatements()) == null) break block0;
            object.removeIf(arg_0 -> PurifyObjectInstanceGettersLowering.removeInstanceFieldInitializationIfPossible$lambda$0(removeInstanceFieldInitializationIfPossible.1.INSTANCE, arg_0));
        }
        return null;
    }

    private final List<IrDeclaration> purifyObjectGetterIfPossible(IrSimpleFunction $this$purifyObjectGetterIfPossible) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)$this$purifyObjectGetterIfPossible.getReturnType());
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            return null;
        }
        IrClassSymbol objectToCreate = irClassSymbol;
        if (this.isPureObject((IrClass)objectToCreate)) {
            IrBody irBody = $this$purifyObjectGetterIfPossible.getBody();
            IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
            if (irBlockBody == null) {
                return null;
            }
            IrBlockBody body2 = irBlockBody;
            IrField irField = this.getInstanceField((IrClass)objectToCreate);
            if (irField == null) {
                throw new IllegalStateException("Expect the object instance field to be created".toString());
            }
            IrField instanceField = irField;
            body2.getStatements().clear();
            ((Collection)body2.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn((IrFunctionSymbol)$this$purifyObjectGetterIfPossible.getSymbol(), (IrExpression)JsIrBuilder.buildGetField$default(JsIrBuilder.INSTANCE, instanceField.getSymbol(), null, null, null, 0, 0, null, 126, null), (IrType)IrUtilsKt.getDefaultType((IrClass)objectToCreate)));
        }
        return null;
    }

    private final List<IrDeclaration> purifyObjectInstanceFieldIfPossible(IrField $this$purifyObjectInstanceFieldIfPossible) {
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)$this$purifyObjectInstanceFieldIfPossible.getType());
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            return null;
        }
        IrClassSymbol objectToCreate = irClassSymbol;
        if (this.isPureObject((IrClass)objectToCreate)) {
            IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)objectToCreate);
            if (irConstructor == null) {
                throw new IllegalStateException("Object should contain a primary constructor".toString());
            }
            IrConstructor objectConstructor = irConstructor;
            $this$purifyObjectInstanceFieldIfPossible.setInitializer((IrExpressionBody)new IrExpressionBodyImpl((IrExpression)JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, objectConstructor.getSymbol(), null, null, null, 14, null)));
        }
        return null;
    }

    private final boolean isObjectConstructor(IrDeclaration $this$isObjectConstructor) {
        return $this$isObjectConstructor instanceof IrConstructor && IrUtilsKt.isObject((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)$this$isObjectConstructor));
    }

    private final boolean isPureObject(IrClass $this$isPureObject) {
        return (Boolean)MappingsKt.getOrPut(this.context.getMapping().getObjectsWithPureInitialization(), (IrDeclaration)((IrDeclaration)$this$isPureObject), (Function0)((Function0)new Function0<Boolean>($this$isPureObject, this){
            final /* synthetic */ IrClass $this_isPureObject;
            final /* synthetic */ PurifyObjectInstanceGettersLowering this$0;
            {
                this.$this_isPureObject = $receiver;
                this.this$0 = $receiver2;
                super(0);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                if (IrUtilsKt.getSuperClass((IrClass)this.$this_isPureObject) == null) {
                    boolean bl2;
                    Object object = IrUtilsKt.getPrimaryConstructor((IrClass)this.$this_isPureObject);
                    if (object != null && (object = object.getBody()) != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null) {
                        boolean bl3;
                        block7: {
                            void $this$all$iv;
                            Iterable iterable = (Iterable)object;
                            PurifyObjectInstanceGettersLowering purifyObjectInstanceGettersLowering = this.this$0;
                            IrClass irClass = this.$this_isPureObject;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    IrStatement it = (IrStatement)element$iv;
                                    boolean bl4 = false;
                                    if (PurifyObjectInstanceGettersLowering.access$isPureStatementForObjectInitialization(purifyObjectInstanceGettersLowering, it, irClass)) continue;
                                    bl3 = false;
                                    break block7;
                                }
                                bl3 = true;
                            }
                        }
                        bl2 = !bl3;
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPureStatementForObjectInitialization(IrStatement $this$isPureStatementForObjectInitialization, IrClass owner) {
        if ($this$isPureStatementForObjectInitialization instanceof IrDelegatingConstructorCall) {
            if (Intrinsics.areEqual((Object)((IrConstructor)((IrDelegatingConstructorCall)$this$isPureStatementForObjectInitialization).getSymbol().getOwner()).getParent(), (Object)this.context.getIrBuiltIns().getAnyClass().getOwner())) return true;
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrExpression) {
            if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure((IrExpression)((IrExpression)$this$isPureStatementForObjectInitialization), (boolean)true, (boolean)false, (CommonBackendContext)this.context)) return true;
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrContainerExpression) {
            IrStatement it;
            Iterable $this$all$iv = ((IrContainerExpression)$this$isPureStatementForObjectInitialization).getStatements();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (IrStatement)element$iv;
                boolean bl = false;
            } while (this.isPureStatementForObjectInitialization(it, owner));
            boolean bl = false;
            if (bl) return true;
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrVariable) {
            IrExpression irExpression = ((IrVariable)$this$isPureStatementForObjectInitialization).getInitializer();
            if (irExpression == null) return true;
            if (this.isPureStatementForObjectInitialization((IrStatement)irExpression, owner)) return true;
            boolean bl = true;
            if (!bl) return true;
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrGetField) {
            boolean bl;
            IrExpression irExpression = ((IrGetField)$this$isPureStatementForObjectInitialization).getReceiver();
            if (irExpression != null) {
                if (this.isPureStatementForObjectInitialization((IrStatement)irExpression, owner)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrSetField) {
            IrExpression irExpression = ((IrSetField)$this$isPureStatementForObjectInitialization).getReceiver();
            boolean bl = irExpression != null ? this.isPureStatementForObjectInitialization((IrStatement)irExpression, owner) : false;
            if (bl) {
                if (this.isPureStatementForObjectInitialization((IrStatement)((IrSetField)$this$isPureStatementForObjectInitialization).getValue(), owner)) return true;
            }
        }
        if ($this$isPureStatementForObjectInitialization instanceof IrSetField) {
            if (IrJsUtilsKt.isObjectInstanceField((IrField)((IrSetField)$this$isPureStatementForObjectInitialization).getSymbol().getOwner())) return true;
        }
        if (!($this$isPureStatementForObjectInitialization instanceof IrSetValue)) return false;
        if (!AdditionalIrUtilsKt.isLocal((IrDeclaration)((IrDeclaration)((IrSetValue)$this$isPureStatementForObjectInitialization).getSymbol().getOwner()))) return false;
        if (!this.isPureStatementForObjectInitialization((IrStatement)((IrSetValue)$this$isPureStatementForObjectInitialization).getValue(), owner)) return false;
        return true;
    }

    private static final boolean removeInstanceFieldInitializationIfPossible$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isPureStatementForObjectInitialization(PurifyObjectInstanceGettersLowering $this, IrStatement $receiver, IrClass owner) {
        return $this.isPureStatementForObjectInitialization($receiver, owner);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PurifyObjectInstanceGettersLowering.class), "instanceField", "getInstanceField(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrField;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

