/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFix;
import org.jetbrains.yaml.inspections.YAMLAddQuotesToSiblingsQuickFix;
import org.jetbrains.yaml.inspections.YAMLIncompatibleTypesInspectionKt;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor$getMostPopularTypeForSiblings$1$invoke$;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor$visitScalar$;
import org.jetbrains.yaml.meta.model.YamlAnything;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlNumberType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor;", "Lorg/jetbrains/yaml/psi/YamlPsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;ZLcom/intellij/codeInspection/LocalInspectionToolSession;)V", "types", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "kotlin.jvm.PlatformType", "estimatedType", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "getMostPopularTypeForSiblings", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "isValid", "meta", "visitScalar", "", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nYAMLIncompatibleTypesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,135:1\n473#2:136\n1229#2,2:137\n179#2,2:141\n37#3,2:139\n57#4,2:143\n*S KotlinDebug\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n*L\n50#1:136\n54#1:137,2\n74#1:141,2\n63#1:139,2\n77#1:143,2\n*E\n"})
final class YamlIncompatibleTypesVisitor
extends YamlPsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;
    private final boolean isOnTheFly;
    @NotNull
    private final LocalInspectionToolSession session;
    @NotNull
    private final Sequence<YamlMetaType> types;

    public YamlIncompatibleTypesVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.holder = holder;
        this.isOnTheFly = isOnTheFly;
        this.session = session;
        Object[] objectArray = new YamlMetaType[]{YamlBooleanType.getSharedInstance(), YamlNumberType.getInstance(false), YamlStringType.getInstance(), YamlAnything.getInstance()};
        this.types = SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    public void visitScalar(@NotNull YAMLScalar scalar) {
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        YamlMetaType yamlMetaType = this.estimatedType(scalar);
        if (yamlMetaType == null) {
            return;
        }
        YamlMetaType estimatedType = yamlMetaType;
        YamlMetaType mostPopularType = this.getMostPopularTypeForSiblings(scalar);
        if (mostPopularType == null || Intrinsics.areEqual((Object)mostPopularType, (Object)estimatedType)) {
            return;
        }
        SmartList quickFixes = new SmartList();
        if (Intrinsics.areEqual((Object)mostPopularType, (Object)YamlStringType.getInstance())) {
            boolean bl;
            boolean singleQuote;
            block5: {
                Sequence siblings;
                Sequence $this$filterIsInstance$iv = siblings = YAMLIncompatibleTypesInspectionKt.access$findStructuralSiblings(scalar);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)visitScalar$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                YAMLQuotedText yAMLQuotedText = (YAMLQuotedText)SequencesKt.firstOrNull((Sequence)sequence);
                singleQuote = yAMLQuotedText != null ? yAMLQuotedText.isSingleQuote() : false;
                PsiElement psiElement = (PsiElement)scalar;
                String string = YAMLBundle.message("inspections.incompatible.types.quickfix.wrap.quotes.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.inc\u2026fix.wrap.quotes.message\")");
                quickFixes.add((Object)new YAMLAddQuoteQuickFix(psiElement, string, singleQuote));
                Sequence $this$any$iv = siblings;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    YAMLValue it = (YAMLValue)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)scalar) && !(it instanceof YAMLQuotedText))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                quickFixes.add((Object)new YAMLAddQuotesToSiblingsQuickFix(scalar, singleQuote));
            }
        }
        Object[] objectArray = new Object[]{estimatedType.getDisplayName(), mostPopularType.getDisplayName()};
        String string = YAMLBundle.message("inspections.incompatible.types.message", objectArray);
        Collection $this$toTypedArray$iv = (Collection)quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        this.holder.registerProblem((PsiElement)scalar, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        super.visitScalar(scalar);
    }

    private final boolean isValid(YamlMetaType meta, YAMLValue value) {
        ProblemsHolder problemsHolder = new ProblemsHolder(this.holder.getManager(), this.holder.getFile(), this.isOnTheFly);
        meta.validateValue(value, problemsHolder);
        return !problemsHolder.hasResults();
    }

    private final YamlMetaType estimatedType(YAMLScalar scalar) {
        Object v0;
        block1: {
            Sequence<YamlMetaType> $this$firstOrNull$iv = this.types;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YamlMetaType it = (YamlMetaType)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.isValid(it, scalar)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final YamlMetaType getMostPopularTypeForSiblings(YAMLValue value) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)value;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLSequence yAMLSequence = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLSequence.class, (boolean)true);
        if (yAMLSequence == null) {
            return null;
        }
        YAMLSequence topSeq = yAMLSequence;
        return (YamlMetaType)YAMLIncompatibleTypesInspectionKt.access$memoizeWith2Keys((UserDataHolder)this.session, YAMLIncompatibleTypesInspectionKt.access$getSTRUCTURAL_SIBLINGS_TYPE_KEY$p(), topSeq, YAMLIncompatibleTypesInspectionKt.access$getKeysInBetween(value, topSeq), (Function2)new Function2<YAMLSequence, List<? extends String>, YamlMetaType>(this){
            final /* synthetic */ YamlIncompatibleTypesVisitor this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final YamlMetaType invoke(@NotNull YAMLSequence seq, @NotNull List<String> ks) {
                Object v1;
                Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
                Intrinsics.checkNotNullParameter(ks, (String)"ks");
                Sequence $this$filterIsInstance$iv = YAMLIncompatibleTypesInspectionKt.access$findStructuralSiblings(seq, ks);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getMostPopularTypeForSiblings$1$invoke$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence $this$groupingBy$iv = SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<YAMLScalar, YamlMetaType>(this.this$0){
                    final /* synthetic */ YamlIncompatibleTypesVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final YamlMetaType invoke(@NotNull YAMLScalar it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return YamlIncompatibleTypesVisitor.access$estimatedType(this.this$0, it);
                    }
                }));
                boolean $i$f$groupingBy = false;
                Iterable iterable = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<YamlMetaType, YamlMetaType>($this$groupingBy$iv){
                    final /* synthetic */ Sequence $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<YamlMetaType> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     * WARNING - void declaration
                     */
                    public Object keyOf(Object element) {
                        void var2_2;
                        YamlMetaType it = (YamlMetaType)element;
                        boolean bl = false;
                        return var2_2;
                    }
                })).entrySet();
                Iterator<T> iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    v1 = null;
                } else {
                    T t = iterator.next();
                    if (!iterator.hasNext()) {
                        v1 = t;
                    } else {
                        Map.Entry it = (Map.Entry)t;
                        boolean bl = false;
                        int n = ((Number)it.getValue()).intValue();
                        do {
                            T t2 = iterator.next();
                            Map.Entry it2 = (Map.Entry)t2;
                            $i$a$-maxByOrNull-YamlIncompatibleTypesVisitor$getMostPopularTypeForSiblings$1$3 = false;
                            int n2 = ((Number)it2.getValue()).intValue();
                            if (n >= n2) continue;
                            t = t2;
                            n = n2;
                        } while (iterator.hasNext());
                        v1 = t;
                    }
                }
                Map.Entry entry = v1;
                return entry != null ? (YamlMetaType)entry.getKey() : null;
            }
        });
    }

    public static final /* synthetic */ YamlMetaType access$estimatedType(YamlIncompatibleTypesVisitor $this, YAMLScalar scalar) {
        return $this.estimatedType(scalar);
    }
}

