/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.LearningHighlightPainter;
import training.ui.LearningUiHighlightingManager;
import training.ui.LearningUiHighlightingManagerKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020&J\u0006\u0010(\u001a\u00020&J\b\u0010)\u001a\u00020\u001eH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltraining/ui/RepaintHighlighting;", "T", "Ljava/awt/Component;", "", "original", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "partInfo", "Lkotlin/Function0;", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "cellBoundsInList", "disposable", "Lcom/intellij/openapi/Disposable;", "highlightPainter", "Ltraining/ui/LearningHighlightPainter;", "listLocationOnScreen", "Ljava/awt/Point;", "getOptions", "()Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "getOriginal", "()Ljava/awt/Component;", "Ljava/awt/Component;", "getPartInfo", "()Lkotlin/jvm/functions/Function0;", "pulsationOffset", "", "getRectangle", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "startDate", "Ljava/util/Date;", "cleanup", "", "initTimer", "reinitHighlightComponent", "shouldReinit", "intellij.featuresTrainer"})
public final class RepaintHighlighting<T extends Component> {
    @NotNull
    private final T original;
    @NotNull
    private final LearningUiHighlightingManager.HighlightingOptions options;
    @NotNull
    private final Function0<Object> partInfo;
    @NotNull
    private final Function0<Rectangle> rectangle;
    private boolean removed;
    @NotNull
    private final Date startDate;
    @Nullable
    private Point listLocationOnScreen;
    @Nullable
    private Rectangle cellBoundsInList;
    @Nullable
    private LearningHighlightPainter highlightPainter;
    private final int pulsationOffset;
    @Nullable
    private Disposable disposable;

    public RepaintHighlighting(@NotNull T original, @NotNull LearningUiHighlightingManager.HighlightingOptions options, @NotNull Function0<? extends Object> partInfo, @NotNull Function0<? extends Rectangle> rectangle) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(partInfo, (String)"partInfo");
        Intrinsics.checkNotNullParameter(rectangle, (String)"rectangle");
        this.original = original;
        this.options = options;
        this.partInfo = partInfo;
        this.rectangle = rectangle;
        this.startDate = new Date();
        this.pulsationOffset = this.options.getUsePulsation() ? 20 : 0;
    }

    @NotNull
    public final T getOriginal() {
        return this.original;
    }

    @NotNull
    public final LearningUiHighlightingManager.HighlightingOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final Function0<Object> getPartInfo() {
        return this.partInfo;
    }

    @NotNull
    public final Function0<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public final void initTimer() {
        Timer timer = TimerUtil.createNamedTimer((String)"IFT item", (int)50);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"createNamedTimer(\"IFT item\", 50)");
        Timer timer2 = timer;
        timer2.addActionListener(arg_0 -> RepaintHighlighting.initTimer$lambda$0(this, timer2, arg_0));
        timer2.start();
    }

    public final void cleanup() {
        Disposable disposable = this.disposable;
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            this.disposable = null;
        }
        this.highlightPainter = null;
    }

    private final boolean shouldReinit() {
        return this.highlightPainter == null || !Intrinsics.areEqual((Object)((Component)this.original).getLocationOnScreen(), (Object)this.listLocationOnScreen) || !Intrinsics.areEqual((Object)this.rectangle.invoke(), (Object)this.cellBoundsInList);
    }

    public final void reinitHighlightComponent() {
        Rectangle rectangle = (Rectangle)this.rectangle.invoke();
        if (rectangle == null) {
            return;
        }
        Rectangle cellBounds = rectangle;
        this.cleanup();
        Point pt = SwingUtilities.convertPoint(this.original, cellBounds.getLocation(), SwingUtilities.getRootPane(this.original).getGlassPane());
        Rectangle bounds = new Rectangle(pt.x - this.pulsationOffset, pt.y - this.pulsationOffset, cellBounds.width + 2 * this.pulsationOffset, cellBounds.height + 2 * this.pulsationOffset);
        LearningHighlightPainter newPainter = new LearningHighlightPainter(this.startDate, this.options, bounds);
        Disposable it = Disposer.newDisposable((String)"RepaintHighlightingDisposable");
        boolean bl = false;
        this.disposable = it;
        LearningUiHighlightingManagerKt.access$findIdeGlassPane(this.original).addPainter(null, (Painter)newPainter, it);
        this.listLocationOnScreen = ((Component)this.original).getLocationOnScreen();
        this.cellBoundsInList = cellBounds;
        this.highlightPainter = newPainter;
    }

    private static final void initTimer$lambda$0(RepaintHighlighting this$0, Timer $timer, ActionEvent it) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$timer, (String)"$timer");
            if (!((Component)this$0.original).isShowing() || ((Component)this$0.original).getBounds().isEmpty()) {
                LearningUiHighlightingManager.INSTANCE.removeIt$intellij_featuresTrainer(this$0);
            }
            if (this$0.removed) {
                $timer.stop();
                return;
            }
            if (this$0.shouldReinit()) {
                this$0.cleanup();
                this$0.reinitHighlightComponent();
            }
            LearningHighlightPainter learningHighlightPainter = this$0.highlightPainter;
            if (learningHighlightPainter == null) break block3;
            learningHighlightPainter.setNeedsRepaint(true);
        }
    }
}

