/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ShCompletionProvider;
import org.jetbrains.plugins.terminal.util.ShellIntegrationKt;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "Companion", "ShellTypeCondition", "intellij.terminal"})
public final class TerminalCompletionContributor
extends CompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TerminalCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().with((PatternCondition)new ShellTypeCondition(ShellType.ZSH))), new ShCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().with((PatternCondition)new ShellTypeCondition(ShellType.BASH))), new ShCompletionProvider());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionContributor$Companion;", "", "()V", "isSingleCharParameter", "", "value", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSingleCharParameter(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.length() == 2 && value.charAt(0) == '-';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionContributor$ShellTypeCondition;", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiFile;", "type", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "(Lorg/jetbrains/plugins/terminal/util/ShellType;)V", "accepts", "", "file", "context", "Lcom/intellij/util/ProcessingContext;", "intellij.terminal"})
    private static final class ShellTypeCondition
    extends PatternCondition<PsiFile> {
        @NotNull
        private final ShellType type;

        public ShellTypeCondition(@NotNull ShellType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super("shellType");
            this.type = type;
        }

        public boolean accepts(@NotNull PsiFile file, @Nullable ProcessingContext context) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiFile original = file;
            while (!Intrinsics.areEqual((Object)original.getOriginalFile(), (Object)original)) {
                Intrinsics.checkNotNullExpressionValue((Object)original.getOriginalFile(), (String)"original.originalFile");
            }
            return original.getUserData(ShellIntegrationKt.getSHELL_TYPE_KEY()) == this.type;
        }
    }
}

