/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Set;
import org.intellij.lang.xpath.psi.impl.ResolveUtil;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.util.BaseMatcher;

public class ParamMatcher
extends BaseMatcher {
    private final XmlTag myRoot;
    private final String myName;
    private final Set<String> myExcludedNames;

    public ParamMatcher(XmlTag parent, String name) {
        this.myRoot = parent;
        this.myName = name;
        this.myExcludedNames = Collections.emptySet();
    }

    public ParamMatcher(XmlTag root, String[] excludedNames, String name) {
        this.myRoot = root;
        this.myName = name;
        this.myExcludedNames = ContainerUtil.immutableSet((Object[])excludedNames);
    }

    @Override
    public XmlTag getRoot() {
        return this.myRoot;
    }

    @Override
    protected boolean matches(XmlTag tag) {
        XmlAttribute attribute;
        return this.isApplicable(tag) && (attribute = tag.getAttribute("name", null)) != null && this.matches(attribute);
    }

    protected boolean isApplicable(XmlTag tag) {
        return XsltSupport.isParam(tag);
    }

    private boolean matches(XmlAttribute attribute) {
        String value = attribute.getValue();
        return (this.myName == null || this.myName.equals(value)) && !this.myExcludedNames.contains(value);
    }

    @Override
    public ResolveUtil.Matcher variantMatcher() {
        return new ParamMatcher(this.getRoot(), null);
    }
}

