/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.actions.TargetAction;
import com.intellij.lang.ant.config.impl.AntBuildTargetImpl;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.lang.ant.dom.AntDomIncludingDirective;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiCachedValueImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AntBuildModelImpl
implements AntBuildModelBase {
    private final AntBuildFile myFile;
    private final CachedValue<List<AntBuildTargetBase>> myTargets;

    public AntBuildModelImpl(AntBuildFile buildFile) {
        this.myFile = buildFile;
        this.myTargets = new PsiCachedValueImpl(PsiManager.getInstance((Project)this.myFile.getProject()), () -> (CachedValueProvider.Result)ReadAction.compute(() -> {
            Pair<List<AntBuildTargetBase>, Collection<Object>> result = AntBuildModelImpl.getTargetListImpl(this);
            return CachedValueProvider.Result.create((Object)((List)result.getFirst()), (Object[])ArrayUtil.toObjectArray((Collection)((Collection)result.getSecond())));
        }));
    }

    @Override
    @Nullable
    public String getDefaultTargetName() {
        AntDomProject antDomProject = this.getAntProject();
        if (antDomProject != null) {
            return antDomProject.getDefaultTarget().getRawText();
        }
        return "";
    }

    @Override
    @Nullable
    @NlsSafe
    public String getName() {
        AntDomProject project = this.getAntProject();
        return project != null ? project.getName().getRawText() : null;
    }

    @Override
    public AntBuildTarget[] getTargets() {
        return ((List)this.myTargets.getValue()).toArray(AntBuildTargetBase.EMPTY_ARRAY);
    }

    @Override
    public AntBuildTarget[] getFilteredTargets() {
        ArrayList<AntBuildTargetBase> filtered = new ArrayList<AntBuildTargetBase>();
        for (AntBuildTargetBase buildTarget : (List)this.myTargets.getValue()) {
            if (!this.myFile.isTargetVisible(buildTarget)) continue;
            filtered.add(buildTarget);
        }
        return filtered.isEmpty() ? AntBuildTargetBase.EMPTY_ARRAY : filtered.toArray(AntBuildTargetBase.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    @NonNls
    public String getDefaultTargetActionId() {
        if (StringUtil.isEmptyOrSpaces((String)this.getDefaultTargetName())) {
            return null;
        }
        String modelName = this.getName();
        if (StringUtil.isEmptyOrSpaces((String)modelName)) {
            return null;
        }
        return AntConfiguration.getActionIdPrefix(this.getBuildFile().getProject()) + "_" + modelName.trim() + "_" + TargetAction.getDefaultTargetName();
    }

    @Override
    public AntBuildFileBase getBuildFile() {
        return (AntBuildFileBase)this.myFile;
    }

    @Override
    @Nullable
    public AntBuildTargetBase findTarget(String name) {
        for (AntBuildTargetBase target : (List)this.myTargets.getValue()) {
            if (!Comparing.strEqual((String)target.getName(), (String)name)) continue;
            return target;
        }
        return null;
    }

    @Override
    @Nullable
    public BuildTask findTask(String targetName, String taskName) {
        AntBuildTargetBase buildTarget = this.findTarget(targetName);
        return buildTarget == null ? null : buildTarget.findTask(taskName);
    }

    @Override
    public AntDomProject getAntProject() {
        return AntSupport.getAntDomProject((PsiFile)this.getBuildFile().getAntFile());
    }

    @Override
    public boolean hasTargetWithActionId(String id) {
        return StreamEx.of((Collection)((Collection)this.myTargets.getValue())).map(AntBuildTargetBase::getActionId).has((Object)id);
    }

    private static Pair<List<AntBuildTargetBase>, Collection<Object>> getTargetListImpl(AntBuildModelBase model) {
        ArrayList list = new ArrayList();
        final HashSet<Object> dependencies = new HashSet<Object>();
        AntDomProject project = model.getAntProject();
        if (project != null) {
            AntBuildFile buildFile = model.getBuildFile();
            XmlFile xmlFile = buildFile.getAntFile();
            dependencies.add(xmlFile != null ? xmlFile : PsiModificationTracker.MODIFICATION_COUNT);
            VirtualFile sourceFile = buildFile.getVirtualFile();
            new Object(){
                private boolean myIsImported = false;
                private final Set<VirtualFile> myProcessed = new HashSet<VirtualFile>();
                private AntDomTarget myDefaultTarget = null;

                private void fillTargets(List<? super AntBuildTargetBase> list, AntBuildModelBase model, AntDomProject project, VirtualFile sourceFile) {
                    Object result;
                    if (this.myProcessed.contains(sourceFile)) {
                        return;
                    }
                    this.myProcessed.add(sourceFile);
                    if (!this.myIsImported && (result = (TargetResolver.Result)project.getDefaultTarget().getValue()) != null) {
                        Pair<AntDomTarget, String> targetWithName = ((TargetResolver.Result)result).getResolvedTarget(project.getDefaultTarget().getRawText());
                        this.myDefaultTarget = (AntDomTarget)Pair.getFirst(targetWithName);
                    }
                    for (AntDomTarget target : project.getDeclaredTargets()) {
                        list.add(new AntBuildTargetImpl(target, model, sourceFile, this.myIsImported, target.equals(this.myDefaultTarget)));
                    }
                    this.myIsImported = true;
                    List allIncludes = ContainerUtil.concat(project.getDeclaredImports(), project.getDeclaredIncludes());
                    for (AntDomIncludingDirective incl : allIncludes) {
                        PsiFileSystemItem includedFile = (PsiFileSystemItem)incl.getFile().getValue();
                        if (includedFile instanceof PsiFile) {
                            PsiFile included = includedFile.getContainingFile().getOriginalFile();
                            dependencies.add(included);
                            AntDomProject includedProject = AntSupport.getAntDomProject((PsiFile)includedFile);
                            if (includedProject == null) continue;
                            this.fillTargets(list, model, includedProject, included.getVirtualFile());
                            continue;
                        }
                        if (includedFile != null) continue;
                        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                    }
                }
            }.fillTargets(list, model, project, sourceFile);
        }
        if (dependencies.isEmpty()) {
            dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
        }
        return new Pair(list, dependencies);
    }
}

