/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.java.workspace.entities.JavaModuleSettingsEntity;
import com.intellij.java.workspace.entities.JavaModuleSettingsKt;
import com.intellij.java.workspace.entities.JavaRootsKt;
import com.intellij.java.workspace.entities.JavaSourceRootPropertiesEntity;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.jps.serialization.impl.LibraryNameGenerator;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.config.ModulePathShortener;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016J-\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u000b\u0010\u001d\u001a\u00070\u0010\u00a2\u0006\u0002\b\u001eH\u0002R(\u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/eclipse/config/EmlFileSaver;", "", "module", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "entities", "", "Ljava/lang/Class;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "pathShortener", "Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;", "moduleReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "projectReplacePathMacroMap", "(Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;Ljava/util/Map;Lorg/jetbrains/idea/eclipse/config/ModulePathShortener;Lcom/intellij/openapi/components/PathMacroMap;Lcom/intellij/openapi/components/PathMacroMap;)V", "generateLibName", "", "library", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "saveContentRoots", "", "root", "Lorg/jdom/Element;", "saveCustomJavaSettings", "saveEml", "saveModuleRelatedRoots", "libTag", "type", "Lcom/intellij/openapi/roots/OrderRootType;", "tagName", "Lorg/jetbrains/annotations/NonNls;", "intellij.eclipse"})
@SourceDebugExtension(value={"SMAP\nEmlFileSaver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmlFileSaver.kt\norg/jetbrains/idea/eclipse/config/EmlFileSaver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1194#2,2:174\n1222#2,4:176\n1855#2:180\n766#2:181\n857#2,2:182\n1855#2,2:184\n766#2:186\n857#2,2:187\n1855#2,2:189\n1856#2:191\n766#2:192\n857#2,2:193\n1855#2,2:195\n288#2,2:197\n1855#2:199\n1855#2,2:200\n1855#2,2:202\n1856#2:204\n*S KotlinDebug\n*F\n+ 1 EmlFileSaver.kt\norg/jetbrains/idea/eclipse/config/EmlFileSaver\n*L\n43#1:174,2\n43#1:176,4\n45#1:180\n68#1:181\n68#1:182,2\n70#1:184,2\n78#1:186\n78#1:187,2\n78#1:189,2\n45#1:191\n113#1:192\n113#1:193,2\n113#1:195,2\n123#1:197,2\n131#1:199\n133#1:200,2\n144#1:202,2\n131#1:204\n*E\n"})
public final class EmlFileSaver {
    @NotNull
    private final ModuleEntity module;
    @NotNull
    private final Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>> entities;
    @NotNull
    private final ModulePathShortener pathShortener;
    @NotNull
    private final PathMacroMap moduleReplacePathMacroMap;
    @NotNull
    private final PathMacroMap projectReplacePathMacroMap;

    public EmlFileSaver(@NotNull ModuleEntity module, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities, @NotNull ModulePathShortener pathShortener, @NotNull PathMacroMap moduleReplacePathMacroMap, @NotNull PathMacroMap projectReplacePathMacroMap) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Intrinsics.checkNotNullParameter((Object)pathShortener, (String)"pathShortener");
        Intrinsics.checkNotNullParameter((Object)moduleReplacePathMacroMap, (String)"moduleReplacePathMacroMap");
        Intrinsics.checkNotNullParameter((Object)projectReplacePathMacroMap, (String)"projectReplacePathMacroMap");
        this.module = module;
        this.entities = entities;
        this.pathShortener = pathShortener;
        this.moduleReplacePathMacroMap = moduleReplacePathMacroMap;
        this.projectReplacePathMacroMap = projectReplacePathMacroMap;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Element saveEml() {
        void $this$associateByTo$iv$iv;
        Element root = new Element("component");
        this.saveCustomJavaSettings(root);
        this.saveContentRoots(root);
        List list = this.entities.get(LibraryEntity.class);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Map.Entry entry2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            LibraryEntity libraryEntity = (LibraryEntity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map moduleLibraries = destination$iv$iv;
        LinkedHashMap libLevels = new LinkedHashMap();
        Iterable $this$forEach$iv = this.module.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDependencyItem dep = (ModuleDependencyItem)element$iv;
            boolean bl = false;
            ModuleDependencyItem moduleDependencyItem = dep;
            if (moduleDependencyItem instanceof ModuleDependencyItem.Exportable.ModuleDependency) {
                if (((ModuleDependencyItem.Exportable.ModuleDependency)dep).getScope() == ModuleDependencyItem.DependencyScope.COMPILE) continue;
                root.addContent(new Element("module").setAttribute("name", ((ModuleDependencyItem.Exportable.ModuleDependency)dep).getModule().getName()).setAttribute("scope", ((ModuleDependencyItem.Exportable.ModuleDependency)dep).getScope().name()));
                continue;
            }
            if (moduleDependencyItem instanceof ModuleDependencyItem.InheritedSdkDependency) {
                root.setAttribute("inheritJdk", "true");
                continue;
            }
            if (moduleDependencyItem instanceof ModuleDependencyItem.SdkDependency) {
                root.setAttribute("jdk", ((ModuleDependencyItem.SdkDependency)dep).getSdkName());
                root.setAttribute("jdk_type", ((ModuleDependencyItem.SdkDependency)dep).getSdkType());
                continue;
            }
            if (!(moduleDependencyItem instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
            Element libTag = new Element("lib");
            LibraryEntity library = (LibraryEntity)moduleLibraries.get(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName());
            String string = LibraryNameGenerator.INSTANCE.getLegacyLibraryName(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary());
            if (string == null) {
                string = this.generateLibName(library);
            }
            String libName = string;
            libTag.setAttribute("name", libName);
            libTag.setAttribute("scope", ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getScope().name());
            LibraryTableId tableId = ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getTableId();
            if (tableId instanceof LibraryTableId.ModuleLibraryTableId) {
                if (library != null) {
                    void $this$filterTo$iv$iv;
                    String string2;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv = library.getRoots();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.SOURCES.name())) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List srcRoots = (List)destination$iv$iv2;
                    Object object = (LibraryRoot)CollectionsKt.firstOrNull((List)srcRoots);
                    if (object != null && (object = object.getUrl()) != null && (object = (destination$iv$iv2 = object.getUrl())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"url");
                        string2 = StringsKt.substringBefore$default(destination$iv$iv2, (String)"!/", null, (int)2, null);
                    } else {
                        string2 = null;
                    }
                    String eclipseUrl = string2;
                    Iterable $this$forEach$iv2 = srcRoots;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv2;
                        boolean bl3 = false;
                        String url = it.getUrl().getUrl();
                        Element srcTag = new Element("srcroot").setAttribute("url", url);
                        if (!EPathUtil.areUrlsPointTheSame(url, eclipseUrl)) {
                            srcTag.setAttribute("bind", "false");
                        }
                        libTag.addContent(srcTag);
                    }
                    Iterable $this$filter$iv2 = library.getRoots();
                    boolean $i$f$filter2 = false;
                    destination$iv$iv2 = $this$filter$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        LibraryRoot it = (LibraryRoot)element$iv$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)"JAVADOC")) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    $this$forEach$iv2 = CollectionsKt.drop((Iterable)((List)destination$iv$iv3), (int)1);
                    $i$f$forEach2 = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        LibraryRoot it = (LibraryRoot)element$iv3;
                        boolean bl5 = false;
                        libTag.addContent(new Element("javadocroot_attr").setAttribute("url", it.getUrl().getUrl()));
                    }
                    OrderRootType orderRootType = OrderRootType.SOURCES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"SOURCES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType, "relative-module-src");
                    OrderRootType orderRootType2 = OrderRootType.CLASSES;
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"CLASSES");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType2, "relative-module-cls");
                    OrderRootType orderRootType3 = JavadocOrderRootType.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)orderRootType3, (String)"getInstance()");
                    this.saveModuleRelatedRoots(libTag, library, orderRootType3, "relative-module-javadoc");
                }
            } else if (tableId instanceof LibraryTableId.ProjectLibraryTableId) {
                ((Map)libLevels).put(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName(), "project");
            } else if (tableId instanceof LibraryTableId.GlobalLibraryTableId && !Intrinsics.areEqual((Object)tableId.getLevel(), (Object)"application")) {
                ((Map)libLevels).put(((ModuleDependencyItem.Exportable.LibraryDependency)dep).getLibrary().getName(), tableId.getLevel());
            }
            List list2 = libTag.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"libTag.children");
            if (!(!((Collection)list2).isEmpty()) && ((ModuleDependencyItem.Exportable.LibraryDependency)dep).getScope() == ModuleDependencyItem.DependencyScope.COMPILE) continue;
            root.addContent(libTag);
        }
        if (!((Map)libLevels).isEmpty()) {
            Element levelsTag = new Element("levels");
            for (Map.Entry entry2 : ((Map)libLevels).entrySet()) {
                String name = (String)entry2.getKey();
                String level = (String)entry2.getValue();
                levelsTag.addContent(new Element("level").setAttribute("name", name).setAttribute("value", level));
            }
            root.addContent(levelsTag);
        }
        this.moduleReplacePathMacroMap.substitute(root, SystemInfo.isFileSystemCaseSensitive);
        return JDOMUtil.isEmpty((Element)root) ? null : root;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveModuleRelatedRoots(Element libTag, LibraryEntity library, OrderRootType type, String tagName) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = library.getRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)type.name())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file;
            LibraryRoot it = (LibraryRoot)element$iv;
            boolean bl = false;
            VirtualFile virtualFile = file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl());
            VirtualFile localFile = (virtualFile != null ? virtualFile.getFileSystem() : null) instanceof JarFileSystem ? JarFileSystem.getInstance().getVirtualFileForJar(file) : file;
            if (localFile == null || !this.pathShortener.isUnderContentRoots(localFile)) continue;
            libTag.addContent(new Element(tagName).setAttribute("project-related", this.projectReplacePathMacroMap.substitute(it.getUrl().getUrl(), SystemInfo.isFileSystemCaseSensitive)));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String generateLibName(LibraryEntity library) {
        block5: {
            v0 /* !! */  = library;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getRoots()) == null) ** GOTO lbl-1000
            $this$firstOrNull$iv = (Iterable)v0 /* !! */ ;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (LibraryRoot)element$iv;
                $i$a$-firstOrNull-EmlFileSaver$generateLibName$firstRoot$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)OrderRootType.CLASSES.name())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((v0 /* !! */  = (LibraryRoot)v1) != null) {
            v2 = v0 /* !! */ .getUrl();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        v3 = firstRoot = v2;
        file = v3 != null ? VirtualFileUrls.getVirtualFile(v3) : null;
        v4 = fileForJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
        if (v4 != null) {
            v5 = v4.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"fileForJar.name");
            return v5;
        }
        v6 = file;
        v7 = v6 != null ? v6.getName() : null;
        if (v7 == null) {
            v7 = "Empty Library";
        }
        return v7;
    }

    private final void saveContentRoots(Element root) {
        Iterable $this$forEach$iv = this.module.getContentRoots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContentRootEntity contentRoot = (ContentRootEntity)element$iv;
            boolean bl = false;
            Element contentRootTag = new Element("contentEntry").setAttribute("url", contentRoot.getUrl().getUrl());
            Iterable $this$forEach$iv2 = contentRoot.getSourceRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SourceRootEntity sourceRoot2 = (SourceRootEntity)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)sourceRoot2.getRootType(), (Object)"java-test")) {
                    contentRootTag.addContent(new Element("testFolder").setAttribute("url", sourceRoot2.getUrl().getUrl()));
                }
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity = JavaRootsKt.asJavaSourceRoot((SourceRootEntity)sourceRoot2);
                String packagePrefix = javaSourceRootPropertiesEntity != null ? javaSourceRootPropertiesEntity.getPackagePrefix() : null;
                CharSequence charSequence = packagePrefix;
                if (charSequence == null || charSequence.length() == 0) continue;
                contentRootTag.addContent(new Element("packagePrefix").setAttribute("url", sourceRoot2.getUrl().getUrl()).setAttribute("value", packagePrefix));
            }
            VirtualFile rootFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)contentRoot.getUrl());
            Iterable $this$forEach$iv3 = contentRoot.getExcludedUrls();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                ExcludeUrlEntity excluded = (ExcludeUrlEntity)element$iv3;
                boolean bl3 = false;
                VirtualFile excludedFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)excluded.getUrl());
                if (rootFile != null && excludedFile != null && !VfsUtilCore.isAncestor((VirtualFile)rootFile, (VirtualFile)excludedFile, (boolean)false)) continue;
                contentRootTag.addContent(new Element("excludeFolder").setAttribute("url", excluded.getUrl().getUrl()));
            }
            if (JDOMUtil.isEmpty((Element)contentRootTag)) continue;
            root.addContent(contentRootTag);
        }
    }

    private final void saveCustomJavaSettings(Element root) {
        block4: {
            JavaModuleSettingsEntity javaModuleSettingsEntity = JavaModuleSettingsKt.getJavaSettings((ModuleEntity)this.module);
            if (javaModuleSettingsEntity == null) break block4;
            JavaModuleSettingsEntity javaSettings2 = javaModuleSettingsEntity;
            boolean bl = false;
            VirtualFileUrl virtualFileUrl = javaSettings2.getCompilerOutputForTests();
            if (virtualFileUrl != null) {
                VirtualFileUrl testOutput = virtualFileUrl;
                boolean bl2 = false;
                root.addContent(new Element("output-test").setAttribute("url", testOutput.getUrl()));
            }
            if (javaSettings2.getInheritedCompilerOutput()) {
                root.setAttribute("inherit-compiler-output", "true");
            }
            if (javaSettings2.getExcludeOutput()) {
                root.addContent(new Element("exclude-output"));
            }
            String string = javaSettings2.getLanguageLevelId();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                root.setAttribute("LANGUAGE_LEVEL", it);
            }
        }
    }
}

