/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.popup.PopupDispatcher;
import com.intellij.ui.popup.WizardPopup;
import git4idea.actions.GitFetch;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.ui.branch.GitBranchPopup;
import java.util.Iterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/ui/branch/GitBranchPopupFetchAction;", "P", "Lcom/intellij/ui/popup/WizardPopup;", "Lgit4idea/actions/GitFetch;", "popupClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isBusy", "", "project", "Lcom/intellij/openapi/project/Project;", "onFetchFinished", "result", "Lgit4idea/fetch/GitFetchResult;", "showNotificationIfNeeded", "update", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchPopupFetchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchPopupFetchAction.kt\ngit4idea/ui/branch/GitBranchPopupFetchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class GitBranchPopupFetchAction<P extends WizardPopup>
extends GitFetch {
    @NotNull
    private final Class<P> popupClass;

    public GitBranchPopupFetchAction(@NotNull Class<P> popupClass) {
        Intrinsics.checkNotNullParameter(popupClass, (String)"popupClass");
        this.popupClass = popupClass;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setIcon(this.isBusy(project) ? GitBranchPopup.LOADING_ICON : AllIcons.Vcs.Fetch);
        e.getPresentation().setText(this.isBusy(project) ? GitBundle.message("fetching", new Object[0]) : GitBundle.message("action.fetch.text", new Object[0]));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || this.isBusy(project)) {
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected void onFetchFinished(@NotNull Project project, @NotNull GitFetchResult result2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        GitBranchIncomingOutgoingManager.getInstance(project).forceUpdateBranches(GitBranchPopupFetchAction::onFetchFinished$lambda$0);
        this.showNotificationIfNeeded(result2);
    }

    private final void showNotificationIfNeeded(GitFetchResult result2) {
        Object v1;
        block3: {
            Stream stream = PopupDispatcher.getInstance().getPopupStream();
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"getInstance().popupStream");
            Sequence sequence = StreamsKt.asSequence((Stream)stream);
            Class<?> clazz = this.popupClass.getClass();
            Sequence sequence2 = sequence;
            Iterator iterator = sequence2.iterator();
            while (iterator.hasNext()) {
                Object e;
                Object p0 = e = iterator.next();
                boolean bl = false;
                if (!clazz.isInstance(p0)) continue;
                v1 = e;
                break block3;
            }
            v1 = null;
        }
        JBPopup popup2 = v1;
        if (popup2 != null) {
            result2.showNotificationIfFailed();
        } else {
            result2.showNotification();
        }
    }

    private final boolean isBusy(Project project) {
        return GitFetchSupport.fetchSupport(project).isFetchRunning() || GitBranchIncomingOutgoingManager.getInstance(project).isUpdating();
    }

    private static final void onFetchFinished$lambda$0() {
        ActivityTracker.getInstance().inc();
    }
}

