/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.i18n.GitBundle;
import git4idea.util.GitFileUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b\u001a(\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"createRevParseHandler", "Lgit4idea/commands/GitLineHandler;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "executable", "Lgit4idea/config/GitExecutable;", "abbrev", "", "getFileContent", "", "repositoryPath", "", "revisionOrBranch", "getFileContentAsString", "file", "getLocation", "intellij.vcs.git"})
public final class LightGitUtilKt {
    @NotNull
    public static final String getLocation(@NotNull VirtualFile directory, @NotNull GitExecutable executable) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        String string = Git.getInstance().runCommand(LightGitUtilKt.createRevParseHandler$default(directory, executable, false, 4, null)).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().runCommand\u2026able)).getOutputOrThrow()");
        String name = string;
        if (!Intrinsics.areEqual((Object)name, (Object)"HEAD")) {
            return name;
        }
        String string2 = Git.getInstance().runCommand(LightGitUtilKt.createRevParseHandler(directory, executable, false)).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInstance().runCommand\u2026alse)).getOutputOrThrow()");
        String hash = string2;
        if (VcsLogUtil.HASH_REGEX.matcher(hash).matches()) {
            String string3 = VcsLogUtil.getShortHash((String)hash);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getShortHash(hash)");
            return string3;
        }
        Object[] objectArray = new Object[]{directory.getPath()};
        throw new VcsException(GitBundle.message("git.light.cant.find.current.revision.exception.message", objectArray));
    }

    private static final GitLineHandler createRevParseHandler(VirtualFile directory, GitExecutable executable, boolean abbrev) {
        String[] stringArray;
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)directory), executable, GitCommand.REV_PARSE, CollectionsKt.emptyList());
        if (abbrev) {
            stringArray = new String[]{"--abbrev-ref"};
            handler.addParameters(stringArray);
        }
        stringArray = new String[]{"HEAD"};
        handler.addParameters(stringArray);
        handler.setSilent(true);
        return handler;
    }

    static /* synthetic */ GitLineHandler createRevParseHandler$default(VirtualFile virtualFile, GitExecutable gitExecutable, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return LightGitUtilKt.createRevParseHandler(virtualFile, gitExecutable, bl);
    }

    @NotNull
    public static final byte[] getFileContent(@NotNull VirtualFile directory, @NotNull String repositoryPath, @NotNull GitExecutable executable, @NotNull String revisionOrBranch) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        GitBinaryHandler h = new GitBinaryHandler(VfsUtilCore.virtualToIoFile((VirtualFile)directory), executable, GitCommand.CAT_FILE);
        GitFileUtils.addTextConvParameters(GitExecutableManager.getInstance().getVersion(executable), h, true);
        String[] stringArray = new String[]{revisionOrBranch + ":" + repositoryPath};
        h.addParameters(stringArray);
        byte[] byArray = h.run();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"h.run()");
        return byArray;
    }

    @NotNull
    public static final String getFileContentAsString(@NotNull VirtualFile file2, @NotNull String repositoryPath, @NotNull GitExecutable executable, @NotNull String revisionOrBranch) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)revisionOrBranch, (String)"revisionOrBranch");
        VirtualFile virtualFile = file2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
        byte[] vcsContent = LightGitUtilKt.getFileContent(virtualFile, repositoryPath, executable, revisionOrBranch);
        String string = VcsImplUtil.loadTextFromBytes(null, (byte[])vcsContent, (FilePath)VcsUtil.getFilePath((VirtualFile)file2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadTextFromBytes(null, \u2026csUtil.getFilePath(file))");
        return string;
    }

    public static /* synthetic */ String getFileContentAsString$default(VirtualFile virtualFile, String string, GitExecutable gitExecutable, String string2, int n, Object object) throws VcsException {
        if ((n & 8) != 0) {
            string2 = "HEAD";
        }
        return LightGitUtilKt.getFileContentAsString(virtualFile, string, gitExecutable, string2);
    }
}

