/*
 * Decompiled with CFR 0.152.
 */
package git4idea.light;

import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.BaseSingleTaskController;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.index.LightFileStatus;
import git4idea.light.LightGitEditorHighlighterManager;
import git4idea.light.LightGitTrackerKt;
import git4idea.light.LightGitTrackerListener;
import git4idea.light.LightGitUtilKt;
import git4idea.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 52\u00020\u0001:\b56789:;<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0001J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020'H\u0016J\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\"J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010,\u001a\u0004\u0018\u00010\"H\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010.2\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"01H\u0002J\u0010\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006="}, d2={"Lgit4idea/light/LightGitTracker;", "Lcom/intellij/openapi/Disposable;", "()V", "currentLocation", "", "getCurrentLocation", "()Ljava/lang/String;", "disposableFlag", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/light/LightGitTrackerListener;", "kotlin.jvm.PlatformType", "gitExecutable", "Lgit4idea/config/GitExecutable;", "getGitExecutable", "()Lgit4idea/config/GitExecutable;", "hasGit", "", "highlighterManager", "Lgit4idea/light/LightGitEditorHighlighterManager;", "lightEditService", "Lcom/intellij/ide/lightEdit/LightEditService;", "lightEditorManager", "Lcom/intellij/ide/lightEdit/LightEditorManager;", "listener", "Lgit4idea/light/LightGitTracker$MyLightEditorListener;", "singleTaskController", "Lgit4idea/light/LightGitTracker$MySingleTaskController;", "state", "Lgit4idea/light/LightGitTracker$State;", "statuses", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/index/LightFileStatus;", "getStatuses", "()Ljava/util/Map;", "addUpdateListener", "", "parent", "checkGit", "dispose", "getFileStatus", "file", "locationRequest", "Lgit4idea/light/LightGitTracker$Request;", "statusRequest", "files", "", "updateCurrentState", "updater", "Lgit4idea/light/LightGitTracker$StateUpdater;", "Companion", "MyBulkFileListener", "MyFrameStateListener", "MyLightEditorListener", "MySingleTaskController", "Request", "State", "StateUpdater", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nLightGitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1747#2,3:270\n1271#2,2:273\n1285#2,4:275\n*S KotlinDebug\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker\n*L\n85#1:270,3\n95#1:273,2\n95#1:275,4\n*E\n"})
public final class LightGitTracker
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CheckedDisposable disposableFlag;
    private final LightEditService lightEditService;
    @NotNull
    private final LightEditorManager lightEditorManager;
    @NotNull
    private final EventDispatcher<LightGitTrackerListener> eventDispatcher;
    @NotNull
    private final MySingleTaskController singleTaskController;
    @NotNull
    private final MyLightEditorListener listener;
    @NotNull
    private final LightGitEditorHighlighterManager highlighterManager;
    private volatile boolean hasGit;
    @NotNull
    private volatile State state;

    public LightGitTracker() {
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable()");
        this.disposableFlag = checkedDisposable;
        this.lightEditService = LightEditService.getInstance();
        LightEditorManager lightEditorManager = this.lightEditService.getEditorManager();
        Intrinsics.checkNotNullExpressionValue((Object)lightEditorManager, (String)"lightEditService.editorManager");
        this.lightEditorManager = lightEditorManager;
        EventDispatcher eventDispatcher = EventDispatcher.create(LightGitTrackerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(LightGitTrackerListener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.singleTaskController = new MySingleTaskController();
        this.listener = new MyLightEditorListener();
        this.state = State.Companion.getBlank();
        this.lightEditorManager.addListener((LightEditorListener)this.listener, (Disposable)this);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = ApplicationActivationListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MyFrameStateListener());
        MessageBusConnection messageBusConnection2 = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        messageBusConnection2.subscribe(topic2, (Object)new MyBulkFileListener());
        this.highlighterManager = new LightGitEditorHighlighterManager(this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.disposableFlag));
        Object[] objectArray = new Request[]{Request.CheckGit.INSTANCE};
        this.singleTaskController.request(objectArray);
        BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)this.disposableFlag, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                SingleTaskController singleTaskController = (SingleTaskController)singleTaskController;
                Object[] objectArray = new Request[2];
                objectArray[0] = this.locationRequest(lightEditService.getSelectedFile());
                Collection collection = lightEditorManager.getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"lightEditorManager.openFiles");
                objectArray[1] = this.statusRequest(collection);
                BaseSingleTaskControllerKt.sendRequests((SingleTaskController)singleTaskController, (Object[])objectArray);
            }
        }));
    }

    @NotNull
    public final GitExecutable getGitExecutable() {
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable((Project)null);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getInstance().getExecutable(null)");
        return gitExecutable;
    }

    @Nullable
    public final String getCurrentLocation() {
        return this.state.getLocation();
    }

    @NotNull
    public final Map<VirtualFile, LightFileStatus> getStatuses() {
        return this.state.getStatuses();
    }

    @NotNull
    public final LightFileStatus getFileStatus(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        LightFileStatus lightFileStatus = this.state.getStatuses().get(file2);
        if (lightFileStatus == null) {
            lightFileStatus = LightFileStatus.Blank.INSTANCE;
        }
        return lightFileStatus;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCurrentState(StateUpdater updater) {
        block13: {
            block12: {
                block11: {
                    var2_2 = updater;
                    if (!Intrinsics.areEqual((Object)var2_2, (Object)StateUpdater.Clear.INSTANCE)) break block12;
                    previousStatuses = this.state.getStatuses();
                    if (!(previousStatuses.isEmpty() == false)) ** GOTO lbl-1000
                    $this$any$iv = previousStatuses.values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (LightFileStatus)element$iv;
                            $i$a$-any-LightGitTracker$updateCurrentState$statusesChanged$1 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)LightFileStatus.Blank.INSTANCE) == false)) continue;
                            v0 = true;
                            break block11;
                        }
                        v0 = false;
                    }
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = statusesChanged = false;
                }
                changed = statusesChanged != false || (($i$f$any = (CharSequence)this.state.getLocation()) == null || StringsKt.isBlank((CharSequence)$i$f$any) != false) == false;
                this.state = State.Companion.getBlank();
                if (changed) {
                    ((LightGitTrackerListener)this.eventDispatcher.getMulticaster()).update();
                }
                if (statusesChanged) {
                    this.lightEditService.updateFileStatus((Collection)previousStatuses.keySet());
                }
                break block13;
            }
            if (var2_2 instanceof StateUpdater.Update) {
                newState = updater.getState();
                v2 = this.lightEditorManager.getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"lightEditorManager.openFiles");
                $this$associateWith$iv = v2;
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    var12_22 = (VirtualFile)element$iv$iv;
                    var15_25 = element$iv$iv;
                    var14_24 = result$iv;
                    $i$a$-associateWith-LightGitTracker$updateCurrentState$statusesMap$1 = false;
                    v3 = newState.getStatuses().get(it);
                    if (v3 == null && (v3 = this.state.getStatuses().get(it)) == null) {
                        v3 = LightFileStatus.Blank.INSTANCE;
                    }
                    var16_26 = v3;
                    var14_24.put(var15_25, var16_26);
                }
                statusesMap = result$iv;
                location = ((StateUpdater.Update)updater).getUpdateLocation() != false ? newState.getLocation() : this.state.getLocation();
                this.state = new State(location, statusesMap);
                ((LightGitTrackerListener)this.eventDispatcher.getMulticaster()).update();
                if (newState.getStatuses().isEmpty() == false) {
                    this.lightEditService.updateFileStatus((Collection)newState.getStatuses().keySet());
                }
            }
        }
    }

    private final void checkGit() {
        try {
            GitVersion gitVersion = GitExecutableManager.getInstance().identifyVersion(this.getGitExecutable());
            Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"getInstance().identifyVersion(gitExecutable)");
            GitVersion version = gitVersion;
            this.hasGit = version.isSupported();
        }
        catch (GitVersionIdentificationException e) {
            LightGitTrackerKt.access$getLOG$p().warn((Throwable)e);
            this.hasGit = false;
        }
    }

    private final Request locationRequest(VirtualFile file2) {
        if (file2 != null && file2.getParent() != null) {
            return new Request.Location(file2);
        }
        return null;
    }

    private final Request statusRequest(Collection<? extends VirtualFile> files) {
        List filesForRequest = new ArrayList();
        Iterator<? extends VirtualFile> iterator = files.iterator();
        while (iterator.hasNext()) {
            VirtualFile file2;
            VirtualFile virtualFile = file2 = iterator.next();
            if ((virtualFile != null ? virtualFile.getParent() : null) == null) continue;
            filesForRequest.add(file2);
        }
        if (filesForRequest.isEmpty()) {
            return null;
        }
        return new Request.Status(filesForRequest);
    }

    public final void addUpdateListener(@NotNull LightGitTrackerListener listener2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.eventDispatcher.addListener((EventListener)listener2, parent);
    }

    public void dispose() {
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LightGitTracker $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ void access$checkGit(LightGitTracker $this) {
        $this.checkGit();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lgit4idea/light/LightGitTracker$Companion;", "", "()V", "getInstance", "Lgit4idea/light/LightGitTracker;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LightGitTracker getInstance() {
            Object object = ApplicationManager.getApplication().getService(LightGitTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026htGitTracker::class.java)");
            return (LightGitTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/light/LightGitTracker$MyBulkFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lgit4idea/light/LightGitTracker;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nLightGitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker$MyBulkFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n766#2:270\n857#2,2:271\n1611#2:273\n1855#2:274\n1856#2:276\n1612#2:277\n1#3:275\n*S KotlinDebug\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker$MyBulkFileListener\n*L\n148#1:270\n148#1:271,2\n148#1:273\n148#1:274\n148#1:276\n148#1:277\n148#1:275\n*E\n"})
    private final class MyBulkFileListener
    implements BulkFileListener {
        /*
         * WARNING - void declaration
         */
        public void after(@NotNull List<? extends VFileEvent> events) {
            void destination$iv;
            void $this$mapNotNullTo$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (!LightGitTracker.this.hasGit) {
                return;
            }
            Iterable $this$filter$iv = events;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VFileEvent it = (VFileEvent)element$iv$iv;
                boolean bl = false;
                if (!(it.isFromSave() || it.isFromRefresh())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            Collection $i$f$filter22 = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                VFileEvent it = (VFileEvent)element$iv;
                boolean bl2 = false;
                if (it.getFile() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            Set targetFiles = (Set)destination$iv;
            SingleTaskController singleTaskController = (SingleTaskController)LightGitTracker.this.singleTaskController;
            Object[] objectArray = new Request[1];
            Collection collection = LightGitTracker.this.lightEditorManager.getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"lightEditorManager.openFiles");
            objectArray[0] = LightGitTracker.this.statusRequest(CollectionsKt.intersect((Iterable)collection, (Iterable)targetFiles));
            BaseSingleTaskControllerKt.sendRequests((SingleTaskController)singleTaskController, (Object[])objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgit4idea/light/LightGitTracker$MyFrameStateListener;", "Lcom/intellij/openapi/application/ApplicationActivationListener;", "(Lgit4idea/light/LightGitTracker;)V", "applicationActivated", "", "ideFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "intellij.vcs.git"})
    private final class MyFrameStateListener
    implements ApplicationActivationListener {
        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
            SingleTaskController singleTaskController = (SingleTaskController)LightGitTracker.this.singleTaskController;
            Object[] objectArray = new Request[3];
            objectArray[0] = Request.CheckGit.INSTANCE;
            objectArray[1] = LightGitTracker.this.locationRequest(LightGitTracker.this.lightEditService.getSelectedFile());
            Collection collection = LightGitTracker.this.lightEditorManager.getOpenFiles();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"lightEditorManager.openFiles");
            objectArray[2] = LightGitTracker.this.statusRequest(collection);
            BaseSingleTaskControllerKt.sendRequests((SingleTaskController)singleTaskController, (Object[])objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/light/LightGitTracker$MyLightEditorListener;", "Lcom/intellij/ide/lightEdit/LightEditorListener;", "(Lgit4idea/light/LightGitTracker;)V", "afterClose", "", "editorInfo", "Lcom/intellij/ide/lightEdit/LightEditorInfo;", "afterSelect", "intellij.vcs.git"})
    private final class MyLightEditorListener
    implements LightEditorListener {
        public void afterSelect(@Nullable LightEditorInfo editorInfo) {
            if (!LightGitTracker.this.hasGit) {
                return;
            }
            LightGitTracker.this.state = State.copy$default(LightGitTracker.this.state, null, null, 2, null);
            LightEditorInfo lightEditorInfo = editorInfo;
            VirtualFile selectedFile = lightEditorInfo != null ? lightEditorInfo.getFile() : null;
            Object[] objectArray = new Request[]{LightGitTracker.this.locationRequest(selectedFile), LightGitTracker.this.statusRequest(CollectionsKt.listOf((Object)selectedFile))};
            if (!BaseSingleTaskControllerKt.sendRequests((SingleTaskController)((SingleTaskController)LightGitTracker.this.singleTaskController), (Object[])objectArray)) {
                BaseSingleTaskControllerKt.runInEdt((CheckedDisposable)LightGitTracker.this.disposableFlag, (Function0)((Function0)new Function0<Unit>(LightGitTracker.this){
                    final /* synthetic */ LightGitTracker this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ((LightGitTrackerListener)LightGitTracker.access$getEventDispatcher$p(this.this$0).getMulticaster()).update();
                    }
                }));
            }
        }

        public void afterClose(@NotNull LightEditorInfo editorInfo) {
            Intrinsics.checkNotNullParameter((Object)editorInfo, (String)"editorInfo");
            State state2 = LightGitTracker.this.state;
            Map<VirtualFile, LightFileStatus> map2 = LightGitTracker.this.state.getStatuses();
            VirtualFile virtualFile = editorInfo.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"editorInfo.file");
            LightGitTracker.this.state = State.copy$default(state2, null, CollectionUtilKt.without(map2, virtualFile), 1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/light/LightGitTracker$MySingleTaskController;", "Lcom/intellij/vcs/log/BaseSingleTaskController;", "Lgit4idea/light/LightGitTracker$Request;", "Lgit4idea/light/LightGitTracker$StateUpdater;", "(Lgit4idea/light/LightGitTracker;)V", "process", "requests", "", "previousResult", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nLightGitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker$MySingleTaskController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1446#2,5:270\n1#3:275\n*S KotlinDebug\n*F\n+ 1 LightGitTracker.kt\ngit4idea/light/LightGitTracker$MySingleTaskController\n*L\n187#1:270,5\n*E\n"})
    private final class MySingleTaskController
    extends BaseSingleTaskController<Request, StateUpdater> {
        public MySingleTaskController() {
            super("light.tracker", (Function1)new Function1<StateUpdater, Unit>((Object)LightGitTracker.this){

                public final void invoke(@NotNull StateUpdater p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((LightGitTracker)this.receiver).updateCurrentState(p0);
                }
            }, LightGitTracker.this.disposableFlag);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public StateUpdater process(@NotNull List<? extends Request> requests, @Nullable StateUpdater previousResult) {
            Intrinsics.checkNotNullParameter(requests, (String)"requests");
            if (requests.contains(Request.CheckGit.INSTANCE)) {
                LightGitTracker.access$checkGit(LightGitTracker.this);
            }
            if (!LightGitTracker.access$getHasGit$p(LightGitTracker.this)) {
                return StateUpdater.Clear.INSTANCE;
            }
            v0 = CollectionUtilKt.lastInstance(requests, Request.Location.class);
            locationFile = v0 != null ? v0.getFile() : null;
            var5_4 = CollectionsKt.filterIsInstance((Iterable)requests, Request.Status.class);
            var6_5 = new LinkedHashSet<E>();
            $i$f$flatMapTo = false;
            for (T element$iv : $this$flatMapTo$iv) {
                it = (Request.Status)element$iv;
                $i$a$-flatMapTo-LightGitTracker$MySingleTaskController$process$files$1 = false;
                list$iv = it.getFiles();
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
            files = (Set)destination$iv;
            if (locationFile != null) {
                try {
                    v1 = locationFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"locationFile.parent");
                    destination$iv = LightGitUtilKt.getLocation(v1, LightGitTracker.this.getGitExecutable());
                }
                catch (VcsException _) {
                    destination$iv = null;
                }
                v2 = destination$iv;
            } else {
                v3 = previousResult;
                v2 = v3 != null && (v3 = v3.getState()) != null ? v3.getLocation() : (location = null);
            }
            if (locationFile != null) ** GOTO lbl-1000
            v4 = previousResult instanceof StateUpdater.Update != false ? (StateUpdater.Update)previousResult : null;
            if (v4 != null ? v4.getUpdateLocation() : false) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            updateLocation = v5;
            statuses = new LinkedHashMap<K, V>();
            v6 = previousResult;
            if (v6 != null && (v6 = v6.getState()) != null && (v6 = v6.getStatuses()) != null) {
                it = var10_12 = v6;
                $i$a$-let-LightGitTracker$MySingleTaskController$process$1 = false;
                statuses.putAll(it);
            }
            for (VirtualFile file : files) {
                try {
                    if (Intrinsics.areEqual((Object)file, (Object)locationFile) && location == null) continue;
                    var10_12 = statuses;
                    v7 = file.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"file.parent");
                    v8 = VcsUtil.getFilePath((VirtualFile)file);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getFilePath(file)");
                    var11_16 = GitIndexStatusUtilKt.getFileStatus(v7, v8, LightGitTracker.this.getGitExecutable());
                    var10_12.put(file, var11_16);
                }
                catch (VcsException var10_13) {}
            }
            return new StateUpdater.Update(new State(location, statuses), updateLocation);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lgit4idea/light/LightGitTracker$Request;", "", "()V", "CheckGit", "Location", "Status", "Lgit4idea/light/LightGitTracker$Request$CheckGit;", "Lgit4idea/light/LightGitTracker$Request$Location;", "Lgit4idea/light/LightGitTracker$Request$Status;", "intellij.vcs.git"})
    private static abstract class Request {
        private Request() {
        }

        public /* synthetic */ Request(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgit4idea/light/LightGitTracker$Request$CheckGit;", "Lgit4idea/light/LightGitTracker$Request;", "()V", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
        public static final class CheckGit
        extends Request {
            @NotNull
            public static final CheckGit INSTANCE = new CheckGit();

            private CheckGit() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CheckGit";
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lgit4idea/light/LightGitTracker$Request$Location;", "Lgit4idea/light/LightGitTracker$Request;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
        public static final class Location
        extends Request {
            @NotNull
            private final VirtualFile file;

            public Location(@NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                super(null);
                this.file = file2;
            }

            @NotNull
            public final VirtualFile getFile() {
                return this.file;
            }

            @NotNull
            public String toString() {
                return "Location(file=" + this.file + ")";
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lgit4idea/light/LightGitTracker$Request$Status;", "Lgit4idea/light/LightGitTracker$Request;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/Collection;)V", "getFiles", "()Ljava/util/Collection;", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
        @NonNls
        public static final class Status
        extends Request {
            @NotNull
            private final Collection<VirtualFile> files;

            public Status(@NotNull Collection<? extends VirtualFile> files) {
                Intrinsics.checkNotNullParameter(files, (String)"files");
                super(null);
                this.files = files;
            }

            @NotNull
            public final Collection<VirtualFile> getFiles() {
                return this.files;
            }

            @NotNull
            public String toString() {
                return "Status(files=" + CollectionUtilKt.toShortenedLogString$default(this.files, null, 0, null, 7, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\r\u0010\u0016\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0017H\u0017R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lgit4idea/light/LightGitTracker$State;", "", "()V", "location", "", "statuses", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lgit4idea/index/LightFileStatus;", "(Ljava/lang/String;Ljava/util/Map;)V", "getLocation", "()Ljava/lang/String;", "getStatuses", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Lorg/jetbrains/annotations/NonNls;", "Companion", "intellij.vcs.git"})
    private static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String location;
        @NotNull
        private final Map<VirtualFile, LightFileStatus> statuses;
        @NotNull
        private static final State Blank = new State();

        public State(@Nullable String location, @NotNull Map<VirtualFile, ? extends LightFileStatus> statuses) {
            Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
            this.location = location;
            this.statuses = statuses;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        @NotNull
        public final Map<VirtualFile, LightFileStatus> getStatuses() {
            return this.statuses;
        }

        private State() {
            this(null, MapsKt.emptyMap());
        }

        @NonNls
        @NotNull
        public String toString() {
            return "State(location=" + this.location + ", statuses=" + CollectionUtilKt.toShortenedLogString$default(this.statuses, null, 0, null, 7, null) + ")";
        }

        @Nullable
        public final String component1() {
            return this.location;
        }

        @NotNull
        public final Map<VirtualFile, LightFileStatus> component2() {
            return this.statuses;
        }

        @NotNull
        public final State copy(@Nullable String location, @NotNull Map<VirtualFile, ? extends LightFileStatus> statuses) {
            Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
            return new State(location, statuses);
        }

        public static /* synthetic */ State copy$default(State state2, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = state2.location;
            }
            if ((n & 2) != 0) {
                map2 = state2.statuses;
            }
            return state2.copy(string, map2);
        }

        public int hashCode() {
            int result2 = this.location == null ? 0 : this.location.hashCode();
            result2 = result2 * 31 + ((Object)this.statuses).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual((Object)this.location, (Object)state2.location)) {
                return false;
            }
            return Intrinsics.areEqual(this.statuses, state2.statuses);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/light/LightGitTracker$State$Companion;", "", "()V", "Blank", "Lgit4idea/light/LightGitTracker$State;", "getBlank", "()Lgit4idea/light/LightGitTracker$State;", "intellij.vcs.git"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final State getBlank() {
                return Blank;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/light/LightGitTracker$StateUpdater;", "", "state", "Lgit4idea/light/LightGitTracker$State;", "(Lgit4idea/light/LightGitTracker$State;)V", "getState", "()Lgit4idea/light/LightGitTracker$State;", "Clear", "Update", "Lgit4idea/light/LightGitTracker$StateUpdater$Clear;", "Lgit4idea/light/LightGitTracker$StateUpdater$Update;", "intellij.vcs.git"})
    private static abstract class StateUpdater {
        @NotNull
        private final State state;

        private StateUpdater(State state2) {
            this.state = state2;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        public /* synthetic */ StateUpdater(State state2, DefaultConstructorMarker $constructor_marker) {
            this(state2);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgit4idea/light/LightGitTracker$StateUpdater$Clear;", "Lgit4idea/light/LightGitTracker$StateUpdater;", "()V", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
        public static final class Clear
        extends StateUpdater {
            @NotNull
            public static final Clear INSTANCE = new Clear();

            private Clear() {
                super(State.Companion.getBlank(), null);
            }

            @NotNull
            public String toString() {
                return "Clear";
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lgit4idea/light/LightGitTracker$StateUpdater$Update;", "Lgit4idea/light/LightGitTracker$StateUpdater;", "s", "Lgit4idea/light/LightGitTracker$State;", "updateLocation", "", "(Lgit4idea/light/LightGitTracker$State;Z)V", "getUpdateLocation", "()Z", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
        public static final class Update
        extends StateUpdater {
            private final boolean updateLocation;

            public Update(@NotNull State s, boolean updateLocation) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                super(s, null);
                this.updateLocation = updateLocation;
            }

            public final boolean getUpdateLocation() {
                return this.updateLocation;
            }

            @NotNull
            public String toString() {
                return "Update(state=" + this.getState() + ", updateLocation=" + this.updateLocation + ")";
            }
        }
    }
}

