/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lgit4idea/checkin/GitCheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelectedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runGitCheck", "intellij.vcs.git"})
abstract class GitCheckinHandler
extends CheckinHandler
implements CommitCheck {
    @NotNull
    private final Project project;

    public GitCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        if (!commitInfo.isVcsCommit()) {
            return null;
        }
        return this.runGitCheck(commitInfo, $completion);
    }

    @Nullable
    public abstract Object runGitCheck(@NotNull CommitInfo var1, @NotNull Continuation<? super CommitProblem> var2);

    @NotNull
    protected final Collection<VirtualFile> getSelectedRoots(@NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(project)");
        GitVcs git = gitVcs;
        Set result2 = new LinkedHashSet();
        for (FilePath path : ChangesUtil.getPaths((Collection)commitInfo.getCommittedChanges())) {
            VirtualFile root;
            VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(path);
            if (vcsRoot == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vcsRoot.getPath(), (String)"vcsRoot.path");
            if (!Intrinsics.areEqual((Object)((Object)git), (Object)vcsRoot.getVcs())) continue;
            result2.add(root);
        }
        return result2;
    }
}

