/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.wizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SystemProperties;
import java.util.Locale;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.Context;
import org.jetbrains.kotlin.tools.projectWizard.core.TaskResult;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.PipelineTask;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.ValidationResult;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PathSettingType;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PluginSetting;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.PluginSettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.SettingReference;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.SettingType;
import org.jetbrains.kotlin.tools.projectWizard.core.entity.settings.StringSettingType;
import org.jetbrains.kotlin.tools.projectWizard.phases.GenerationPhase;
import org.jetbrains.kotlin.tools.projectWizard.plugins.StructurePlugin;
import org.jetbrains.kotlin.tools.projectWizard.wizard.IdeWizard;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ModuleNewWizardFirstStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.WizardStep;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ui.UiKt;
import org.jetbrains.kotlin.tools.projectWizard.wizard.ui.firstStep.FirstWizardStepComponent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep;", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/WizardStep;", "wizard", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/kotlin/tools/projectWizard/wizard/IdeWizard;Lcom/intellij/openapi/Disposable;)V", "component", "Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ui/firstStep/FirstWizardStepComponent;", "getComponent", "Ljavax/swing/JComponent;", "handleErrors", "", "error", "Lorg/jetbrains/kotlin/tools/projectWizard/core/entity/ValidationResult$ValidationError;", "initDefaultValues", "runPreparePhase", "Lorg/jetbrains/kotlin/tools/projectWizard/core/TaskResult;", "suggestGroupId", "", "Companion", "kotlin.project-wizard.idea"})
public final class ModuleNewWizardFirstStep
extends WizardStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirstWizardStepComponent component;
    @NotNull
    private static final String DEFAULT_GROUP_ID = "me.user";

    public ModuleNewWizardFirstStep(@NotNull IdeWizard wizard, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)wizard, (String)"wizard");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(wizard, GenerationPhase.FIRST_STEP);
        this.component = new FirstWizardStepComponent(wizard);
        this.runPreparePhase();
        this.initDefaultValues();
        this.component.onInit();
        Disposer.register((Disposable)disposable, (Disposable)this.component);
    }

    @NotNull
    public JComponent getComponent() {
        return this.component.getComponent();
    }

    private final TaskResult<Unit> runPreparePhase() {
        return (TaskResult)UiKt.runWithProgressBar("", (Function0)new Function0<TaskResult<? extends Unit>>(this){
            final /* synthetic */ ModuleNewWizardFirstStep this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TaskResult<Unit> invoke() {
                return this.this$0.getWizard().apply(CollectionsKt.emptyList(), SetsKt.setOf((Object)((Object)GenerationPhase.PREPARE)), (Function1<? super PipelineTask, Unit>)((Function1)runPreparePhase.1.INSTANCE));
            }
        });
    }

    @Override
    protected void handleErrors(@NotNull ValidationResult.ValidationError error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.component.navigateTo(error2);
    }

    private final void initDefaultValues() {
        String suggestedProjectParentLocation = RecentProjectsManager.Companion.getInstance().suggestNewProjectLocation();
        String suggestedProjectName = ProjectWizardUtil.findNonExistingFileName((String)suggestedProjectParentLocation, (String)"untitled", (String)"");
        this.getWizard().getContext().writeSettings((Function1)new Function1<Context.SettingsWriter, Unit>(suggestedProjectName, suggestedProjectParentLocation, this){
            final /* synthetic */ String $suggestedProjectName;
            final /* synthetic */ String $suggestedProjectParentLocation;
            final /* synthetic */ ModuleNewWizardFirstStep this$0;
            {
                this.$suggestedProjectName = $suggestedProjectName;
                this.$suggestedProjectParentLocation = $suggestedProjectParentLocation;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Context.SettingsWriter $this$writeSettings) {
                Intrinsics.checkNotNullParameter((Object)$this$writeSettings, (String)"$this$writeSettings");
                PluginSetting<Object, SettingType> $this$reference$iv = StructurePlugin.Companion.getName();
                boolean $i$f$getReference = false;
                $this$writeSettings.setValue((SettingReference)new PluginSettingReference<V, T>($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class)), this.$suggestedProjectName);
                $this$reference$iv = StructurePlugin.Companion.getProjectPath();
                $i$f$getReference = false;
                SettingReference settingReference = new PluginSettingReference<V, T>($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(PathSettingType.class));
                String string2 = this.$suggestedProjectName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestedProjectName");
                $this$writeSettings.setValue(settingReference, UtilsKt.div(this.$suggestedProjectParentLocation, string2));
                $this$reference$iv = StructurePlugin.Companion.getArtifactId();
                $i$f$getReference = false;
                $this$writeSettings.setValue((SettingReference)new PluginSettingReference<V, T>($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class)), this.$suggestedProjectName);
                if ($this$writeSettings.getNotRequiredSettingValue(StructurePlugin.Companion.getGroupId()) == null) {
                    $this$reference$iv = StructurePlugin.Companion.getGroupId();
                    $i$f$getReference = false;
                    $this$writeSettings.setValue((SettingReference)new PluginSettingReference<V, T>($this$reference$iv.getPath(), Reflection.getOrCreateKotlinClass(StringSettingType.class)), ModuleNewWizardFirstStep.access$suggestGroupId(this.this$0));
                }
            }
        });
    }

    private final String suggestGroupId() {
        String string2 = SystemProperties.getUserName();
        if (string2 == null) {
            return DEFAULT_GROUP_ID;
        }
        String username = string2;
        CharSequence charSequence2 = username;
        if (!new Regex("[\\w\\s]+").matches(charSequence2)) {
            return DEFAULT_GROUP_ID;
        }
        CharSequence charSequence3 = ((Object)StringsKt.trim((CharSequence)username)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string3 = charSequence3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        charSequence3 = string3;
        Regex regex = new Regex("\\s+");
        int n = 0;
        String usernameAsGroupId = CollectionsKt.joinToString$default((Iterable)regex.split(charSequence3, n), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return "me." + usernameAsGroupId;
    }

    public static final /* synthetic */ String access$suggestGroupId(ModuleNewWizardFirstStep $this) {
        return $this.suggestGroupId();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/wizard/ModuleNewWizardFirstStep$Companion;", "", "()V", "DEFAULT_GROUP_ID", "", "kotlin.project-wizard.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

