/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.JavaTestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.CommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.testIntegration.KotlinTestFinder$findSourceElement$;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/KotlinTestFinder;", "Lcom/intellij/testIntegration/JavaTestFinder;", "()V", "findClassesForTest", "", "Lcom/intellij/psi/PsiElement;", "element", "findSourceElement", "Lcom/intellij/psi/PsiClass;", "from", "findTestsForClass", "isTest", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinTestFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTestFinder.kt\norg/jetbrains/kotlin/idea/testIntegration/KotlinTestFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n473#3:102\n179#3,2:103\n1620#4,3:105\n*S KotlinDebug\n*F\n+ 1 KotlinTestFinder.kt\norg/jetbrains/kotlin/idea/testIntegration/KotlinTestFinder\n*L\n31#1:102\n31#1:103,2\n57#1:105,3\n*E\n"})
public final class KotlinTestFinder
extends JavaTestFinder {
    @Nullable
    public PsiClass findSourceElement(@NotNull PsiElement from) {
        Object v1;
        PsiClass psiClass2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            psiClass2 = super.findSourceElement(from);
            if (psiClass2 != null) {
                PsiClass it = psiClass2;
                boolean bl = false;
                return it;
            }
            Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)from);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findSourceElement$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!(!it.isLocal())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        psiClass2 = v1;
        if (psiClass2 != null) {
            PsiClass it = psiClass2;
            boolean bl = false;
            return ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)it, null, 1, null) == null ? null : (PsiClass)LightClassUtilsKt.toLightClass((KtClassOrObject)it);
        }
        PsiFile psiFile2 = from.getContainingFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        return (PsiClass)(ktFile != null ? LightClassUtilsKt.findFacadeClass((KtFile)ktFile) : null);
    }

    public boolean isTest(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return false;
        }
        PsiClass sourceElement = psiClass2;
        return super.isTest((PsiElement)sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass2;
        GlobalSearchScope scope2 = this.getSearchScope(element3, true);
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)element3.getProject());
        TestFrameworks frameworks = TestFrameworks.getInstance();
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair candidateNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)klass2.getName())) {
            PsiClass[] psiClassArray;
            Intrinsics.checkNotNullExpressionValue((Object)cache2.getClassesByName((String)candidateNameWithWeight.first, scope2), (String)"cache.getClassesByName(c\u2026eWithWeight.first, scope)");
            for (PsiClass eachClass : psiClassArray) {
                if (eachClass.isAnnotationType() || frameworks.isTestClass(eachClass)) continue;
                if (eachClass instanceof KtLightClassForFacade) {
                    Iterable $this$mapTo$iv = ((KtLightClassForFacade)eachClass).getFiles();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        KtFile ktFile = (KtFile)item$iv;
                        Collection collection = classesWithWeights;
                        boolean bl = false;
                        collection.add(Pair.create((Object)it, (Object)candidateNameWithWeight.second));
                    }
                    continue;
                }
                if (!eachClass.isPhysical() && !(eachClass instanceof KtLightClassForSourceDeclaration)) continue;
                classesWithWeights.add(Pair.create((Object)eachClass, (Object)candidateNameWithWeight.second));
            }
        }
        List list2 = TestFinderHelper.getSortedElements((List)classesWithWeights, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSortedElements(classesWithWeights, false)");
        return list2;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass2;
        ArrayList classesWithProximities = new ArrayList();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor((Collection)classesWithProximities);
        String string2 = klass2.getName();
        Intrinsics.checkNotNull((Object)string2);
        String klassName = string2;
        Pattern pattern2 = Pattern.compile(".*" + StringUtil.escapeToRegexp((String)klassName) + ".*", 2);
        GlobalSearchScope scope2 = this.getSearchScope((PsiElement)klass2, false);
        TestFrameworks frameworks = TestFrameworks.getInstance();
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)klass2.getProject());
        String[] stringArray = cache2.getAllClassNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cache.allClassNames");
        block0: for (String candidateName : stringArray) {
            PsiClass[] psiClassArray;
            if (!pattern2.matcher(candidateName).matches()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)cache2.getClassesByName(candidateName, scope2), (String)"cache.getClassesByName(candidateName, scope)");
            for (PsiClass candidateClass : psiClassArray) {
                if (!(!frameworks.isTestClass(candidateClass) && !frameworks.isPotentialTestClass(candidateClass) || !candidateClass.isPhysical() && !(candidateClass instanceof KtLightClassForSourceDeclaration) || processor2.process((Object)Pair.create((Object)candidateClass, (Object)TestFinderHelper.calcTestNameProximity((String)klassName, (String)candidateName))))) break block0;
            }
        }
        List list2 = TestFinderHelper.getSortedElements((List)classesWithProximities, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSortedElements(classesWithProximities, true)");
        return list2;
    }
}

