/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.fixes;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithVisibility;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.KtSymbolFromIndexProvider;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactory;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactoryKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixActionBase;
import org.jetbrains.kotlin.idea.quickfix.fixes.ImportQuickFix;
import org.jetbrains.kotlin.idea.quickfix.fixes.ImportQuickFixKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001e\u001fB\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0096\u0002J\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0014J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/fixes/ImportQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInspection/HintAction;", "element", "importCandidates", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/util/List;)V", "modificationCountOnCreate", "", "createAddImportAction", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "fixSilently", "", "getFamilyName", "", "getText", "invoke", "", "Lcom/intellij/psi/PsiFile;", "isAvailableImpl", "isOutdated", "showHint", "Companion", "ImportQuestionAction", "kotlin.fir"})
public final class ImportQuickFix
extends QuickFixActionBase<KtElement>
implements HintAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FqName> importCandidates;
    private final long modificationCountOnCreate;
    @NotNull
    private static final KotlinDiagnosticFixFactory<KtFirDiagnostic.UnresolvedReference> FACTORY = KotlinDiagnosticFixFactoryKt.diagnosticFixFactory(Reflection.getOrCreateKotlinClass(KtFirDiagnostic.UnresolvedReference.class), Companion.FACTORY.1.INSTANCE);

    public ImportQuickFix(@NotNull KtElement element3, @NotNull List<FqName> importCandidates) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(importCandidates, (String)"importCandidates");
        super((PsiElement)element3);
        this.importCandidates = importCandidates;
        if (!(!((Collection)this.importCandidates).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.modificationCountOnCreate = PsiModificationTracker.getInstance((Project)element3.getProject()).getModificationCount();
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.import", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.import", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile)) {
            return;
        }
        this.createAddImportAction(project2, editor2, (KtFile)file2).execute();
    }

    private final QuestionAction createAddImportAction(Project project2, Editor editor2, KtFile file2) {
        return new ImportQuestionAction(project2, editor2, file2, this.importCandidates);
    }

    public boolean showHint(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element3 = ktElement;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            return false;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        KtFile file2 = ktFile;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        TextRange elementRange = element3.getTextRange();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)((FqName)CollectionsKt.first(this.importCandidates)).asString(), (String)"importCandidates.first().asString()");
        String autoImportHintText = KotlinBundle.message("fix.import.question", objectArray);
        HintManager.getInstance().showQuestionHint(editor2, autoImportHintText, elementRange.getStartOffset(), elementRange.getEndOffset(), this.createAddImportAction(project3, editor2, file2));
        return true;
    }

    public boolean fixSilently(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        KtElement ktElement = (KtElement)this.getElement();
        if (ktElement == null) {
            return false;
        }
        KtElement element3 = ktElement;
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        KtFile file2 = ktFile;
        if (!DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled()) {
            return false;
        }
        if (!ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled((PsiFile)((PsiFile)file2))) {
            return false;
        }
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        QuestionAction addImportAction = this.createAddImportAction(project3, editor2, file2);
        if (this.importCandidates.size() == 1) {
            addImportAction.execute();
            return true;
        }
        return false;
    }

    private final boolean isOutdated(Project project2) {
        return this.modificationCountOnCreate != PsiModificationTracker.getInstance((Project)project2).getModificationCount();
    }

    @Override
    protected boolean isAvailableImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return super.isAvailableImpl(project2, editor2, file2) && !this.isOutdated(project2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J$\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u0017*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u001bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/fixes/ImportQuickFix$Companion;", "", "()V", "FACTORY", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinDiagnosticFixFactory;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KtFirDiagnostic$UnresolvedReference;", "getFACTORY", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinDiagnosticFixFactory;", "collectCallableCandidates", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "indexProvider", "Lorg/jetbrains/kotlin/idea/base/analysis/api/utils/KtSymbolFromIndexProvider;", "unresolvedName", "Lorg/jetbrains/kotlin/name/Name;", "isVisible", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "", "collectTypesCandidates", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtNamedClassOrObjectSymbol;", "createImportNameFix", "Lorg/jetbrains/kotlin/idea/quickfix/fixes/ImportQuickFix;", "element", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "createImportTypeFix", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "kotlin.fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinDiagnosticFixFactory<KtFirDiagnostic.UnresolvedReference> getFACTORY() {
            return FACTORY;
        }

        @Nullable
        public final ImportQuickFix createImportNameFix(@NotNull KtAnalysisSession $this$createImportNameFix, @NotNull KtSymbolFromIndexProvider indexProvider, @NotNull KtReferenceExpression element3, @NotNull Name unresolvedName) {
            Intrinsics.checkNotNullParameter((Object)$this$createImportNameFix, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)indexProvider, (String)"indexProvider");
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)unresolvedName, (String)"unresolvedName");
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            KtFileSymbol firFile = $this$createImportNameFix.getFileSymbol(ktFile);
            Function1 isVisible2 = (Function1)new Function1<KtSymbol, Boolean>($this$createImportNameFix, firFile, element3){
                final /* synthetic */ KtAnalysisSession $this_createImportNameFix;
                final /* synthetic */ KtFileSymbol $firFile;
                final /* synthetic */ KtReferenceExpression $element;
                {
                    this.$this_createImportNameFix = $receiver;
                    this.$firFile = $firFile;
                    this.$element = $element;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !(it instanceof KtSymbolWithVisibility) || this.$this_createImportNameFix.isVisible((KtSymbolWithVisibility)it, this.$firFile, null, (PsiElement)this.$element);
                }
            };
            List<FqName> callableCandidates = this.collectCallableCandidates($this$createImportNameFix, indexProvider, unresolvedName, (Function1<? super KtCallableSymbol, Boolean>)isVisible2);
            List<FqName> typeCandidates = this.collectTypesCandidates($this$createImportNameFix, indexProvider, unresolvedName, (Function1<? super KtNamedClassOrObjectSymbol, Boolean>)isVisible2);
            List importCandidates = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)callableCandidates, (Iterable)typeCandidates));
            if (importCandidates.isEmpty()) {
                return null;
            }
            return new ImportQuickFix((KtElement)element3, importCandidates);
        }

        private final ImportQuickFix createImportTypeFix(KtAnalysisSession $this$createImportTypeFix, KtSymbolFromIndexProvider indexProvider, KtTypeReference element3) {
            KtFile ktFile = element3.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
            KtFileSymbol firFile = $this$createImportTypeFix.getFileSymbol(ktFile);
            Name name2 = ImportQuickFixKt.access$getTypeName(element3);
            if (name2 == null) {
                return null;
            }
            Name unresolvedName = name2;
            Function1 isVisible2 = (Function1)new Function1<KtNamedClassOrObjectSymbol, Boolean>($this$createImportTypeFix, firFile, element3){
                final /* synthetic */ KtAnalysisSession $this_createImportTypeFix;
                final /* synthetic */ KtFileSymbol $firFile;
                final /* synthetic */ KtTypeReference $element;
                {
                    this.$this_createImportTypeFix = $receiver;
                    this.$firFile = $firFile;
                    this.$element = $element;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtNamedClassOrObjectSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$this_createImportTypeFix.isVisible(it, this.$firFile, null, (PsiElement)this.$element);
                }
            };
            List acceptableClasses = CollectionsKt.distinct((Iterable)this.collectTypesCandidates($this$createImportTypeFix, indexProvider, unresolvedName, (Function1<? super KtNamedClassOrObjectSymbol, Boolean>)isVisible2));
            if (acceptableClasses.isEmpty()) {
                return null;
            }
            return new ImportQuickFix((KtElement)element3, acceptableClasses);
        }

        private final List<FqName> collectCallableCandidates(KtAnalysisSession $this$collectCallableCandidates, KtSymbolFromIndexProvider indexProvider, Name unresolvedName, Function1<? super KtCallableSymbol, Boolean> isVisible2) {
            Sequence callablesCandidates2 = SequencesKt.plus(indexProvider.getKotlinCallableSymbolsByName($this$collectCallableCandidates, unresolvedName, (Function1<? super KtCallableDeclaration, Boolean>)((Function1)collectCallableCandidates.callablesCandidates.1.INSTANCE)), indexProvider.getJavaCallableSymbolsByName($this$collectCallableCandidates, unresolvedName, (Function1<? super PsiMember, Boolean>)((Function1)collectCallableCandidates.callablesCandidates.2.INSTANCE)));
            return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)callablesCandidates2, isVisible2), (Function1)collectCallableCandidates.1.INSTANCE));
        }

        private final List<FqName> collectTypesCandidates(KtAnalysisSession $this$collectTypesCandidates, KtSymbolFromIndexProvider indexProvider, Name unresolvedName, Function1<? super KtNamedClassOrObjectSymbol, Boolean> isVisible2) {
            Sequence classesCandidates2 = SequencesKt.plus(indexProvider.getKotlinClassesByName($this$collectTypesCandidates, unresolvedName, (Function1<? super KtClassOrObject, Boolean>)((Function1)collectTypesCandidates.classesCandidates.1.INSTANCE)), indexProvider.getJavaClassesByName($this$collectTypesCandidates, unresolvedName, (Function1<? super PsiClass, Boolean>)((Function1)collectTypesCandidates.classesCandidates.2.INSTANCE)));
            return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)classesCandidates2, isVisible2), (Function1)collectTypesCandidates.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ ImportQuickFix access$createImportTypeFix(Companion $this, KtAnalysisSession $receiver, KtSymbolFromIndexProvider indexProvider, KtTypeReference element3) {
            return $this.createImportTypeFix($receiver, indexProvider, element3);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/fixes/ImportQuickFix$ImportQuestionAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importCandidates", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;Ljava/util/List;)V", "addImport", "", "nameToImport", "createImportSelectorPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "execute", "", "kotlin.fir"})
    private static final class ImportQuestionAction
    implements QuestionAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;
        @NotNull
        private final List<FqName> importCandidates;

        public ImportQuestionAction(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtFile file2, @NotNull List<FqName> importCandidates) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(importCandidates, (String)"importCandidates");
            this.project = project2;
            this.editor = editor2;
            this.file = file2;
            this.importCandidates = importCandidates;
            if (!(!((Collection)this.importCandidates).isEmpty())) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        public boolean execute() {
            switch (this.importCandidates.size()) {
                case 1: {
                    this.addImport((FqName)CollectionsKt.single(this.importCandidates));
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return false;
            }
            this.createImportSelectorPopup().showInBestPositionFor(this.editor);
            return true;
        }

        private final JBPopup createImportSelectorPopup() {
            JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(this.importCandidates).setTitle(KotlinBundle.message("action.add.import.chooser.title", new Object[0])).setItemChosenCallback(arg_0 -> ImportQuestionAction.createImportSelectorPopup$lambda$0((Function1)new Function1<FqName, Unit>(this){
                final /* synthetic */ ImportQuestionAction this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull FqName selectedValue) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    ImportQuestionAction.access$addImport(this.this$0, selectedValue);
                }
            }, arg_0)).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"private fun createImport\u2026 .createPopup()\n        }");
            return jBPopup;
        }

        private final void addImport(FqName nameToImport) {
            String string2 = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"add.import\")");
            ApplicationUtilsKt.executeWriteCommand(this.project, string2, (Function0<Unit>)((Function0)new Function0<Unit>(this, nameToImport){
                final /* synthetic */ ImportQuestionAction this$0;
                final /* synthetic */ FqName $nameToImport;
                {
                    this.this$0 = $receiver;
                    this.$nameToImport = $nameToImport;
                    super(0);
                }

                public final void invoke() {
                    ImportInsertionKt.addImport$default(ImportQuestionAction.access$getFile$p(this.this$0), this.$nameToImport, false, null, null, 14, null);
                }
            }));
        }

        private static final void createImportSelectorPopup$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$addImport(ImportQuestionAction $this, FqName nameToImport) {
            $this.addImport(nameToImport);
        }

        public static final /* synthetic */ KtFile access$getFile$p(ImportQuestionAction $this) {
            return $this.file;
        }
    }
}

