/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TooLongCharLiteralToStringFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Factory", "kotlin.idea"})
public final class TooLongCharLiteralToStringFix
extends KotlinQuickFixAction<KtConstantExpression> {
    @NotNull
    public static final Factory Factory = new Factory(null);

    public TooLongCharLiteralToStringFix(@NotNull KtConstantExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("convert.too.long.character.literal.to.string", new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtConstantExpression ktConstantExpression = (KtConstantExpression)this.getElement();
        if (ktConstantExpression == null) {
            return;
        }
        KtConstantExpression element3 = ktConstantExpression;
        String text2 = element3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)text2, (String)"text");
        if (!StringsKt.startsWith$default((String)text2, (String)"'", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)text2, (String)"'", (boolean)false, (int)2, null) || text2.length() < 2) {
            return;
        }
        String newStringContent = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.slice((String)text2, (IntRange)new IntRange(1, text2.length() - 2)), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        KtStringTemplateExpression newElement = new KtPsiFactory(project2, false, 2, null).createStringTemplate(newStringContent);
        element3.replace((PsiElement)newElement);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TooLongCharLiteralToStringFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        private Factory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtConstantExpression ktConstantExpression = psiElement2 instanceof KtConstantExpression ? (KtConstantExpression)psiElement2 : null;
            if (ktConstantExpression == null) {
                return null;
            }
            KtConstantExpression element3 = ktConstantExpression;
            if (Intrinsics.areEqual((Object)element3.getText(), (Object)"'\\'")) {
                return null;
            }
            String string2 = element3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.text");
            if (StringsKt.startsWith$default((String)string2, (String)"\"", (boolean)false, (int)2, null)) {
                return null;
            }
            return new TooLongCharLiteralToStringFix(element3);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

