/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.actions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomBuild;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/actions/MavenPluginSourcesMoveToExecutionIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nMavenPluginSourcesSwap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPluginSourcesSwap.kt\norg/jetbrains/kotlin/idea/maven/actions/MavenPluginSourcesMoveToExecutionIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n125#2:155\n125#2:156\n1855#3,2:157\n*S KotlinDebug\n*F\n+ 1 MavenPluginSourcesSwap.kt\norg/jetbrains/kotlin/idea/maven/actions/MavenPluginSourcesMoveToExecutionIntention\n*L\n33#1:155\n61#1:156\n74#1:157,2\n*E\n"})
public final class MavenPluginSourcesMoveToExecutionIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return KotlinMavenBundle.message("fix.move.to.execution.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiFile file2 = element3.getContainingFile();
        if (file2 == null || !MavenDomUtil.isMavenFile((PsiFile)file2) || !(element3 instanceof XmlElement)) {
            return false;
        }
        PsiElement psiElement2 = element3;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, XmlTag.class, (boolean)strict$iv);
        if (xmlTag == null) {
            return false;
        }
        XmlTag tag = xmlTag;
        DomElement domElement = DomManager.getDomManager((Project)project2).getDomElement(tag);
        if (domElement == null) {
            return false;
        }
        DomElement domElement2 = domElement;
        if (!(domElement2 instanceof GenericDomValue)) {
            return false;
        }
        if (MavenDomUtil.getMavenDomProjectModel((Project)project2, (VirtualFile)file2.getVirtualFile()) == null) {
            return false;
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)file2);
        if (pomFile == null) {
            return false;
        }
        PomFile pom2 = pomFile;
        MavenDomBuild mavenDomBuild = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild != null ? mavenDomBuild.getSourceDirectory() : null) == domElement2) {
            String[] stringArray = new String[]{"compile", "js"};
            return !((Collection)pom2.findKotlinExecutions(stringArray)).isEmpty();
        }
        MavenDomBuild mavenDomBuild2 = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild2 != null ? mavenDomBuild2.getTestSourceDirectory() : null) == domElement2) {
            String[] stringArray = new String[]{"test-compile", "test-js"};
            return !((Collection)pom2.findKotlinExecutions(stringArray)).isEmpty();
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        List<MavenDomPluginExecution> relevantExecutions;
        void $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiFile psiFile2 = element3.getContainingFile();
        XmlFile xmlFile = psiFile2 instanceof XmlFile ? (XmlFile)psiFile2 : null;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile2);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        PsiElement psiElement2 = element3;
        boolean strict$iv22 = false;
        boolean $i$f$getParentOfType2 = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, XmlTag.class, (boolean)strict$iv22);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        DomElement strict$iv22 = DomManager.getDomManager((Project)project2).getDomElement(tag);
        GenericDomValue genericDomValue = strict$iv22 instanceof GenericDomValue ? (GenericDomValue)strict$iv22 : null;
        if (genericDomValue == null) {
            return;
        }
        GenericDomValue domElement = genericDomValue;
        String string2 = domElement.getRawText();
        if (string2 == null) {
            return;
        }
        String dir = string2;
        MavenDomBuild mavenDomBuild = (MavenDomBuild)domElement.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild != null ? mavenDomBuild.getSourceDirectory() : null) == domElement) {
            String[] $i$f$getParentOfType2 = new String[]{"compile", "js"};
            v6 = pomFile2.findKotlinExecutions($i$f$getParentOfType2);
        } else {
            MavenDomBuild mavenDomBuild2 = (MavenDomBuild)domElement.getParentOfType(MavenDomBuild.class, false);
            if ((mavenDomBuild2 != null ? mavenDomBuild2.getTestSourceDirectory() : null) == domElement) {
                String[] $i$f$getParentOfType2 = new String[]{"test-compile", "test-js"};
                v6 = pomFile2.findKotlinExecutions($i$f$getParentOfType2);
            } else {
                v6 = relevantExecutions = CollectionsKt.emptyList();
            }
        }
        if (!((Collection)relevantExecutions).isEmpty()) {
            Iterable $this$forEach$iv = relevantExecutions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenDomPluginExecution execution = (MavenDomPluginExecution)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)execution, (String)"execution");
                List<String> existingSourceDirs = pomFile2.executionSourceDirs(execution);
                pomFile2.executionSourceDirs(execution, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)existingSourceDirs, (Object)dir)), true);
            }
            domElement.undefine();
        }
    }
}

