/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.lang.java.JavaDocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0018\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\u001aH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider;", "", "()V", "findUrlsForClass", "", "", "aClass", "Lcom/intellij/psi/PsiClass;", "pkgFqName", "classFqName", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "containingKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/psi/KtClass;", "findUrlsForContainingClassOf", "ktElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findUrlsForEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "findUrlsForLightElement", "classUrls", "lightElement", "Lcom/intellij/psi/PsiElement;", "findUrlsForLightProperty", "lightProperty", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "getContainingLightClassForKtDeclaration", "declaration", "getExternalJavaDocUrl", "element", "getLightElementSignatures", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExternalDocs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,388:1\n1549#2:389\n1620#2,3:390\n1603#2,9:393\n1855#2:402\n1856#2:405\n1612#2:406\n1360#2:407\n1446#2,2:408\n1549#2:410\n1620#2,3:411\n1448#2,3:414\n1#3:403\n1#3:404\n169#4:417\n10#5:418\n*S KotlinDebug\n*F\n+ 1 KotlinExternalDocs.kt\norg/jetbrains/kotlin/idea/kdoc/KotlinExternalDocUrlsProvider\n*L\n77#1:389\n77#1:390,3\n101#1:393,9\n101#1:402\n101#1:405\n101#1:406\n153#1:407\n153#1:408,2\n153#1:410\n153#1:411,3\n153#1:414,3\n101#1:404\n176#1:417\n176#1:418\n*E\n"})
public final class KotlinExternalDocUrlsProvider {
    @NotNull
    public static final KotlinExternalDocUrlsProvider INSTANCE = new KotlinExternalDocUrlsProvider();

    private KotlinExternalDocUrlsProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getExternalJavaDocUrl(@Nullable PsiElement element3) {
        List list2;
        List<String> urls;
        PsiElement psiElement2 = element3;
        List<String> list3 = urls = psiElement2 instanceof KtEnumEntry ? this.findUrlsForEnumEntry((KtEnumEntry)element3) : (psiElement2 instanceof KtClass ? this.findUrlsForClass((KtClass)element3) : (psiElement2 instanceof KtFunction ? this.findUrlsForLightElement((KtDeclaration)element3, (PsiElement)LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)element3)) : (psiElement2 instanceof KtProperty ? this.findUrlsForLightProperty((KtDeclaration)element3, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)element3)) : (psiElement2 instanceof KtParameter ? this.findUrlsForLightProperty((KtDeclaration)element3, LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)element3)) : (psiElement2 instanceof KtLightClass ? this.findUrlsForClass((PsiClass)element3) : (psiElement2 instanceof KtLightMember ? this.findUrlsForLightElement(this.findUrlsForClass((PsiClass)((KtLightMember)element3).getContainingClass()), element3) : null))))));
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.toSystemIndependentName((String)it));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private final List<String> findUrlsForClass(KtClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getFqName()) == null || (object = object.asString()) == null) {
            return CollectionsKt.emptyList();
        }
        Object classFqName = object;
        KtFile ktFile = aClass.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"aClass.containingKtFile");
        return this.findUrlsForClass((String)classFqName, ktFile);
    }

    private final List<String> findUrlsForClass(PsiClass aClass) {
        Object object = aClass;
        if (object == null || (object = object.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        Object classFqName = object;
        String string2 = PsiUtil.getPackageName((PsiClass)aClass);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String pkgFqName = string2;
        PsiFile psiFile2 = aClass.getContainingFile();
        VirtualFile virtualFile2 = psiFile2 != null && (psiFile2 = psiFile2.getOriginalFile()) != null ? psiFile2.getVirtualFile() : null;
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project2 = aClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"aClass.project");
        return this.findUrlsForClass(pkgFqName, (String)classFqName, project2, virtualFile3);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForEnumEntry(KtEnumEntry enumEntry) {
        void $this$mapNotNullTo$iv$iv;
        String string2;
        PsiClass psiClass2;
        UClass uClass;
        Object object;
        PsiElement psiElement2;
        if (enumEntry == null || (psiElement2 = enumEntry.getParent()) == null || (object = UastContextKt.toUElement((PsiElement)psiElement2)) == null || (uClass = (UClass)UastUtils.getParentOfType$default((UElement)object, UClass.class, (boolean)false, (int)2, null)) == null || (psiClass2 = uClass.getJavaPsi()) == null || (string2 = psiClass2.getQualifiedName()) == null) {
            return CollectionsKt.emptyList();
        }
        String classFqName = string2;
        KtFile ktFile = enumEntry.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"enumEntry.containingKtFile");
        Iterable $this$mapNotNull$iv = this.findUrlsForClass(classFqName, ktFile);
        boolean $i$f$mapNotNull = false;
        object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String classUrl = (String)element$iv$iv;
            boolean bl2 = false;
            if (enumEntry.getName() != null) {
                String it;
                boolean bl3 = false;
                string3 = classUrl + "#" + it;
            } else {
                string3 = null;
            }
            if (string3 == null) continue;
            String it$iv$iv = string3;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> findUrlsForContainingClassOf(KtDeclaration ktElement) {
        PsiClass psiClass2 = this.getContainingLightClassForKtDeclaration(ktElement);
        if (psiClass2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass containingClass = psiClass2;
        String string2 = containingClass.getQualifiedName();
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String classFqName = string2;
        KtFile ktFile = ktElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktElement.containingKtFile");
        return this.findUrlsForClass(classFqName, ktFile);
    }

    private final List<String> findUrlsForClass(String classFqName, KtFile containingKtFile) {
        VirtualFile virtualFile2 = containingKtFile.getOriginalFile().getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        String string2 = containingKtFile.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"containingKtFile.packageFqName.asString()");
        String pkgName = string2;
        Project project2 = containingKtFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"containingKtFile.project");
        return this.findUrlsForClass(pkgName, classFqName, project2, virtualFile3);
    }

    private final List<String> findUrlsForClass(String pkgFqName, String classFqName, Project project2, VirtualFile virtualFile2) {
        List urls;
        List list2;
        String relPath;
        if (((CharSequence)pkgFqName).length() == 0) {
            v0 = "[root]/" + classFqName;
        } else {
            String string2 = StringsKt.replace$default((String)pkgFqName, (char)'.', (char)'/', (boolean)false, (int)4, null);
            String string3 = classFqName.substring(pkgFqName.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            v0 = relPath = string2 + "/" + string3;
        }
        if ((list2 = (urls = JavaDocumentationProvider.findUrlForVirtualFile((Project)project2, (VirtualFile)virtualFile2, (String)(relPath + ".html")))) == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final List<String> findUrlsForLightProperty(KtDeclaration ktElement, LightClassUtil.PropertyAccessorsPsiMethods lightProperty) {
        List<String> classUrls = this.findUrlsForContainingClassOf(ktElement);
        Object[] objectArray = new List[]{this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getBackingField()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getSetter()), this.findUrlsForLightElement(classUrls, (PsiElement)lightProperty.getGetter())};
        return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    private final List<String> findUrlsForLightElement(KtDeclaration ktElement, PsiElement lightElement) {
        return this.findUrlsForLightElement(this.findUrlsForContainingClassOf(ktElement), lightElement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findUrlsForLightElement(List<String> classUrls, PsiElement lightElement) {
        void $this$flatMapTo$iv$iv;
        if (lightElement == null) {
            return CollectionsKt.emptyList();
        }
        List<String> elementSignatures = this.getLightElementSignatures(lightElement);
        Iterable $this$flatMap$iv = classUrls;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            String classUrl = (String)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = elementSignatures;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void signature2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(classUrl + "#" + (String)signature2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getLightElementSignatures(PsiElement element3) {
        List list2;
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof PsiField) {
            list2 = CollectionsKt.listOf((Object)((PsiField)element3).getName());
        } else if (psiElement2 instanceof PsiMethod) {
            Object[] objectArray = new String[]{((PsiMethod)element3).getName() + "(", ((PsiMethod)element3).getName() + "-"};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final PsiClass getContainingLightClassForKtDeclaration(KtDeclaration declaration2) {
        PsiClass psiClass2;
        if (declaration2 instanceof KtFunction && ((KtFunction)declaration2).isLocal()) {
            psiClass2 = null;
        } else {
            PsiElement $this$toUElementOfType$iv = (PsiElement)declaration2;
            boolean $i$f$toUElementOfType = false;
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
            if (uMethod != null && (uMethod = uMethod.getUastParent()) != null && (uMethod = uMethod.getJavaPsi()) != null) {
                UMethod $this$asSafely$iv = uMethod;
                boolean $i$f$asSafely = false;
                UMethod uMethod2 = $this$asSafely$iv;
                if (!(uMethod2 instanceof PsiClass)) {
                    uMethod2 = null;
                }
                psiClass2 = (PsiClass)uMethod2;
            } else {
                psiClass2 = null;
            }
        }
        return psiClass2;
    }
}

