/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.AbstractKotlinApplicableInspectionWithContext;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorInfo;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.MovePropertyToConstructorUtils;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u00020\u0015\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u00b1\u00140\u0001\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/CanBePrimaryConstructorPropertyInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/AbstractKotlinApplicableInspectionWithContext;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/MovePropertyToConstructorInfo;", "()V", "apply", "", "element", "context", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getActionFamilyName", "", "getApplicabilityRange", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicabilityRange;", "getProblemDescription", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtProperty;)Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/MovePropertyToConstructorInfo;", "kotlin.code-insight.inspections-k2"})
public final class CanBePrimaryConstructorPropertyInspection
extends AbstractKotlinApplicableInspectionWithContext<KtProperty, MovePropertyToConstructorInfo> {
    public CanBePrimaryConstructorPropertyInspection() {
        super(Reflection.getOrCreateKotlinClass(KtProperty.class));
    }

    @Override
    @NotNull
    public String getProblemDescription(@NotNull KtProperty element3, @NotNull MovePropertyToConstructorInfo context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object[] objectArray = new Object[1];
        String string2 = element3.getName();
        if (string2 == null) {
            string2 = "???";
        }
        objectArray[0] = string2;
        return KotlinBundle.message("property.is.explicitly.assigned.to.parameter.0.can", objectArray);
    }

    @Override
    @NotNull
    public String getActionFamilyName() {
        return KotlinBundle.message("inspection.can.be.primary.constructor.property.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public KotlinApplicabilityRange<KtProperty> getApplicabilityRange() {
        return ApplicabilityRanges.INSTANCE.getDECLARATION_NAME();
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtProperty element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return MovePropertyToConstructorUtils.INSTANCE.isMovableToConstructorByPsi(element3);
    }

    @Override
    @Nullable
    public MovePropertyToConstructorInfo prepareContext(@NotNull KtAnalysisSession _context_receiver_0, @NotNull KtProperty element3) {
        Intrinsics.checkNotNullParameter((Object)_context_receiver_0, (String)"_context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression initializer2 = ktExpression;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)initializer2));
        KtSymbol ktSymbol = ktReference != null ? _context_receiver_0.resolveToSymbol(ktReference) : null;
        KtValueParameterSymbol ktValueParameterSymbol = ktSymbol instanceof KtValueParameterSymbol ? (KtValueParameterSymbol)ktSymbol : null;
        if (ktValueParameterSymbol == null) {
            return null;
        }
        KtValueParameterSymbol paramSymbol = ktValueParameterSymbol;
        if (!Intrinsics.areEqual((Object)element3.getNameAsName(), (Object)paramSymbol.getName())) {
            return null;
        }
        return MovePropertyToConstructorInfo.Companion.create(_context_receiver_0, element3);
    }

    @Override
    public void apply(@NotNull KtProperty element3, @NotNull MovePropertyToConstructorInfo context2, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MovePropertyToConstructorUtils.INSTANCE.moveToConstructor(element3, context2);
    }
}

