/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeArgumentsIntention;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeIntention;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "()V", "additionalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "RemoveExplicitTypeFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeArgumentsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,208:1\n142#2:209\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection\n*L\n41#1:209\n*E\n"})
public final class RemoveExplicitTypeArgumentsInspection
extends IntentionBasedInspection<KtTypeArgumentList> {
    public RemoveExplicitTypeArgumentsInspection() {
        super(Reflection.getOrCreateKotlinClass(RemoveExplicitTypeArgumentsIntention.class), null, 2, null);
    }

    @Override
    @Nullable
    public List<LocalQuickFix> additionalFixes(@NotNull KtTypeArgumentList element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration ktCallableDeclaration2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        if (ktCallableDeclaration2 == null) {
            return null;
        }
        KtCallableDeclaration declaration2 = ktCallableDeclaration2;
        if (!RemoveExplicitTypeIntention.Holder.INSTANCE.isApplicableTo(declaration2)) {
            return null;
        }
        String string2 = declaration2.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.nameAsSafeName.asString()");
        return CollectionsKt.listOf((Object)new RemoveExplicitTypeFix(string2));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declarationName", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeArgumentsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,208:1\n142#2:209\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeArgumentsIntention.kt\norg/jetbrains/kotlin/idea/intentions/RemoveExplicitTypeArgumentsInspection$RemoveExplicitTypeFix\n*L\n53#1:209\n*E\n"})
    private static final class RemoveExplicitTypeFix
    implements LocalQuickFix {
        @NotNull
        private final String declarationName;

        public RemoveExplicitTypeFix(@NotNull String declarationName2) {
            Intrinsics.checkNotNullParameter((Object)declarationName2, (String)"declarationName");
            this.declarationName = declarationName2;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.declarationName};
            return KotlinBundle.message("remove.explicit.type.specification.from.0", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtTypeArgumentList ktTypeArgumentList = psiElement2 instanceof KtTypeArgumentList ? (KtTypeArgumentList)psiElement2 : null;
            if (ktTypeArgumentList == null) {
                return;
            }
            KtTypeArgumentList element3 = ktTypeArgumentList;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element3;
            boolean $i$f$getStrictParentOfType = false;
            KtCallableDeclaration ktCallableDeclaration2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
            if (ktCallableDeclaration2 == null) {
                return;
            }
            KtCallableDeclaration declaration2 = ktCallableDeclaration2;
            RemoveExplicitTypeIntention.Holder.INSTANCE.removeExplicitType(declaration2);
        }
    }
}

