/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionName;", "Lorg/jetbrains/annotations/NotNull;", "startInWriteAction", "", "Equals", "HashCode", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "kotlin.idea"})
public abstract class GenerateEqualsOrHashCodeFix
implements LocalQuickFix {
    private GenerateEqualsOrHashCodeFix() {
    }

    @NotNull
    public String getFamilyName() {
        String string2 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
        return string2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
            return;
        }
        KotlinGenerateEqualsAndHashcodeAction kotlinGenerateEqualsAndHashcodeAction = new KotlinGenerateEqualsAndHashcodeAction();
        PsiElement psiElement2 = descriptor2.getPsiElement().getParent();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
        kotlinGenerateEqualsAndHashcodeAction.doInvoke(project2, null, (KtClassOrObject)((KtClass)psiElement2));
    }

    public /* synthetic */ GenerateEqualsOrHashCodeFix(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$Equals;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "()V", "getName", "", "kotlin.idea"})
    public static final class Equals
    extends GenerateEqualsOrHashCodeFix {
        @NotNull
        public static final Equals INSTANCE = new Equals();

        private Equals() {
            super(null);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("equals.text", new Object[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix$HashCode;", "Lorg/jetbrains/kotlin/idea/inspections/GenerateEqualsOrHashCodeFix;", "()V", "getName", "", "kotlin.idea"})
    public static final class HashCode
    extends GenerateEqualsOrHashCodeFix {
        @NotNull
        public static final HashCode INSTANCE = new HashCode();

        private HashCode() {
            super(null);
        }

        @NotNull
        public String getName() {
            return KotlinBundle.message("hash.code.text", new Object[0]);
        }
    }
}

