/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/Visitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "setRange", "visitNamedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinPreFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPreFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/Visitor\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,68:1\n177#2:69\n56#3,11:70\n20#3,2:81\n1247#4,2:83\n*S KotlinDebug\n*F\n+ 1 KotlinPreFormatProcessor.kt\norg/jetbrains/kotlin/idea/formatter/Visitor\n*L\n32#1:69\n38#1:70,11\n38#1:81,2\n18#1:83,2\n*E\n"})
final class Visitor
extends KtTreeVisitorVoid {
    @NotNull
    private TextRange range;

    public Visitor(@NotNull TextRange range2) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        this.range = range2;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    public final void setRange(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.range = textRange;
    }

    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this.range.contains(declaration2.getTextRange())) {
            return;
        }
        PsiElement psiElement2 = declaration2.getParent();
        KtClassBody ktClassBody = psiElement2 instanceof KtClassBody ? (KtClassBody)psiElement2 : null;
        if (ktClassBody == null) {
            return;
        }
        KtClassBody classBody = ktClassBody;
        PsiElement psiElement3 = classBody.getParent();
        KtClass ktClass2 = psiElement3 instanceof KtClass ? (KtClass)psiElement3 : null;
        if (ktClass2 == null) {
            return;
        }
        KtClass klass2 = ktClass2;
        if (!klass2.isEnum()) {
            return;
        }
        int delta = 0;
        Project project2 = klass2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"klass.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
        if (declaration2 instanceof KtEnumEntry) {
            PsiElement comma = psiFactory.createComma();
            PsiElement $this$nextSiblingOfSameType$iv = (PsiElement)declaration2;
            boolean $i$f$nextSiblingOfSameType = false;
            KtEnumEntry nextEntry = (KtEnumEntry)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfSameType$iv, KtEnumEntry.class);
            if (nextEntry != null) {
                PsiElement psiElement4 = (PsiElement)declaration2;
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COMMA");
                if (!Visitor.visitNamedDeclaration$containsToken(psiElement4, (IElementType)ktSingleValueToken)) {
                    declaration2.add(comma);
                    delta += comma.getTextLength();
                }
            }
        } else {
            int n;
            Object v5;
            block19: {
                Iterable $this$lastIsInstanceOrNull$iv = klass2.getDeclarations();
                boolean $i$f$lastIsInstanceOrNull = false;
                if ($this$lastIsInstanceOrNull$iv instanceof List) {
                    int $i$f$nextSiblingOfSameType = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                    if (0 <= $i$f$nextSiblingOfSameType) {
                        do {
                            int i$iv;
                            Object element$iv;
                            if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = $i$f$nextSiblingOfSameType--)) instanceof KtEnumEntry)) continue;
                            v5 = element$iv;
                            break block19;
                        } while (0 <= $i$f$nextSiblingOfSameType);
                    }
                    v5 = null;
                } else {
                    Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                        v5 = element$iv$iv;
                        break block19;
                    }
                    v5 = null;
                }
            }
            KtEnumEntry lastEntry = v5;
            if (lastEntry != null) {
                PsiElement psiElement5;
                PsiElement psiElement6 = (PsiElement)lastEntry;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"SEMICOLON");
                if (Visitor.visitNamedDeclaration$containsToken(psiElement6, (IElementType)ktSingleValueToken) || Intrinsics.areEqual((Object)((psiElement5 = lastEntry.getNextSibling()) != null && (psiElement5 = psiElement5.getNode()) != null ? psiElement5.getElementType() : null), (Object)KtTokens.SEMICOLON)) {
                    return;
                }
            }
            if (lastEntry == null) {
                PsiElement psiElement7 = (PsiElement)classBody;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"SEMICOLON");
                if (Visitor.visitNamedDeclaration$containsToken(psiElement7, (IElementType)ktSingleValueToken)) {
                    return;
                }
            }
            PsiElement semicolon = psiFactory.createSemicolon();
            if (lastEntry != null) {
                classBody.addAfter(semicolon, (PsiElement)lastEntry);
                n = semicolon.getTextLength();
            } else {
                PsiElement newLine = psiFactory.createNewLine();
                classBody.addAfter(semicolon, classBody.getLBrace());
                classBody.addAfter(psiFactory.createNewLine(), classBody.getLBrace());
                n = semicolon.getTextLength() + newLine.getTextLength();
            }
            delta += n;
        }
        this.range = new TextRange(this.range.getStartOffset(), this.range.getEndOffset() + delta);
    }

    private static final boolean visitNamedDeclaration$containsToken(PsiElement $this$visitNamedDeclaration_u24containsToken, IElementType type2) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = (Sequence)PsiUtilsKt.getAllChildren((PsiElement)$this$visitNamedDeclaration_u24containsToken);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)type2)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

