/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.editor.KotlinLiteralCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.editor.TemplateTokenSequence;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"templateContentRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiElement;", "getTemplateContentRange", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "createTemplateSequenceTokenString", "", "input", "deduceBlockSelectionWidth", "", "startOffsets", "", "endOffsets", "text", "getTemplateIfAtLiteral", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/psi/PsiFile;", "offset", "at", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinLiteralCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessorKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,293:1\n125#2:294\n*S KotlinDebug\n*F\n+ 1 KotlinLiteralCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/editor/KotlinLiteralCopyPasteProcessorKt\n*L\n26#1:294\n*E\n"})
public final class KotlinLiteralCopyPasteProcessorKt {
    /*
     * WARNING - void declaration
     */
    private static final TextRange getTemplateContentRange(PsiElement $this$templateContentRange) {
        TextRange textRange;
        void $this$getParentOfType$iv;
        PsiElement psiElement2 = $this$templateContentRange;
        boolean strict$iv = false;
        boolean $i$f$getParentOfType = false;
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtStringTemplateExpression.class, (boolean)strict$iv);
        if (ktStringTemplateExpression != null) {
            KtStringTemplateExpression it = ktStringTemplateExpression;
            boolean bl = false;
            textRange = it.getTextRange().cutOut(KtPsiUtilKt.getContentRange((KtStringTemplateExpression)it));
        } else {
            textRange = null;
        }
        return textRange;
    }

    private static final KtStringTemplateExpression getTemplateIfAtLiteral(PsiFile $this$getTemplateIfAtLiteral, int offset2, PsiElement at) {
        PsiElement psiElement2;
        PsiElement psiElement3;
        if (at == null) {
            return null;
        }
        ASTNode aSTNode = at.getNode();
        Object object = aSTNode != null ? aSTNode.getElementType() : null;
        Object object2 = (((Intrinsics.areEqual((Object)object, (Object)KtTokens.REGULAR_STRING_PART) ? true : Intrinsics.areEqual((Object)object, (Object)KtTokens.ESCAPE_SEQUENCE)) ? true : Intrinsics.areEqual((Object)object, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) ? true : Intrinsics.areEqual((Object)object, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) ? ((psiElement3 = at.getParent().getParent()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)psiElement3 : null) : (Intrinsics.areEqual((Object)object, (Object)KtTokens.CLOSING_QUOTE) ? (offset2 == PsiUtilsKt.getStartOffset((PsiElement)at) ? ((psiElement2 = at.getParent()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)psiElement2 : null) : null) : null);
        return object2;
    }

    static /* synthetic */ KtStringTemplateExpression getTemplateIfAtLiteral$default(PsiFile psiFile2, int n, PsiElement psiElement2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiElement2 = psiFile2.findElementAt(n);
        }
        return KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral(psiFile2, n, psiElement2);
    }

    private static final int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        boolean bl;
        int fragmentCount = startOffsets.length;
        boolean bl2 = bl = fragmentCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int totalLength = fragmentCount - 1;
        for (int i2 = 0; i2 < fragmentCount; ++i2) {
            totalLength += endOffsets[i2] - startOffsets[i2];
        }
        return totalLength < text2.length() && (text2.length() + 1) % fragmentCount == 0 ? (text2.length() + 1) / fragmentCount - 1 : -1;
    }

    @TestOnly
    @NotNull
    public static final String createTemplateSequenceTokenString(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)new TemplateTokenSequence(input), (Function1)createTemplateSequenceTokenString.1.INSTANCE), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ int access$deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        return KotlinLiteralCopyPasteProcessorKt.deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
    }

    public static final /* synthetic */ TextRange access$getTemplateContentRange(PsiElement $receiver) {
        return KotlinLiteralCopyPasteProcessorKt.getTemplateContentRange($receiver);
    }

    public static final /* synthetic */ KtStringTemplateExpression access$getTemplateIfAtLiteral(PsiFile $receiver, int offset2, PsiElement at) {
        return KotlinLiteralCopyPasteProcessorKt.getTemplateIfAtLiteral($receiver, offset2, at);
    }
}

