/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.FragmentProjectFileDependencyCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.FragmentCompilerCodegen;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRFragmentCompilerCodegen;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OldCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0016J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "compilerBackend", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/FragmentCompilerCodegen;", "getCompilerBackend", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/FragmentCompilerCodegen;", "basicErrorMessage", "", "beforeRunningFallback", "", "getFallbackStrategy", "getFilesToCompile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isFallbackDisabled", "", "onSuccess", "processError", "e", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCodegenException;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "reportErrorWithAttachments", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCompilingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,185:1\n84#2:186\n76#2:190\n1#3:187\n37#4,2:188\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n*L\n122#1:186\n172#1:190\n163#1:188,2\n*E\n"})
public final class IRCodeFragmentCompilingStrategy
extends CodeFragmentCompilingStrategy {
    @NotNull
    private final FragmentCompilerCodegen compilerBackend;

    public IRCodeFragmentCompilingStrategy(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        super(codeFragment);
        this.compilerBackend = new IRFragmentCompilerCodegen();
    }

    @Override
    @NotNull
    public FragmentCompilerCodegen getCompilerBackend() {
        return this.compilerBackend;
    }

    @Override
    @NotNull
    public List<KtFile> getFilesToCompile(@NotNull ResolutionFacade resolutionFacade2, @NotNull BindingContext bindingContext2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        List $this$getFilesToCompile_u24lambda_u240 = list2 = CollectionsKt.toMutableList((Collection)FragmentProjectFileDependencyCollectorKt.gatherProjectFilesDependedOnByFragment(this.getCodeFragment(), bindingContext2));
        boolean bl = false;
        IRCodeFragmentCompilingStrategy.getFilesToCompile$moveToLast($this$getFilesToCompile_u24lambda_u240, this.getCodeFragment());
        return list2;
    }

    @Override
    public void onSuccess() {
        KotlinDebuggerEvaluatorStatisticsCollector.Companion.logEvaluationResult(this.getCodeFragment().getProject(), StatisticsEvaluator.IR, StatisticsEvaluationResult.SUCCESS);
    }

    @Override
    public void processError(@NotNull CodeFragmentCodegenException e, @NotNull KtCodeFragment codeFragment, @NotNull ExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        KotlinDebuggerEvaluatorStatisticsCollector.Companion.logEvaluationResult(codeFragment.getProject(), StatisticsEvaluator.IR, StatisticsEvaluationResult.FAILURE);
        if (this.isFallbackDisabled()) {
            throw e;
        }
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            this.reportErrorWithAttachments(executionContext2, codeFragment, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportErrorWithAttachments(ExecutionContext executionContext2, KtCodeFragment codeFragment, CodeFragmentCodegenException e) {
        Attachment $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u244_u24lambda_u243;
        Attachment[] attachmentArray;
        Attachment attachment;
        String it;
        void $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u242;
        Attachment $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u241;
        Attachment attachment2;
        Attachment[] attachmentArray2;
        String string2;
        VirtualFile file2;
        EvaluationContextImpl evaluationContext = executionContext2.getEvaluationContext();
        String string3 = evaluationContext.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"evaluationContext.project.name");
        String projectName = string3;
        SuspendContextImpl suspendContextImpl = evaluationContext.getSuspendContext();
        Intrinsics.checkNotNullExpressionValue((Object)suspendContextImpl, (String)"evaluationContext.suspendContext");
        SuspendContextImpl suspendContext = suspendContextImpl;
        JavaExecutionStack javaExecutionStack = suspendContext.getActiveExecutionStack();
        VirtualFile virtualFile2 = file2 = javaExecutionStack != null && (javaExecutionStack = javaExecutionStack.getTopFrame()) != null && (javaExecutionStack = javaExecutionStack.getSourcePosition()) != null ? javaExecutionStack.getFile() : null;
        String fileContents = virtualFile2 != null ? VirtualFileUtil.readText((VirtualFile)virtualFile2) : null;
        String sessionName = suspendContext.getDebugProcess().getSession().getSessionName();
        VirtualFile virtualFile3 = file2;
        String debuggerContext = StringsKt.trimIndent((String)("\n            project: " + projectName + "\n            session: " + sessionName + "\n            location: " + suspendContext.getLocation() + " at " + (virtualFile3 != null ? virtualFile3.getPath() : null) + "\n        "));
        Object object = suspendContext.getThread();
        if (object != null && (object = object.frames()) != null) {
            Iterable iterable = (Iterable)object;
            String string4 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"lineSeparator()");
            string2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string4, null, null, (int)0, null, (Function1)reportErrorWithAttachments.suspendStackTrace.1.INSTANCE, (int)30, null);
        } else {
            string2 = null;
        }
        String suspendStackTrace2 = string2;
        Attachment[] $this$reportErrorWithAttachments_u24lambda_u247 = attachmentArray2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        Attachment attachment3 = attachment2 = new Attachment("debugger_context.txt", debuggerContext);
        Attachment[] attachmentArray3 = $this$reportErrorWithAttachments_u24lambda_u247;
        boolean bl2 = false;
        $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u241.setIncluded(true);
        attachmentArray3.add(attachment2);
        $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u241 = attachment2 = new Attachment("code_fragment.txt", codeFragment.getText());
        attachmentArray3 = $this$reportErrorWithAttachments_u24lambda_u247;
        boolean bl3 = false;
        $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u242.setIncluded(true);
        attachmentArray3.add(attachment2);
        String string5 = suspendStackTrace2;
        if (string5 != null) {
            it = string5;
            boolean bl4 = false;
            Attachment attachment4 = attachment = new Attachment("suspend_stack_trace.txt", it);
            attachmentArray = $this$reportErrorWithAttachments_u24lambda_u247;
            boolean bl5 = false;
            $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u244_u24lambda_u243.setIncluded(true);
            attachmentArray.add(attachment);
        }
        String string6 = fileContents;
        if (string6 != null) {
            void $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u246_u24lambda_u245;
            it = string6;
            boolean bl6 = false;
            $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u244_u24lambda_u243 = attachment = new Attachment("opened_file_contents.txt", it);
            attachmentArray = $this$reportErrorWithAttachments_u24lambda_u247;
            boolean bl7 = false;
            $this$reportErrorWithAttachments_u24lambda_u247_u24lambda_u246_u24lambda_u245.setIncluded(true);
            attachmentArray.add(attachment);
        }
        List attachments2 = CollectionsKt.build((List)attachmentArray2);
        Collection $this$toTypedArray$iv = attachments2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        attachmentArray2 = thisCollection$iv.toArray(new Attachment[0]);
        KotlinEvaluatorBuilderKt.getLOG().error(this.basicErrorMessage(), (Throwable)new RuntimeExceptionWithAttachments((Throwable)e.getReason(), Arrays.copyOf(attachmentArray2, attachmentArray2.length)));
    }

    private final String basicErrorMessage() {
        return "Error when compiling code fragment with IR evaluator. Details in attachments.";
    }

    @Override
    @Nullable
    public CodeFragmentCompilingStrategy getFallbackStrategy() {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return new OldCodeFragmentCompilingStrategy(this.getCodeFragment());
    }

    @Override
    public void beforeRunningFallback() {
        KotlinDebuggerEvaluatorStatisticsCollector.Companion.logFallbackToOldEvaluator(this.getCodeFragment().getProject());
    }

    private final boolean isFallbackDisabled() {
        return Registry.is((String)"debugger.kotlin.evaluator.disable.fallback.to.old.backend");
    }

    private static final <T> void getFilesToCompile$moveToLast(List<T> $this$getFilesToCompile_u24moveToLast, T element3) {
        $this$getFilesToCompile_u24moveToLast.removeAll(CollectionsKt.listOf(element3));
        $this$getFilesToCompile_u24moveToLast.add(element3);
    }
}

