/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.application.ReadAction;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilerHandler;", "", "strategy", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;)V", "getStrategy", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "compileCodeFragment", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "doCompileCodeFragment", "kotlin.jvm-debugger.evaluation"})
public final class CodeFragmentCompilerHandler {
    @NotNull
    private final CodeFragmentCompilingStrategy strategy;

    public CodeFragmentCompilerHandler(@NotNull CodeFragmentCompilingStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.strategy = strategy;
    }

    @NotNull
    public final CodeFragmentCompilingStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final CodeFragmentCompiler.CompilationResult compileCodeFragment(@NotNull KtCodeFragment codeFragment, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingContext bindingContext2, @NotNull ExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        return this.doCompileCodeFragment(this.strategy, codeFragment, moduleDescriptor, bindingContext2, executionContext2);
    }

    private final CodeFragmentCompiler.CompilationResult doCompileCodeFragment(CodeFragmentCompilingStrategy strategy, KtCodeFragment codeFragment, ModuleDescriptor moduleDescriptor, BindingContext bindingContext2, ExecutionContext executionContext2) {
        CodeFragmentCompiler.CompilationResult compilationResult;
        Pair pair = (Pair)ReadAction.nonBlocking(() -> CodeFragmentCompilerHandler.doCompileCodeFragment$lambda$0(codeFragment, strategy, bindingContext2)).executeSynchronously();
        BindingContext newBindingContext = (BindingContext)pair.component1();
        List filesToCompile = (List)pair.component2();
        try {
            compilationResult = new CodeFragmentCompiler(executionContext2).compile(codeFragment, filesToCompile, strategy, newBindingContext, moduleDescriptor);
        }
        catch (CodeFragmentCodegenException e) {
            strategy.processError(e, codeFragment, executionContext2);
            CodeFragmentCompilingStrategy fallback = strategy.getFallbackStrategy();
            if (fallback != null) {
                strategy.beforeRunningFallback();
                return this.doCompileCodeFragment(fallback, codeFragment, moduleDescriptor, bindingContext2, executionContext2);
            }
            throw e;
        }
        return compilationResult;
    }

    private static final Pair doCompileCodeFragment$lambda$0(KtCodeFragment $codeFragment, CodeFragmentCompilingStrategy $strategy, BindingContext $bindingContext) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$codeFragment, (String)"$codeFragment");
        Intrinsics.checkNotNullParameter((Object)$strategy, (String)"$strategy");
        Intrinsics.checkNotNullParameter((Object)$bindingContext, (String)"$bindingContext");
        ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment($codeFragment);
        try {
            List<KtFile> filesToCompile = $strategy.getFilesToCompile(resolutionFacade2, $bindingContext);
            AnalysisResult analysis = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade2, filesToCompile, null, 2, null);
            pair = new Pair((Object)analysis.getBindingContext(), filesToCompile);
        }
        catch (IllegalArgumentException e) {
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = e.toString();
            }
            KotlinEvaluatorBuilderKt.evaluationException(string2);
            throw new KotlinNothingValueException();
        }
        return pair;
    }
}

