/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.ReferenceTypeProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0017\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u0004\u0018\u00018\u00012\b\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/BaseMirror;", "T", "Lcom/sun/jdi/ObjectReference;", "F", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/ReferenceTypeProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorProvider;", "name", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "cls", "Lcom/sun/jdi/ClassType;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getName", "()Ljava/lang/String;", "fetchMirror", "value", "(Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)Ljava/lang/Object;", "getCls", "isCompatible", "", "(Lcom/sun/jdi/ObjectReference;)Z", "mirror", "kotlin.jvm-debugger.coroutines"})
public abstract class BaseMirror<T extends ObjectReference, F>
implements ReferenceTypeProvider,
MirrorProvider<T, F> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String name;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final ClassType cls;

    public BaseMirror(@NotNull String name2, @NotNull DefaultExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.name = name2;
        this.log$delegate = ProvidersKt.getLogger();
        ClassType classType = context2.findClassSafe(this.name);
        if (classType == null) {
            throw new IllegalStateException("coroutine-debugger: class " + this.name + " not found.");
        }
        this.cls = classType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public ClassType getCls() {
        return this.cls;
    }

    @Override
    public boolean isCompatible(@Nullable T value2) {
        T t = value2;
        return t != null && (t = t.referenceType()) != null ? CoroutineUtilsKt.isSubTypeOrSame((Type)t, this.name) : false;
    }

    @Override
    @Nullable
    public F mirror(@Nullable T value2, @NotNull DefaultExecutionContext context2) {
        F f2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (value2 == null) {
            return null;
        }
        if (!this.isCompatible(value2)) {
            this.getLog().trace("Value " + value2.referenceType() + " is not compatible with " + this.name + ".");
            f2 = null;
        } else {
            f2 = this.fetchMirror(value2, context2);
        }
        return f2;
    }

    @Nullable
    protected abstract F fetchMirror(@NotNull T var1, @NotNull DefaultExecutionContext var2);

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BaseMirror.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

