/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CompleteCoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineInfoProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineNoLibraryProxyKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CancellableContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCancellableContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfDispatchedContinuation;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineNoLibraryProxy;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineInfoProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;)V", "debugMetadataKtType", "Lcom/sun/jdi/ClassType;", "holder", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "cancellableContinuation", "", "resultList", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CompleteCoroutineInfoData;", "dispatchedContinuation", "dumpCoroutinesInfo", "", "extractCancellableContinuation", "Lcom/sun/jdi/ObjectReference;", "ccMirrorProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CancellableContinuationImpl;", "extractDispatchedContinuation", "continuation", "Lcom/sun/jdi/Field;", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineNoLibraryProxy
implements CoroutineInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultExecutionContext executionContext;
    @Nullable
    private final ClassType debugMetadataKtType;
    @NotNull
    private final ContinuationHolder holder;
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public CoroutineNoLibraryProxy(@NotNull DefaultExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        this.executionContext = executionContext2;
        this.debugMetadataKtType = CoroutineUtilsKt.findCoroutineMetadataType(this.executionContext);
        this.holder = ContinuationHolder.Companion.instance(this.executionContext);
    }

    @NotNull
    public List<CompleteCoroutineInfoData> dumpCoroutinesInfo() {
        VirtualMachineProxyImpl vm = this.executionContext.getVm();
        List resultList = new ArrayList();
        if (vm.getVirtualMachine().canGetInstanceInfo()) {
            String string2 = CoroutineNoLibraryProxyKt.coroutineSwitch();
            if (Intrinsics.areEqual((Object)string2, (Object)"DISPATCHED_CONTINUATION")) {
                this.dispatchedContinuation(resultList);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"CANCELLABLE_CONTINUATION")) {
                this.cancellableContinuation(resultList);
            } else {
                this.dispatchedContinuation(resultList);
            }
        } else {
            CoroutineNoLibraryProxy.Companion.getLog().warn("Remote JVM doesn't support canGetInstanceInfo capability (perhaps JDK-8197943).");
        }
        return resultList;
    }

    private final boolean cancellableContinuation(List<CompleteCoroutineInfoData> resultList) {
        List<ReferenceType> dcClassTypeList;
        List<ReferenceType> list2 = dcClassTypeList = CoroutineUtilsKt.findCancellableContinuationImplReferenceType(this.executionContext);
        boolean bl = list2 != null ? list2.size() == 1 : false;
        if (bl) {
            ReferenceType dcClassType = (ReferenceType)CollectionsKt.first(dcClassTypeList);
            CancellableContinuationImpl cci = new CancellableContinuationImpl(this.executionContext);
            List<ObjectReference> continuationList = dcClassType.instances(CoroutineNoLibraryProxyKt.maxCoroutines());
            for (ObjectReference cancellableContinuation : continuationList) {
                CompleteCoroutineInfoData coroutineInfo;
                Intrinsics.checkNotNullExpressionValue((Object)cancellableContinuation, (String)"cancellableContinuation");
                if (this.extractCancellableContinuation(cancellableContinuation, cci) == null) continue;
                resultList.add(coroutineInfo);
            }
        }
        return false;
    }

    private final CompleteCoroutineInfoData extractCancellableContinuation(ObjectReference dispatchedContinuation, CancellableContinuationImpl ccMirrorProvider) {
        MirrorOfCancellableContinuationImpl mirrorOfCancellableContinuationImpl = (MirrorOfCancellableContinuationImpl)ccMirrorProvider.mirror(dispatchedContinuation, this.executionContext);
        if (mirrorOfCancellableContinuationImpl == null) {
            return null;
        }
        MirrorOfCancellableContinuationImpl mirror = mirrorOfCancellableContinuationImpl;
        Object object = mirror.getDelegate();
        if (object == null || (object = ((MirrorOfDispatchedContinuation)object).getContinuation()) == null) {
            return null;
        }
        Object continuation2 = object;
        return this.holder.extractCoroutineInfoData((ObjectReference)continuation2);
    }

    private final boolean dispatchedContinuation(List<CompleteCoroutineInfoData> resultList) {
        List<ReferenceType> dcClassTypeList;
        List<ReferenceType> list2 = dcClassTypeList = CoroutineUtilsKt.findDispatchedContinuationReferenceType(this.executionContext);
        boolean bl = list2 != null ? list2.size() == 1 : false;
        if (bl) {
            ReferenceType dcClassType = (ReferenceType)CollectionsKt.first(dcClassTypeList);
            Field field2 = dcClassType.fieldByName("continuation");
            if (field2 == null) {
                return true;
            }
            Field continuationField = field2;
            List<ObjectReference> continuationList = dcClassType.instances(CoroutineNoLibraryProxyKt.maxCoroutines());
            for (ObjectReference dispatchedContinuation : continuationList) {
                CompleteCoroutineInfoData coroutineInfo;
                Intrinsics.checkNotNullExpressionValue((Object)dispatchedContinuation, (String)"dispatchedContinuation");
                if (this.extractDispatchedContinuation(dispatchedContinuation, continuationField) == null) continue;
                resultList.add(coroutineInfo);
            }
        }
        return false;
    }

    private final CompleteCoroutineInfoData extractDispatchedContinuation(ObjectReference dispatchedContinuation, Field continuation2) {
        if (this.debugMetadataKtType == null) {
            return null;
        }
        Value value2 = dispatchedContinuation.getValue(continuation2);
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        ObjectReference initialContinuation = (ObjectReference)value2;
        return this.holder.extractCoroutineInfoData(initialContinuation);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineNoLibraryProxy$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

