/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinInlineFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.KotlinStepOverParamDefaultImplsMethodFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.filter.LocationToken;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0017\u0010\u0011\u001a\u00020\f*\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0082\u0002\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0012\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0003H\u0002\u001a\f\u0010\u0018\u001a\u00020\f*\u00020\u0010H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\f*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\n\u0010\u001a\u001a\u00020\f*\u00020\u001b\u00a8\u0006\u001c"}, d2={"createKotlinInlineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinInlineFilter;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getStepOutAction", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinStepAction;", "location", "Lcom/sun/jdi/Location;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getStepOverAction", "isInlineFunctionFromLibrary", "", "positionManager", "Lcom/intellij/debugger/PositionManager;", "token", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/filter/LocationToken;", "contains", "Lcom/intellij/psi/PsiElement;", "element", "getLineRange", "Lkotlin/ranges/IntRange;", "getSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "isInsideOneLineInlineLambda", "isOnFunctionDeclaration", "isSyntheticMethodForDefaultParameters", "Lcom/sun/jdi/Method;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSteppingCommandProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSteppingCommandProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,240:1\n1#2:241\n526#3:242\n511#3,6:243\n146#4:249\n*S KotlinDebug\n*F\n+ 1 KotlinSteppingCommandProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProviderKt\n*L\n122#1:242\n122#1:243,6\n179#1:249\n*E\n"})
public final class KotlinSteppingCommandProviderKt {
    private static final SourcePosition getSourcePosition(SuspendContextImpl $this$getSourcePosition) {
        return $this$getSourcePosition.getDebugProcess().getDebuggerContext().getSourcePosition();
    }

    private static final boolean contains(PsiElement $this$contains, PsiElement element3) {
        PsiElement psiElement2 = $this$contains;
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.contains(element3.getTextRange()) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinStepAction getStepOverAction(@NotNull Location location2, @NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frameProxy) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Range lineNumbers;
        LocationToken locationToken;
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        StackFrame stackFrame2 = stackFrame;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        Method method2 = method;
        LocationToken it = locationToken = LocationToken.Companion.from(stackFrame2);
        boolean $i$a$-takeIf-KotlinSteppingCommandProviderKt$getStepOverAction$token$22 = false;
        LocationToken locationToken2 = it.getLineNumber() > 0 ? locationToken : null;
        if (locationToken2 == null) {
            return KotlinStepAction.JvmStepOver.INSTANCE;
        }
        LocationToken token = locationToken2;
        if (token.getInlineVariables().isEmpty() && KotlinSteppingCommandProviderKt.isSyntheticMethodForDefaultParameters(method2)) {
            int psiLineNumber = location2.lineNumber() - 1;
            lineNumbers = new Range((Comparable)Integer.valueOf(psiLineNumber), (Comparable)Integer.valueOf(psiLineNumber));
            return new KotlinStepAction.StepInto(KotlinStepOverParamDefaultImplsMethodFilter.Companion.create(location2, (Range<Integer>)lineNumbers));
        }
        lineNumbers = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2);
        boolean $i$f$filter = false;
        void $i$a$-takeIf-KotlinSteppingCommandProviderKt$getStepOverAction$token$22 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((ClosedRange)it2.getValue()).contains((Comparable)location2))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection inlinedFunctionArgumentRangesToSkip = destination$iv$iv.values();
        CompoundPositionManager compoundPositionManager = suspendContext.getDebugProcess().getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"suspendContext.debugProcess.positionManager");
        CompoundPositionManager positionManager = compoundPositionManager;
        KotlinStepOverFilter filter2 = new KotlinStepOverFilter(location2, token, inlinedFunctionArgumentRangesToSkip, positionManager){
            final /* synthetic */ LocationToken $token;
            final /* synthetic */ Collection<ClosedRange<Location>> $inlinedFunctionArgumentRangesToSkip;
            final /* synthetic */ CompoundPositionManager $positionManager;
            {
                this.$token = $token;
                this.$inlinedFunctionArgumentRangesToSkip = $inlinedFunctionArgumentRangesToSkip;
                this.$positionManager = $positionManager;
                super($location);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isAcceptable(@NotNull Location location2, @NotNull LocationToken locationToken) {
                boolean bl;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                Intrinsics.checkNotNullParameter((Object)locationToken, (String)"locationToken");
                if (locationToken.getLineNumber() < 0) return false;
                if (locationToken.getLineNumber() == this.$token.getLineNumber()) return false;
                Iterable $this$none$iv = this.$inlinedFunctionArgumentRangesToSkip;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        ClosedRange it = (ClosedRange)element$iv;
                        boolean bl3 = false;
                        if (!it.contains((Comparable)location2)) continue;
                        return false;
                    }
                    bl2 = true;
                }
                if (!bl2) return false;
                $this$none$iv = locationToken.getInlineVariables();
                LocationToken locationToken2 = this.$token;
                boolean $i$f$none2 = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (T element$iv : $this$none$iv) {
                        LocalVariable it = (LocalVariable)element$iv;
                        boolean bl4 = false;
                        if (!locationToken2.getInlineVariables().contains(it)) {
                            return false;
                        }
                        boolean bl5 = false;
                        if (!bl5) continue;
                        return false;
                    }
                    bl = true;
                }
                if (!bl) return false;
                if (KotlinSteppingCommandProviderKt.access$isInlineFunctionFromLibrary((PositionManager)this.$positionManager, location2, locationToken)) return false;
                if (KotlinSteppingCommandProviderKt.access$isOnFunctionDeclaration(location2, (PositionManager)this.$positionManager)) return false;
                return true;
            }
        };
        return new KotlinStepAction.KotlinStepOver(filter2, 0, 2, null);
    }

    private static final boolean isOnFunctionDeclaration(Location $this$isOnFunctionDeclaration, PositionManager positionManager) {
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(positionManager, $this$isOnFunctionDeclaration){
            final /* synthetic */ PositionManager $positionManager;
            final /* synthetic */ Location $this_isOnFunctionDeclaration;
            {
                this.$positionManager = $positionManager;
                this.$this_isOnFunctionDeclaration = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                SourcePosition sourcePosition2 = this.$positionManager.getSourcePosition(this.$this_isOnFunctionDeclaration);
                if (sourcePosition2 == null) {
                    return false;
                }
                SourcePosition sourcePosition3 = sourcePosition2;
                PsiFile psiFile2 = sourcePosition3.getFile();
                KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (ktFile == null) {
                    return false;
                }
                KtFile file2 = ktFile;
                PsiElement elementAtLine = DebuggerUtil.findElementAtLine(file2, sourcePosition3.getLine());
                if (!(elementAtLine instanceof KtNamedFunction)) {
                    KtParameterList ktParameterList;
                    PsiElement psiElement2 = elementAtLine;
                    if (psiElement2 != null) {
                        PsiElement $this$parentOfType_u24default$iv = psiElement2;
                        boolean withSelf$iv = false;
                        boolean $i$f$parentOfType = false;
                        ktParameterList = (KtParameterList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtParameterList.class, (boolean)true);
                    } else {
                        ktParameterList = null;
                    }
                    if (ktParameterList == null) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }));
    }

    @Nullable
    public static final KotlinInlineFilter createKotlinInlineFilter(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location2 = suspendContext.getLocation();
        if (location2 == null) {
            return null;
        }
        Location location3 = location2;
        Method method = SafeUtilKt.safeMethod(location3);
        if (method == null) {
            return null;
        }
        Method method2 = method;
        return new KotlinInlineFilter(location3, method2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSyntheticMethodForDefaultParameters(@NotNull Method $this$isSyntheticMethodForDefaultParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$isSyntheticMethodForDefaultParameters, (String)"<this>");
        if (!$this$isSyntheticMethodForDefaultParameters.isSynthetic()) return false;
        String string2 = $this$isSyntheticMethodForDefaultParameters.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
        if (!StringsKt.endsWith$default((String)string2, (String)"$default", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean isInlineFunctionFromLibrary(PositionManager positionManager, Location location2, LocationToken token) {
        if (token.getInlineVariables().isEmpty()) {
            return false;
        }
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        if (!debuggerSettings.TRACING_FILTERS_ENABLED) {
            return false;
        }
        String string2 = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(positionManager, location2){
            final /* synthetic */ PositionManager $positionManager;
            final /* synthetic */ Location $location;
            {
                this.$positionManager = $positionManager;
                this.$location = $location;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final String invoke() {
                FqName fqName2;
                SourcePosition sourcePosition2 = this.$positionManager.getSourcePosition(this.$location);
                PsiElement psiElement2 = sourcePosition2 != null ? sourcePosition2.getElementAt() : null;
                FqName fqName4 = KotlinSteppingCommandProviderKt.access$isInlineFunctionFromLibrary$getDeclarationName(psiElement2);
                fqName4 = fqName4;
                if (fqName3 == null) return null;
                FqName it = fqName2 = fqName4;
                boolean bl = false;
                if (it.isRoot()) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                FqName fqName4 = fqName2;
                fqName4 = fqName4;
                if (fqName5 == null) return null;
                String string2 = fqName4.asString();
                return string2;
            }
        }));
        if (string2 == null) {
            return false;
        }
        String fqn2 = string2;
        ClassFilter[] classFilterArray = debuggerSettings.getSteppingFilters();
        Intrinsics.checkNotNullExpressionValue((Object)classFilterArray, (String)"debuggerSettings.steppingFilters");
        for (ClassFilter filter2 : classFilterArray) {
            if (!filter2.isEnabled() || !filter2.matches(fqn2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static final IntRange getLineRange(@NotNull PsiElement $this$getLineRange) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineRange, (String)"<this>");
        int startLineNumber = PsiLinesUtilsKt.getLineNumber($this$getLineRange, true);
        int endLineNumber = PsiLinesUtilsKt.getLineNumber($this$getLineRange, false);
        if (startLineNumber > endLineNumber) {
            return null;
        }
        return new IntRange(startLineNumber, endLineNumber);
    }

    @NotNull
    public static final KotlinStepAction getStepOutAction(@NotNull Location location2, @NotNull StackFrameProxyImpl frameProxy) {
        LocationToken locationToken;
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return KotlinStepAction.StepOut.INSTANCE;
        }
        StackFrame stackFrame2 = stackFrame;
        LocationToken it = locationToken = LocationToken.Companion.from(stackFrame2);
        boolean bl = false;
        LocationToken locationToken2 = it.getLineNumber() > 0 ? locationToken : null;
        if (locationToken2 == null) {
            return KotlinStepAction.StepOut.INSTANCE;
        }
        LocationToken token = locationToken2;
        if (token.getInlineVariables().isEmpty()) {
            return KotlinStepAction.StepOut.INSTANCE;
        }
        KotlinStepOverFilter filter2 = new KotlinStepOverFilter(location2, token){
            final /* synthetic */ LocationToken $token;
            {
                this.$token = $token;
                super($location);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isAcceptable(@NotNull Location location2, @NotNull LocationToken locationToken) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
                Intrinsics.checkNotNullParameter((Object)locationToken, (String)"locationToken");
                if (locationToken.getLineNumber() < 0) return false;
                Iterable $this$any$iv = this.$token.getInlineVariables();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator<T> iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    T element$iv = iterator2.next();
                    LocalVariable it = (LocalVariable)element$iv;
                    boolean bl2 = false;
                    if (!locationToken.getInlineVariables().contains(it)) {
                        return true;
                    }
                    bl = false;
                } while (!bl);
                return true;
            }
        };
        int stepSize = KotlinSteppingCommandProviderKt.isInsideOneLineInlineLambda(token) ? -1 : -2;
        return new KotlinStepAction.KotlinStepOver(filter2, stepSize);
    }

    private static final boolean isInsideOneLineInlineLambda(LocationToken $this$isInsideOneLineInlineLambda) {
        for (LocalVariable variable2 : $this$isInsideOneLineInlineLambda.getInlineVariables()) {
            ClosedRange<Location> borders;
            if (DebuggerUtils.INSTANCE.getBorders(variable2) == null) continue;
            String string2 = variable2.name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variable.name()");
            if (!StringsKt.startsWith$default((String)string2, (String)"$i$a$", (boolean)false, (int)2, null) || ((Location)borders.getStart()).lineNumber() != ((Location)borders.getEndInclusive()).lineNumber()) continue;
            return true;
        }
        return false;
    }

    private static final FqName isInlineFunctionFromLibrary$getDeclarationName(PsiElement element3) {
        while (true) {
            PsiElement psiElement2;
            block6: {
                block5: {
                    if ((psiElement2 = element3) == null) break block5;
                    PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                    boolean $i$f$getNonStrictParentOfType = false;
                    psiElement2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtDeclaration.class, (boolean)false);
                    if (psiElement2 != null) break block6;
                }
                return null;
            }
            PsiElement declaration2 = psiElement2;
            FqName fqName2 = JavaPsiUtils.getKotlinFqName(declaration2);
            if (fqName2 != null) {
                FqName it = fqName2;
                boolean bl = false;
                return it;
            }
            element3 = declaration2.getParent();
        }
    }

    public static final /* synthetic */ SourcePosition access$getSourcePosition(SuspendContextImpl $receiver) {
        return KotlinSteppingCommandProviderKt.getSourcePosition($receiver);
    }

    public static final /* synthetic */ boolean access$isInlineFunctionFromLibrary(PositionManager positionManager, Location location2, LocationToken token) {
        return KotlinSteppingCommandProviderKt.isInlineFunctionFromLibrary(positionManager, location2, token);
    }

    public static final /* synthetic */ boolean access$isOnFunctionDeclaration(Location $receiver, PositionManager positionManager) {
        return KotlinSteppingCommandProviderKt.isOnFunctionDeclaration($receiver, positionManager);
    }

    public static final /* synthetic */ FqName access$isInlineFunctionFromLibrary$getDeclarationName(PsiElement element3) {
        return KotlinSteppingCommandProviderKt.isInlineFunctionFromLibrary$getDeclarationName(element3);
    }
}

