/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u001a!\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0013H\u0002\u001a\u000e\u0010\u0017\u001a\u00020\u0010*\u0004\u0018\u00010\u0013H\u0002\"\"\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0018"}, d2={"javaBreakpointProperties", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "getJavaBreakpointProperties", "(Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;)Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "createLineSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl;", "getLambdaByOrdinal", "Lorg/jetbrains/kotlin/psi/KtFunction;", "position", "ordinal", "", "(Lcom/intellij/debugger/SourcePosition;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/psi/KtFunction;", "inTheMethod", "", "pos", "method", "Lcom/intellij/psi/PsiElement;", "getContainingMethod", "excludingElement", "isClosingBraceInMethod", "isInlineOnlyDeclaration", "kotlin.jvm-debugger.core"})
public final class KotlinLineBreakpointTypeKt {
    private static final JavaBreakpointProperties<?> getJavaBreakpointProperties(LineBreakpoint<?> $this$javaBreakpointProperties) {
        XBreakpoint xBreakpoint = $this$javaBreakpointProperties.getXBreakpoint();
        JavaBreakpointProperties javaBreakpointProperties = xBreakpoint != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
        return javaBreakpointProperties instanceof JavaBreakpointProperties ? javaBreakpointProperties : null;
    }

    private static final PsiElement getContainingMethod(PsiElement $this$getContainingMethod, boolean excludingElement) {
        Class[] classArray = new Class[]{KtFunction.class, KtClassInitializer.class, KtPropertyAccessor.class};
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingMethod, (boolean)excludingElement, (Class[])classArray);
    }

    static /* synthetic */ PsiElement getContainingMethod$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinLineBreakpointTypeKt.getContainingMethod(psiElement2, bl);
    }

    private static final boolean isInlineOnlyDeclaration(PsiElement $this$isInlineOnlyDeclaration) {
        return $this$isInlineOnlyDeclaration instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)$this$isInlineOnlyDeclaration);
    }

    private static final boolean isClosingBraceInMethod(PsiElement $this$isClosingBraceInMethod) {
        if ($this$isClosingBraceInMethod instanceof LeafPsiElement && ((LeafPsiElement)$this$isClosingBraceInMethod).getNode().getElementType() == KtTokens.RBRACE) {
            PsiElement owner;
            PsiElement blockExpression2 = ((LeafPsiElement)$this$isClosingBraceInMethod).getParent();
            if (blockExpression2 instanceof KtFunctionLiteral) {
                return true;
            }
            if (blockExpression2 instanceof KtBlockExpression && ((owner = ((KtBlockExpression)blockExpression2).getParent()) instanceof KtFunction || owner instanceof KtClassInitializer)) {
                return true;
            }
        }
        return false;
    }

    private static final KtFunction getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        if (ordinal == null || ordinal < 0) {
            return null;
        }
        List lambdas2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends KtFunction>>(position){
            final /* synthetic */ SourcePosition $position;
            {
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final List<KtFunction> invoke() {
                PsiElement targetElement = this.$position.getElementAt();
                if (targetElement == null || !targetElement.isValid()) {
                    return CollectionsKt.emptyList();
                }
                return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(this.$position);
            }
        }));
        if (lambdas2.size() > ordinal) {
            return (KtFunction)lambdas2.get(ordinal);
        }
        return null;
    }

    public static final boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElement psiElement2 = pos.getElementAt();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement elem = psiElement2;
        PsiElement topmostElement = KotlinPsiUtils.getTopmostElementAtOffset(elem, elem.getTextRange().getStartOffset());
        return Comparing.equal((Object)KotlinLineBreakpointTypeKt.getContainingMethod$default(topmostElement, false, 1, null), (Object)method);
    }

    private static final SourcePosition createLineSourcePosition(XLineBreakpointImpl<?> breakpoint2) {
        VirtualFile virtualFile2 = breakpoint2.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        PsiManager psiManager2 = PsiManager.getInstance((Project)breakpoint2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(breakpoint.project)");
        PsiManager psiManager3 = psiManager2;
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(psiManager3, file2){
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ VirtualFile $file;
            {
                this.$psiManager = $psiManager;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return this.$psiManager.findFile(this.$file);
            }
        }));
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        return SourcePosition.createFromLine((PsiFile)psiFile3, (int)breakpoint2.getLine());
    }

    public static final /* synthetic */ JavaBreakpointProperties access$getJavaBreakpointProperties(LineBreakpoint $receiver) {
        return KotlinLineBreakpointTypeKt.getJavaBreakpointProperties($receiver);
    }

    public static final /* synthetic */ boolean access$isInlineOnlyDeclaration(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isInlineOnlyDeclaration($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingBraceInMethod(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isClosingBraceInMethod($receiver);
    }

    public static final /* synthetic */ PsiElement access$getContainingMethod(PsiElement $receiver, boolean excludingElement) {
        return KotlinLineBreakpointTypeKt.getContainingMethod($receiver, excludingElement);
    }

    public static final /* synthetic */ KtFunction access$getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        return KotlinLineBreakpointTypeKt.getLambdaByOrdinal(position, ordinal);
    }

    public static final /* synthetic */ SourcePosition access$createLineSourcePosition(XLineBreakpointImpl breakpoint2) {
        return KotlinLineBreakpointTypeKt.createLineSourcePosition(breakpoint2);
    }
}

