/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/ClassifierInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isDeclarationIdentifier", "", "Lcom/intellij/psi/PsiElement;", "kotlin.completion.impl-k2"})
final class ClassifierInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @NotNull
    public static final ClassifierInsertionHandler INSTANCE = new ClassifierInsertionHandler();

    private ClassifierInsertionHandler() {
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
        PsiFile psiFile2 = context2.getFile();
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return;
        }
        KtFile targetFile2 = ktFile;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.factories.ClassifierLookupObject");
        ClassifierLookupObject lookupObject = (ClassifierLookupObject)object;
        super.handleInsert(context2, item);
        if (lookupObject.getImportingStrategy() instanceof ImportStrategy.InsertFqNameAndShorten) {
            PsiElement token;
            String fqNameRendered = RenderingUtilsKt.render((FqName)((ImportStrategy.InsertFqNameAndShorten)lookupObject.getImportingStrategy()).getFqName());
            PsiElement psiElement2 = token = context2.getFile().findElementAt(context2.getStartOffset());
            String temporarySuffix = (psiElement2 != null ? this.isDeclarationIdentifier(psiElement2) : false) ? ".f" : "";
            context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)(fqNameRendered + temporarySuffix));
            context2.commitDocument();
            int fqNameEndOffset = context2.getStartOffset() + fqNameRendered.length();
            RangeMarker rangeMarker2 = context2.getDocument().createRangeMarker(fqNameEndOffset, fqNameEndOffset + temporarySuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"context.document.createR\u2026+ temporarySuffix.length)");
            RangeMarker rangeMarker3 = rangeMarker2;
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile2, new TextRange(context2.getStartOffset(), fqNameEndOffset), null, null, 12, null);
            context2.commitDocument();
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
            if (rangeMarker3.isValid()) {
                context2.getDocument().deleteString(rangeMarker3.getStartOffset(), rangeMarker3.getEndOffset());
            }
        }
    }

    private final boolean isDeclarationIdentifier(PsiElement $this$isDeclarationIdentifier) {
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)$this$isDeclarationIdentifier), (Object)KtTokens.IDENTIFIER) && $this$isDeclarationIdentifier.getParent() instanceof KtDeclaration;
    }
}

