/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.util.ControlFlowUtilsKt;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.idea.project.ResolveElementCache;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.QualifiedExpressionResolver;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.ExplicitImportsScope;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u0003345B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0019H\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,H\u0002J'\u0010/\u001a\u00020\u00192\b\u00100\u001a\u0004\u0018\u0001012\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0,H\u0082\u0010J\u0014\u00102\u001a\u0004\u0018\u00010-2\b\u00100\u001a\u0004\u0018\u000101H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "qualifierResolver", "Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;Lorg/jetbrains/kotlin/resolve/QualifiedExpressionResolver;Lorg/jetbrains/kotlin/resolve/TypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "<set-?>", "Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "resolveElementCache", "getResolveElementCache", "()Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;", "setResolveElementCache", "(Lorg/jetbrains/kotlin/idea/project/ResolveElementCache;)V", "analyzeCodeFragment", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bodyResolveMode", "Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;", "analyzeCodeFragmentContext", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ContextInfo;", "createEmptyScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createImportScopes", "", "Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "doAnalyzeCodeFragment", "contextInfo", "enrichScopeWithImports", "scope", "getClassDescriptor", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ClassResolutionResult;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "resolutionFactory", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getContextInfo", "context", "Lcom/intellij/psi/PsiElement;", "refineContextElement", "ClassResolutionResult", "Companion", "ContextInfo", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentAnalyzer.kt\norg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n125#2:220\n133#2:221\n125#2:223\n1#3:222\n1#3:234\n1603#4,9:224\n1855#4:233\n1856#4:235\n1612#4:236\n*S KotlinDebug\n*F\n+ 1 CodeFragmentAnalyzer.kt\norg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer\n*L\n123#1:220\n141#1:221\n172#1:223\n203#1:234\n203#1:224,9\n203#1:233\n203#1:235\n203#1:236\n*E\n"})
public final class CodeFragmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolveSession resolveSession;
    @NotNull
    private final QualifiedExpressionResolver qualifierResolver;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public ResolveElementCache resolveElementCache;
    @NotNull
    private static final Key<KotlinType> EXPECTED_TYPE_KEY = new Key("EXPECTED_TYPE");

    public CodeFragmentAnalyzer(@NotNull ResolveSession resolveSession, @NotNull QualifiedExpressionResolver qualifierResolver, @NotNull TypeResolver typeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        Intrinsics.checkNotNullParameter((Object)qualifierResolver, (String)"qualifierResolver");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkNotNullParameter((Object)expressionTypingServices, (String)"expressionTypingServices");
        this.resolveSession = resolveSession;
        this.qualifierResolver = qualifierResolver;
        this.typeResolver = typeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ResolveElementCache getResolveElementCache() {
        ResolveElementCache resolveElementCache = this.resolveElementCache;
        if (resolveElementCache != null) {
            return resolveElementCache;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resolveElementCache");
        return null;
    }

    @Inject
    public final void setResolveElementCache(@NotNull ResolveElementCache resolveElementCache) {
        Intrinsics.checkNotNullParameter((Object)resolveElementCache, (String)"<set-?>");
        this.resolveElementCache = resolveElementCache;
    }

    @NotNull
    public final BindingTrace analyzeCodeFragment(@NotNull KtCodeFragment codeFragment, @NotNull BodyResolveMode bodyResolveMode) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)((Object)bodyResolveMode), (String)"bodyResolveMode");
        ContextInfo contextAnalysisResult = this.analyzeCodeFragmentContext(codeFragment, bodyResolveMode);
        return this.doAnalyzeCodeFragment(codeFragment, contextAnalysisResult);
    }

    private final BindingTrace doAnalyzeCodeFragment(KtCodeFragment codeFragment, ContextInfo contextInfo) {
        BindingContext bindingContext2 = contextInfo.component1();
        LexicalScope scope2 = contextInfo.component2();
        DataFlowInfo dataFlowInfo = contextInfo.component3();
        DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext2, "For code fragment analysis", false, null, false, null, 60, null);
        KtElement contentElement = codeFragment.getContentElement();
        if (contentElement instanceof KtExpression) {
            KotlinType kotlinType = (KotlinType)codeFragment.getUserData(EXPECTED_TYPE_KEY);
            if (kotlinType == null) {
                kotlinType = (KotlinType)TypeUtils.NO_EXPECTED_TYPE;
            }
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"codeFragment.getUserData\u2026ypeUtils.NO_EXPECTED_TYPE");
            KotlinType expectedType = kotlinType;
            ExtendedResolutionApiKt.analyzeInContext$default((KtExpression)contentElement, scope2, null, (BindingTrace)bindingTrace, dataFlowInfo, expectedType, false, null, this.expressionTypingServices, 98, null);
            ControlFlowUtilsKt.analyzeControlFlow(this.resolveSession, contentElement, (BindingTrace)bindingTrace);
            WritableSlice writableSlice = BindingContext.USED_AS_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)writableSlice, (String)"USED_AS_EXPRESSION");
            bindingTrace.record(writableSlice, (Object)KtPsiUtilKt.lastBlockStatementOrThis((KtExpression)((KtExpression)contentElement)));
        } else if (contentElement instanceof KtTypeReference) {
            TypeResolutionContext typeResolutionContext = new TypeResolutionContext(scope2, (BindingTrace)bindingTrace, true, true, CodeFragmentUtilKt.suppressDiagnosticsInDebugMode((KtElement)((KtElement)codeFragment))).noBareTypes();
            Intrinsics.checkNotNullExpressionValue((Object)typeResolutionContext, (String)"TypeResolutionContext(\n \u2026          ).noBareTypes()");
            TypeResolutionContext context2 = typeResolutionContext;
            this.typeResolver.resolvePossiblyBareType(context2, (KtTypeReference)contentElement);
        }
        return (BindingTrace)bindingTrace;
    }

    private final ContextInfo analyzeCodeFragmentContext(KtCodeFragment codeFragment, BodyResolveMode bodyResolveMode) {
        KtElement context2 = this.refineContextElement(codeFragment.getContext());
        ContextInfo info2 = this.getContextInfo((PsiElement)context2, (Function1<? super KtElement, ? extends BindingContext>)((Function1)new Function1<KtElement, BindingContext>(this, bodyResolveMode){
            final /* synthetic */ CodeFragmentAnalyzer this$0;
            final /* synthetic */ BodyResolveMode $bodyResolveMode;
            {
                this.this$0 = $receiver;
                this.$bodyResolveMode = $bodyResolveMode;
                super(1, Intrinsics.Kotlin.class, "resolutionFactory", "analyzeCodeFragmentContext$resolutionFactory(Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;Lorg/jetbrains/kotlin/resolve/lazy/BodyResolveMode;Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/resolve/BindingContext;", 0);
            }

            @NotNull
            public final BindingContext invoke(@NotNull KtElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return CodeFragmentAnalyzer.access$analyzeCodeFragmentContext$resolutionFactory(this.this$0, this.$bodyResolveMode, p0);
            }
        }));
        return ContextInfo.copy$default(info2, null, this.enrichScopeWithImports(info2.getScope(), codeFragment), null, 5, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ContextInfo getContextInfo(PsiElement context2, Function1<? super KtElement, ? extends BindingContext> resolutionFactory) {
        LexicalScope lexicalScope;
        BindingContext bindingContext2;
        LexicalScope scope2;
        DataFlowInfo dataFlowInfo;
        while (true) {
            PsiElement parentDeclaration;
            PsiElement psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)BindingContext.EMPTY, (String)"EMPTY");
            dataFlowInfo = DataFlowInfo.Companion.getEMPTY();
            scope2 = null;
            PsiElement psiElement3 = context2;
            if (psiElement3 instanceof KtPrimaryConstructor) {
                KtClassOrObject containingClass = ((KtPrimaryConstructor)context2).getContainingClassOrObject();
                ClassResolutionResult resolutionResult = this_.getClassDescriptor(containingClass, resolutionFactory);
                if (resolutionResult != null) {
                    bindingContext2 = resolutionResult.getBindingContext();
                    scope2 = resolutionResult.getDescriptor().getScopeForInitializerResolution();
                }
            } else if (psiElement3 instanceof KtSecondaryConstructor) {
                KtBlockExpression expression2;
                KtBlockExpression ktBlockExpression = ((KtSecondaryConstructor)context2).getBodyExpression();
                if (ktBlockExpression == null) {
                    ktBlockExpression = ((KtSecondaryConstructor)context2).getDelegationCallOrNull();
                }
                if ((expression2 = ktBlockExpression) != null) {
                    bindingContext2 = (BindingContext)resolutionFactory.invoke((Object)expression2);
                    scope2 = (LexicalScope)bindingContext2.get((ReadOnlySlice)BindingContext.LEXICAL_SCOPE, (Object)expression2);
                }
            } else if (psiElement3 instanceof KtClassOrObject) {
                ClassResolutionResult resolutionResult = this_.getClassDescriptor((KtClassOrObject)context2, resolutionFactory);
                if (resolutionResult != null) {
                    bindingContext2 = resolutionResult.getBindingContext();
                    scope2 = resolutionResult.getDescriptor().getScopeForMemberDeclarationResolution();
                }
            } else if (psiElement3 instanceof KtFunction) {
                BindingContext bindingContextForFunction = (BindingContext)resolutionFactory.invoke((Object)context2);
                SimpleFunctionDescriptor functionDescriptor2 = (SimpleFunctionDescriptor)bindingContextForFunction.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)context2);
                if (functionDescriptor2 != null) {
                    void $this$getParentOfType$iv;
                    bindingContext2 = bindingContextForFunction;
                    psiElement2 = context2;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    LexicalScope outerScope = this_.getContextInfo(PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, (boolean)strict$iv), resolutionFactory).getScope();
                    LocalRedeclarationChecker.DO_NOTHING localRedeclarationChecker = LocalRedeclarationChecker.DO_NOTHING.INSTANCE;
                    scope2 = FunctionDescriptorUtil.getFunctionInnerScope((LexicalScope)outerScope, (FunctionDescriptor)((FunctionDescriptor)functionDescriptor2), (LocalRedeclarationChecker)((LocalRedeclarationChecker)localRedeclarationChecker));
                }
            } else if (psiElement3 instanceof KtFile) {
                BindingContext bindingContext3 = this_.resolveSession.getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext3, (String)"resolveSession.bindingContext");
                bindingContext2 = bindingContext3;
                scope2 = this_.resolveSession.getFileScopeProvider().getFileResolutionScope((KtFile)context2);
            } else if (psiElement3 instanceof KtElement) {
                bindingContext2 = (BindingContext)resolutionFactory.invoke((Object)context2);
                scope2 = ScopeUtils.getResolutionScope(context2, bindingContext2);
                dataFlowInfo = BindingContextUtilsKt.getDataFlowInfoAfter((BindingContext)bindingContext2, (PsiElement)context2);
            }
            if (scope2 != null) break;
            if (context2 != null) {
                PsiElement $this$getParentOfTypes3$iv;
                boolean $i$f$getParentOfTypes3 = false;
                psiElement2 = new PsiElement[]{KtDeclaration.class, KtFile.class, KtExpression.class};
                v2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfTypes3$iv, (Class[])psiElement2);
            } else {
                v2 = parentDeclaration = null;
            }
            if (parentDeclaration == null) break;
            CodeFragmentAnalyzer codeFragmentAnalyzer = this_;
            Function1<? super KtElement, ? extends BindingContext> function1 = resolutionFactory;
            CodeFragmentAnalyzer this_ = codeFragmentAnalyzer;
            context2 = parentDeclaration;
            resolutionFactory = function1;
        }
        if ((lexicalScope = scope2) == null) {
            ModuleDescriptor moduleDescriptor = this_.resolveSession.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"resolveSession.moduleDescriptor");
            lexicalScope = this_.createEmptyScope(moduleDescriptor);
        }
        return new ContextInfo(bindingContext2, lexicalScope, dataFlowInfo);
    }

    private final ClassResolutionResult getClassDescriptor(KtClassOrObject classOrObject, Function1<? super KtElement, ? extends BindingContext> resolutionFactory) {
        ClassResolutionResult classResolutionResult;
        BindingContext bindingContext2 = null;
        ClassDescriptor classDescriptor = null;
        if (!KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)classOrObject))) {
            BindingContext bindingContext3 = this.resolveSession.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext3, (String)"resolveSession.bindingContext");
            bindingContext2 = bindingContext3;
            classDescriptor = this.resolveSession.getClassDescriptor(classOrObject, (LookupLocation)NoLookupLocation.FROM_IDE);
        } else {
            bindingContext2 = (BindingContext)resolutionFactory.invoke((Object)classOrObject);
            classDescriptor = (ClassDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)classOrObject);
        }
        ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)classDescriptor : null;
        if (classDescriptorWithResolutionScopes != null) {
            ClassDescriptorWithResolutionScopes it = classDescriptorWithResolutionScopes;
            boolean bl = false;
            classResolutionResult = new ClassResolutionResult(bindingContext2, it);
        } else {
            classResolutionResult = null;
        }
        return classResolutionResult;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement refineContextElement(PsiElement context2) {
        Object object;
        PsiElement psiElement2 = context2;
        if (psiElement2 instanceof KtParameter) {
            void $this$getParentOfType$iv;
            PsiElement psiElement3 = context2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            object = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtFunction.class, (boolean)strict$iv);
        } else if (psiElement2 instanceof KtProperty) {
            object = ((KtProperty)context2).getDelegateExpressionOrInitializer();
        } else if (psiElement2 instanceof KtConstructor) {
            object = (KtExpression)context2;
        } else if (psiElement2 instanceof KtFunctionLiteral) {
            Object object2 = ((KtFunctionLiteral)context2).getBodyExpression();
            object = object2 != null && (object2 = object2.getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull((List)object2) : null;
        } else if (psiElement2 instanceof KtDeclarationWithBody) {
            object = ((KtDeclarationWithBody)context2).getBodyExpression();
        } else if (psiElement2 instanceof KtBlockExpression) {
            List list2 = ((KtBlockExpression)context2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"context.statements");
            object = (KtExpression)CollectionsKt.lastOrNull((List)list2);
        } else {
            object = null;
        }
        return object != null ? (KtElement)object : (context2 instanceof KtElement ? (KtElement)context2 : null);
    }

    private final LexicalScope enrichScopeWithImports(LexicalScope scope2, KtCodeFragment codeFragment) {
        KtImportList importList;
        List externalDescriptors;
        List additionalImportingScopes = new ArrayList();
        List list2 = CodeFragmentUtilsKt.getExternalDescriptors(codeFragment);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if (!((Collection)(externalDescriptors = list2)).isEmpty()) {
            ((Collection)additionalImportingScopes).add(new ExplicitImportsScope(externalDescriptors));
        }
        if ((importList = codeFragment.importsAsImportList()) != null) {
            List list3 = importList.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"importList.imports");
            if (!((Collection)list3).isEmpty()) {
                CollectionsKt.addAll((Collection)additionalImportingScopes, (Iterable)this.createImportScopes(importList));
            }
        }
        if (!((Collection)additionalImportingScopes).isEmpty()) {
            return ScopeUtilsKt.addImportingScopes((LexicalScope)scope2, (List)additionalImportingScopes);
        }
        return scope2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImportingScope> createImportScopes(KtImportList importList) {
        void $this$mapNotNullTo$iv$iv;
        List list2 = importList.getImports();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"importList.imports");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ImportingScope it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtImportDirective it = (KtImportDirective)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            KtImportInfo ktImportInfo = (KtImportInfo)it;
            ModuleDescriptor moduleDescriptor = this.resolveSession.getModuleDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"resolveSession.moduleDescriptor");
            BindingTrace bindingTrace = this.resolveSession.getTrace();
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"resolveSession.trace");
            if (this.qualifierResolver.processImportReference(ktImportInfo, moduleDescriptor, bindingTrace, (Collection)CollectionsKt.emptyList(), null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LexicalScope createEmptyScope(ModuleDescriptor moduleDescriptor) {
        return (LexicalScope)new LexicalScope.Base((HierarchicalScope)ImportingScope.Empty.INSTANCE, (DeclarationDescriptor)moduleDescriptor);
    }

    private static final BindingContext analyzeCodeFragmentContext$resolutionFactory(CodeFragmentAnalyzer this$0, BodyResolveMode $bodyResolveMode, KtElement element3) {
        return this$0.getResolveElementCache().resolveToElement(element3, $bodyResolveMode);
    }

    public static final /* synthetic */ BindingContext access$analyzeCodeFragmentContext$resolutionFactory(CodeFragmentAnalyzer this$0, BodyResolveMode $bodyResolveMode, KtElement element3) {
        return CodeFragmentAnalyzer.analyzeCodeFragmentContext$resolutionFactory(this$0, $bodyResolveMode, element3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ClassResolutionResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.fe10.analysis"})
    private static final class ClassResolutionResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ClassDescriptorWithResolutionScopes descriptor;

        public ClassResolutionResult(@NotNull BindingContext bindingContext2, @NotNull ClassDescriptorWithResolutionScopes descriptor2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.bindingContext = bindingContext2;
            this.descriptor = descriptor2;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ClassDescriptorWithResolutionScopes getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ClassDescriptorWithResolutionScopes component2() {
            return this.descriptor;
        }

        @NotNull
        public final ClassResolutionResult copy(@NotNull BindingContext bindingContext2, @NotNull ClassDescriptorWithResolutionScopes descriptor2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            return new ClassResolutionResult(bindingContext2, descriptor2);
        }

        public static /* synthetic */ ClassResolutionResult copy$default(ClassResolutionResult classResolutionResult, BindingContext bindingContext2, ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = classResolutionResult.bindingContext;
            }
            if ((n & 2) != 0) {
                classDescriptorWithResolutionScopes = classResolutionResult.descriptor;
            }
            return classResolutionResult.copy(bindingContext2, classDescriptorWithResolutionScopes);
        }

        @NotNull
        public String toString() {
            return "ClassResolutionResult(bindingContext=" + this.bindingContext + ", descriptor=" + this.descriptor + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.descriptor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ClassResolutionResult)) {
                return false;
            }
            ClassResolutionResult classResolutionResult = (ClassResolutionResult)other2;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)classResolutionResult.bindingContext)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.descriptor, (Object)classResolutionResult.descriptor);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$Companion;", "", "()V", "EXPECTED_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getEXPECTED_TYPE_KEY", "()Lcom/intellij/openapi/util/Key;", "kotlin.base.fe10.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<KotlinType> getEXPECTED_TYPE_KEY() {
            return EXPECTED_TYPE_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer$ContextInfo;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.base.fe10.analysis"})
    private static final class ContextInfo {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final LexicalScope scope;
        @NotNull
        private final DataFlowInfo dataFlowInfo;

        public ContextInfo(@NotNull BindingContext bindingContext2, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            this.bindingContext = bindingContext2;
            this.scope = scope2;
            this.dataFlowInfo = dataFlowInfo;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final LexicalScope getScope() {
            return this.scope;
        }

        @NotNull
        public final DataFlowInfo getDataFlowInfo() {
            return this.dataFlowInfo;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final LexicalScope component2() {
            return this.scope;
        }

        @NotNull
        public final DataFlowInfo component3() {
            return this.dataFlowInfo;
        }

        @NotNull
        public final ContextInfo copy(@NotNull BindingContext bindingContext2, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)dataFlowInfo, (String)"dataFlowInfo");
            return new ContextInfo(bindingContext2, scope2, dataFlowInfo);
        }

        public static /* synthetic */ ContextInfo copy$default(ContextInfo contextInfo, BindingContext bindingContext2, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = contextInfo.bindingContext;
            }
            if ((n & 2) != 0) {
                lexicalScope = contextInfo.scope;
            }
            if ((n & 4) != 0) {
                dataFlowInfo = contextInfo.dataFlowInfo;
            }
            return contextInfo.copy(bindingContext2, lexicalScope, dataFlowInfo);
        }

        @NotNull
        public String toString() {
            return "ContextInfo(bindingContext=" + this.bindingContext + ", scope=" + this.scope + ", dataFlowInfo=" + this.dataFlowInfo + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.scope.hashCode();
            result2 = result2 * 31 + this.dataFlowInfo.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ContextInfo)) {
                return false;
            }
            ContextInfo contextInfo = (ContextInfo)other2;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)contextInfo.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scope, (Object)contextInfo.scope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dataFlowInfo, (Object)contextInfo.dataFlowInfo);
        }
    }
}

