/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020CH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0006R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000fR\u0012\u0010-\u001a\u00020.X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0012\u00109\u001a\u00020:X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0>X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticContext;", "()V", "allErrorsSuppressed", "", "getAllErrorsSuppressed", "()Z", "allInfosSuppressed", "getAllInfosSuppressed", "allWarningsSuppressed", "getAllWarningsSuppressed", "annotationContainers", "", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getAnnotationContainers", "()Ljava/util/List;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "containingElements", "Lorg/jetbrains/kotlin/fir/FirElement;", "getContainingElements", "containingFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getContainingFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingFilePath", "", "getContainingFilePath", "()Ljava/lang/String;", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "isContractBody", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "qualifiedAccessOrAssignmentsOrAnnotationCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getQualifiedAccessOrAssignmentsOrAnnotationCalls", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "suppressedDiagnostics", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "isDiagnosticSuppressed", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "checkers"})
public abstract class CheckerContext
implements DiagnosticContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract ImplicitReceiverStack getImplicitReceiverStack();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirStatement> getQualifiedAccessOrAssignmentsOrAnnotationCalls();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract List<FirAnnotationContainer> getAnnotationContainers();

    @NotNull
    public abstract List<FirElement> getContainingElements();

    public abstract boolean isContractBody();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.getSessionHolder().getScopeSession();
    }

    public boolean isDiagnosticSuppressed(@NotNull KtDiagnostic diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        AbstractKtDiagnosticFactory factory2 = diagnostic.getFactory();
        String name2 = factory2.getName();
        switch (WhenMappings.$EnumSwitchMapping$0[factory2.getSeverity().ordinal()]) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name2);
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession());
    }

    @Nullable
    public abstract FirFile getContainingFile();

    @Nullable
    public String getContainingFilePath() {
        FirFile firFile = this.getContainingFile();
        return firFile != null && (firFile = firFile.getSourceFile()) != null ? firFile.getPath() : null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            try {
                nArray[Severity.INFO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Severity.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

