/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002JM\u0010\u000f\u001a\u00020\t\"\b\b\u0000\u0010\u0010*\u00020\u00072\u0006\u0010\r\u001a\u0002H\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\t0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "binaryCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "sourceCache", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "module", "createSession", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Ljava/util/concurrent/ConcurrentMap;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "getSession", "preferBinary", "", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n47#2,2:127\n1726#3,3:129\n1726#3,3:132\n1726#3,3:135\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n66#1:127,2\n91#1:129,3\n92#1:132,3\n93#1:135,3\n*E\n"})
public final class LLFirSessionCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<KtModule, CachedValue<LLFirSession>> sourceCache;
    @NotNull
    private final ConcurrentMap<KtModule, CachedValue<LLFirSession>> binaryCache;

    public LLFirSessionCache(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.sourceCache = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentSoftValueMap(...)");
        this.binaryCache = concurrentMap2;
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KtModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        if (module2 instanceof KtBinaryModule && (preferBinary || module2 instanceof KtSdkModule)) {
            return this.getCachedSession(module2, this.binaryCache, (Function1)new Function1<KtBinaryModule, LLFirSession>(this, module2){
                final /* synthetic */ LLFirSessionCache this$0;
                final /* synthetic */ KtModule $module;
                {
                    this.this$0 = $receiver;
                    this.$module = $module;
                    super(1);
                }

                @NotNull
                public final LLFirSession invoke(@NotNull KtBinaryModule it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return LLFirSessionCache.access$createPlatformAwareSessionFactory(this.this$0, this.$module).createBinaryLibrarySession((KtBinaryModule)this.$module);
                }
            });
        }
        return this.getCachedSession(module2, this.sourceCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

            @NotNull
            public final LLFirSession invoke(@NotNull KtModule p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            @NotNull
            public final String getName() {
                return "createSession";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KtModule ktModule, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(ktModule, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.createSession(module2);
    }

    private final <T extends KtModule> LLFirSession getCachedSession(T module2, ConcurrentMap<KtModule, CachedValue<LLFirSession>> storage, Function1<? super T, ? extends LLFirSession> factory2) {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        Object object = storage.computeIfAbsent(module2, arg_0 -> LLFirSessionCache.getCachedSession$lambda$0((Function1)new Function1<KtModule, CachedValue<LLFirSession>>(this, factory2, module2){
            final /* synthetic */ LLFirSessionCache this$0;
            final /* synthetic */ Function1<T, LLFirSession> $factory;
            final /* synthetic */ T $module;
            {
                this.this$0 = $receiver;
                this.$factory = $factory;
                this.$module = $module;
                super(1);
            }

            public final CachedValue<LLFirSession> invoke(KtModule it) {
                return CachedValuesManager.getManager((Project)LLFirSessionCache.access$getProject$p(this.this$0)).createCachedValue(() -> getCachedSession.1.invoke$lambda$0(this.$factory, this.$module));
            }

            private static final CachedValueProvider.Result invoke$lambda$0(Function1 $factory, KtModule $module) {
                Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
                Intrinsics.checkNotNullParameter((Object)$module, (String)"$module");
                LLFirSession session = (LLFirSession)((Object)$factory.invoke((Object)$module));
                Object[] objectArray = new Object[]{session.getModificationTracker()};
                return new CachedValueProvider.Result((Object)((Object)session), objectArray);
            }
        }, arg_0)).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LLFirSession)((Object)object);
    }

    private final LLFirSession createSession(KtModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KtModule ktModule = module2;
        if (ktModule instanceof KtSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KtSourceModule)module2);
        } else if (ktModule instanceof KtLibraryModule ? true : ktModule instanceof KtLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (ktModule instanceof KtSdkModule) {
            lLFirSession = sessionFactory.createBinaryLibrarySession((KtBinaryModule)module2);
        } else if (ktModule instanceof KtScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KtScriptModule)module2);
        } else if (ktModule instanceof KtNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KtNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KtModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block13: {
            targetPlatform = module2.getPlatform();
            $this$all$iv = (Iterable)targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block14: {
                $this$all$iv = (Iterable)targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block15: {
                    $this$all$iv = (Iterable)targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof NativePlatform) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                lLFirAbstractSessionFactory = bl5 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirJvmSessionFactory(this.project);
            }
        }
        return lLFirAbstractSessionFactory;
    }

    private static final CachedValue getCachedSession$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CachedValue)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LLFirAbstractSessionFactory access$createPlatformAwareSessionFactory(LLFirSessionCache $this, KtModule module2) {
        return $this.createPlatformAwareSessionFactory(module2);
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KtModule module2) {
        return $this.createSession(module2);
    }

    public static final /* synthetic */ Project access$getProject$p(LLFirSessionCache $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(LLFirSessionCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LLFirSessionCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

