/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H$J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "allowTopLevelCallables", "", "generateNamesForRegeneratedObjects", "(ZZ)V", "computeTopLevelClassName", "", "clazz", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "putLocalClassName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "sanitizeNameIfNeeded", "name", "Data", "NameInventor", "ir.backend.common"})
public abstract class InventNamesForLocalClasses
implements FileLoweringPass {
    private final boolean allowTopLevelCallables;
    private final boolean generateNamesForRegeneratedObjects;

    public InventNamesForLocalClasses(boolean allowTopLevelCallables, boolean generateNamesForRegeneratedObjects) {
        this.allowTopLevelCallables = allowTopLevelCallables;
        this.generateNamesForRegeneratedObjects = generateNamesForRegeneratedObjects;
    }

    public /* synthetic */ InventNamesForLocalClasses(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    @NotNull
    protected abstract String computeTopLevelClassName(@NotNull IrClass var1);

    @NotNull
    protected abstract String sanitizeNameIfNeeded(@NotNull String var1);

    protected abstract void putLocalClassName(@NotNull IrAttributeContainer var1, @NotNull String var2);

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept(new NameInventor(), new Data(null, false, false, 4, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0000J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$Data;", "", "enclosingName", "", "isLocal", "", "processingInlinedFunction", "(Ljava/lang/String;ZZ)V", "getEnclosingName", "()Ljava/lang/String;", "()Z", "getProcessingInlinedFunction", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "makeLocal", "toString", "ir.backend.common"})
    private static final class Data {
        @Nullable
        private final String enclosingName;
        private final boolean isLocal;
        private final boolean processingInlinedFunction;

        public Data(@Nullable String enclosingName, boolean isLocal, boolean processingInlinedFunction) {
            this.enclosingName = enclosingName;
            this.isLocal = isLocal;
            this.processingInlinedFunction = processingInlinedFunction;
        }

        public /* synthetic */ Data(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @Nullable
        public final String getEnclosingName() {
            return this.enclosingName;
        }

        public final boolean isLocal() {
            return this.isLocal;
        }

        public final boolean getProcessingInlinedFunction() {
            return this.processingInlinedFunction;
        }

        @NotNull
        public final Data makeLocal() {
            return this.isLocal ? this : Data.copy$default(this, null, true, false, 5, null);
        }

        @Nullable
        public final String component1() {
            return this.enclosingName;
        }

        public final boolean component2() {
            return this.isLocal;
        }

        public final boolean component3() {
            return this.processingInlinedFunction;
        }

        @NotNull
        public final Data copy(@Nullable String enclosingName, boolean isLocal, boolean processingInlinedFunction) {
            return new Data(enclosingName, isLocal, processingInlinedFunction);
        }

        public static /* synthetic */ Data copy$default(Data data, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = data.enclosingName;
            }
            if ((n & 2) != 0) {
                bl = data.isLocal;
            }
            if ((n & 4) != 0) {
                bl2 = data.processingInlinedFunction;
            }
            return data.copy(string, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Data(enclosingName=" + this.enclosingName + ", isLocal=" + this.isLocal + ", processingInlinedFunction=" + this.processingInlinedFunction + ')';
        }

        public int hashCode() {
            int result2 = this.enclosingName == null ? 0 : this.enclosingName.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isLocal);
            result2 = result2 * 31 + Boolean.hashCode(this.processingInlinedFunction);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.enclosingName, (Object)data.enclosingName)) {
                return false;
            }
            if (this.isLocal != data.isLocal) {
                return false;
            }
            return this.processingInlinedFunction == data.processingInlinedFunction;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$NameInventor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$Data;", "(Lorg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses;)V", "anonymousClassesCount", "", "", "", "localFunctionNames", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inventName", "sourceName", "Lorg/jetbrains/kotlin/name/Name;", "data", "visitAnonymousInitializer", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitContainerExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "ir.backend.common"})
    @SourceDebugExtension(value={"SMAP\nInventNamesForLocalClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InventNamesForLocalClasses.kt\norg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$NameInventor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1855#2,2:239\n1855#2,2:241\n1855#2,2:243\n*S KotlinDebug\n*F\n+ 1 InventNamesForLocalClasses.kt\norg/jetbrains/kotlin/backend/common/lower/InventNamesForLocalClasses$NameInventor\n*L\n52#1:239,2\n56#1:241,2\n62#1:243,2\n*E\n"})
    private final class NameInventor
    implements IrElementVisitor<Unit, Data> {
        @NotNull
        private final Map<String, Integer> anonymousClassesCount = new LinkedHashMap();
        @NotNull
        private final Map<IrFunctionSymbol, String> localFunctionNames = new LinkedHashMap();

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (expression instanceof IrInlinedFunctionBlock && !InventNamesForLocalClasses.this.generateNamesForRegeneratedObjects) {
                Iterable $this$forEach$iv = IrInlineUtilsKt.getNonDefaultAdditionalStatementsFromInlinedBlock((IrInlinedFunctionBlock)expression);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.accept(this, data);
                }
                return;
            }
            if (!data.getProcessingInlinedFunction() && expression instanceof IrInlinedFunctionBlock && IrInlineUtilsKt.isFunctionInlining((IrInlinedFunctionBlock)expression)) {
                Iterable $this$forEach$iv = IrInlineUtilsKt.getAdditionalStatementsFromInlinedBlock((IrInlinedFunctionBlock)expression);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.accept(this, data);
                }
                String string = ((IrFunctionSymbol)((IrInlinedFunctionBlock)expression).getInlineCall().getSymbol()).getOwner().getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String inlinedAt = string;
                Data newData = data.copy(data.getEnclosingName() + "$$inlined$" + inlinedAt, true, true);
                Iterable $this$forEach$iv2 = IrInlineUtilsKt.getOriginalStatementsFromInlinedBlock((IrInlinedFunctionBlock)expression);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl = false;
                    it.accept(this, newData);
                }
                return;
            }
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!data.isLocal()) {
                String enclosingName = data.getEnclosingName();
                String internalName2 = enclosingName != null ? enclosingName + '$' + declaration.getName().asString() : InventNamesForLocalClasses.this.computeTopLevelClassName(declaration);
                declaration.acceptChildren(this, Data.copy$default(data, internalName2, false, false, 6, null));
                return;
            }
            String internalName3 = this.inventName(declaration.getName(), data);
            InventNamesForLocalClasses.this.putLocalClassName(declaration, internalName3);
            Data newData = Data.copy$default(data, internalName3, false, false, 6, null);
            Data newDataForConstructor = IrUtilsKt.isAnonymousObject(declaration) ? data : newData;
            for (IrDeclaration child : declaration.getDeclarations()) {
                child.accept(this, child instanceof IrConstructor ? newDataForConstructor : newData);
            }
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            declaration.acceptChildren(this, data.makeLocal());
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data) {
            String string;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!(declaration instanceof IrDeclarationWithName) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_DELEGATE.INSTANCE)) {
                declaration.acceptChildren(this, data);
                return;
            }
            String enclosingName = data.getEnclosingName();
            String string2 = ((IrDeclarationWithName)((Object)declaration)).getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            String simpleName = string2;
            if (declaration instanceof IrFunction && !NameUtils.hasName((Name)((IrDeclarationWithName)((Object)declaration)).getName())) {
                String string3;
                String name = string3 = this.inventName(null, data);
                boolean bl = false;
                this.localFunctionNames.put(((IrFunction)declaration).getSymbol(), name);
                string = string3;
            } else {
                string = declaration instanceof IrVariable && InventNamesForLocalClasses.this.generateNamesForRegeneratedObjects || data.getProcessingInlinedFunction() ? enclosingName : (enclosingName != null ? enclosingName + '$' + simpleName : simpleName);
            }
            String internalName2 = string;
            Data newData = Data.copy$default(data, internalName2, true, false, 4, null);
            if (declaration instanceof IrProperty && ((IrProperty)declaration).isDelegated() || declaration instanceof IrLocalDelegatedProperty) {
                this.inventName(null, newData);
            }
            declaration.acceptChildren(this, newData);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (data.getProcessingInlinedFunction() && expression.getOriginalBeforeInline() == null) {
                return;
            }
            String string = this.localFunctionNames.get(expression.getSymbol());
            if (string == null) {
                string = this.inventName(null, data);
            }
            String internalName2 = string;
            InventNamesForLocalClasses.this.putLocalClassName(expression, internalName2);
            expression.acceptChildren(this, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            expression.acceptChildren(this, data);
            String string = this.localFunctionNames.get(expression.getFunction().getSymbol());
            if (string == null) {
                string = this.inventName(null, data);
            }
            String internalName2 = string;
            InventNamesForLocalClasses.this.putLocalClassName(expression, internalName2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String internalName2 = this.inventName(null, data);
            InventNamesForLocalClasses.this.putLocalClassName(expression, internalName2);
            expression.acceptChildren(this, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            declaration.acceptChildren(this, data.makeLocal());
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            declaration.acceptChildren(this, data.makeLocal());
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration.getCorrespondingPropertySymbol() != null) {
                declaration.acceptChildren(this, data.makeLocal());
                return;
            }
            if (declaration.isSuspend() && declaration.getBody() != null && !Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE)) {
                Data newData = Data.copy$default(data, this.inventName(declaration.getName(), data.getEnclosingName() == null && InventNamesForLocalClasses.this.allowTopLevelCallables ? Data.copy$default(data, "", false, false, 6, null) : data), false, false, 6, null);
                String internalName2 = this.inventName(null, newData);
                InventNamesForLocalClasses.this.putLocalClassName(declaration, internalName2);
            }
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            declaration.acceptChildren(this, data.makeLocal());
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            declaration.acceptChildren(this, data.makeLocal());
        }

        @Override
        public void visitElement(@NotNull IrElement element, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element.acceptChildren(this, data);
        }

        private final String inventName(Name sourceName, Data data) {
            Comparable comparable;
            String enclosingName = data.getEnclosingName();
            if (!(enclosingName != null)) {
                boolean $i$a$-check-InventNamesForLocalClasses$NameInventor$inventName$22 = false;
                String $i$a$-check-InventNamesForLocalClasses$NameInventor$inventName$22 = StringsKt.trimIndent((String)("\n                    There should be at least one name in the stack for every local declaration that needs a name\n                    Source name: " + sourceName + "\n                    Data: " + data + "\n                "));
                throw new IllegalStateException($i$a$-check-InventNamesForLocalClasses$NameInventor$inventName$22.toString());
            }
            if (sourceName == null || sourceName.isSpecial()) {
                Integer n = this.anonymousClassesCount.get(CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)enclosingName));
                int count = (n != null ? n : 0) + 1;
                Integer n2 = count;
                this.anonymousClassesCount.put(CapitalizeDecapitalizeKt.toUpperCaseAsciiOnly((String)enclosingName), n2);
                comparable = (Comparable)((Object)String.valueOf(count));
            } else {
                comparable = (Comparable)sourceName;
            }
            Comparable simpleName = comparable;
            return InventNamesForLocalClasses.this.sanitizeNameIfNeeded(enclosingName + '$' + simpleName);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression, data);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression, data);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConstantArray(this, expression, data);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConstantObject(this, expression, data);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression, data);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConstantValue(this, expression, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitExpression(this, expression, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Data data) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

