/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.ProjectDumbIndexingHistory;
import com.intellij.util.indexing.diagnostic.ProjectIndexingActivityHistoryListener;
import com.intellij.util.indexing.diagnostic.ProjectScanningHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectIndexingHistoryListener;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingActivityHistoryListener;", "()V", "check", "", "project", "Lcom/intellij/openapi/project/Project;", "wasInterrupted", "", "totalNumberOfIndexedFilesProvider", "Lkotlin/Function0;", "", "indexingDurationProvider", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider", "onFinishedDumbIndexing", "history", "Lcom/intellij/util/indexing/diagnostic/ProjectDumbIndexingHistory;", "onFinishedScanning", "Lcom/intellij/util/indexing/diagnostic/ProjectScanningHistory;", "intellij.indexing.shared"})
public final class SharedIndexProjectIndexingHistoryListener
implements ProjectIndexingActivityHistoryListener {
    public void onFinishedScanning(@NotNull ProjectScanningHistory history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.check(history.getProject(), history.getTimes().getWasInterrupted(), (Function0<Integer>)((Function0)new Function0<Integer>(history){
            final /* synthetic */ ProjectScanningHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                Iterable iterable = this.$history.getScanningStatistics();
                int n = 0;
                for (T t : iterable) {
                    void statistics;
                    JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = statistics.getNumberOfFilesForIndexing() + statistics.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
                    n = n2 + n3;
                }
                return n;
            }
        }), (Function0<Long>)((Function0)new Function0<Long>(history){
            final /* synthetic */ ProjectScanningHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.$history.getTimes().getTotalUpdatingTime();
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(history){
            final /* synthetic */ ProjectScanningHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                Iterable iterable = this.$history.getScanningStatistics();
                int n = 0;
                for (T t : iterable) {
                    void statistics;
                    JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = statistics.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
                    n = n2 + n3;
                }
                return n;
            }
        }));
    }

    public void onFinishedDumbIndexing(@NotNull ProjectDumbIndexingHistory history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.check(history.getProject(), history.getTimes().getWasInterrupted(), (Function0<Integer>)((Function0)new Function0<Integer>(history){
            final /* synthetic */ ProjectDumbIndexingHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                Iterable iterable = this.$history.getProviderStatistics();
                int n = 0;
                for (T t : iterable) {
                    void statistics;
                    JsonFileProviderIndexStatistics jsonFileProviderIndexStatistics = (JsonFileProviderIndexStatistics)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = statistics.getTotalNumberOfIndexedFiles();
                    n = n2 + n3;
                }
                return n;
            }
        }), (Function0<Long>)((Function0)new Function0<Long>(history){
            final /* synthetic */ ProjectDumbIndexingHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.$history.getTimes().getTotalUpdatingTime();
            }
        }), (Function0<Integer>)((Function0)new Function0<Integer>(history){
            final /* synthetic */ ProjectDumbIndexingHistory $history;
            {
                this.$history = $history;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Integer invoke() {
                Iterable iterable = this.$history.getProviderStatistics();
                int n = 0;
                for (T t : iterable) {
                    void statistics;
                    JsonFileProviderIndexStatistics jsonFileProviderIndexStatistics = (JsonFileProviderIndexStatistics)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = statistics.getTotalNumberOfFilesFullyIndexedByExtensions();
                    n = n2 + n3;
                }
                return n;
            }
        }));
    }

    public final void check(@NotNull Project project, boolean wasInterrupted, @NotNull Function0<Integer> totalNumberOfIndexedFilesProvider, @NotNull Function0<Long> indexingDurationProvider, @NotNull Function0<Integer> totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(totalNumberOfIndexedFilesProvider, (String)"totalNumberOfIndexedFilesProvider");
        Intrinsics.checkNotNullParameter(indexingDurationProvider, (String)"indexingDurationProvider");
        Intrinsics.checkNotNullParameter(totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider, (String)"totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider");
        if (wasInterrupted) {
            return;
        }
        int totalNumberOfIndexedFiles = ((Number)totalNumberOfIndexedFilesProvider.invoke()).intValue();
        if (totalNumberOfIndexedFiles < 100) {
            return;
        }
        long indexingDuration = Duration.ofNanos(((Number)indexingDurationProvider.invoke()).longValue()).toMillis();
        if (indexingDuration <= Duration.ofSeconds(20L).toMillis()) {
            return;
        }
        int totalNumberOfFilesFullyIndexedByInfrastructureExtensions = ((Number)totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider.invoke()).intValue();
        if (totalNumberOfFilesFullyIndexedByInfrastructureExtensions < 100) {
            return;
        }
        int percentage = (int)((double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / (double)totalNumberOfIndexedFiles * (double)100);
        if (percentage < 20) {
            return;
        }
        double usualIndexingSpeed = (double)(totalNumberOfIndexedFiles - totalNumberOfFilesFullyIndexedByInfrastructureExtensions) / (double)indexingDuration;
        double savedTime = (double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / usualIndexingSpeed;
        Object[] objectArray = new Object[]{NlsMessages.formatDurationApproximate((long)indexingDuration), totalNumberOfFilesFullyIndexedByInfrastructureExtensions, totalNumberOfIndexedFiles, percentage, NlsMessages.formatDurationApproximate((long)((long)savedTime))};
        String string = SharedIndexesBundle.message("eventLog.indexing.completed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\n      \"eventLog\u2026savedTime.toLong())\n    )");
        String messageText2 = string;
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexing Log").createNotification(messageText2, NotificationType.INFORMATION).notify(project);
    }
}

