/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.indexing.shared.download.SharedIndexLineup;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.metadata.SharedIndexGenerationStatistics;
import com.intellij.indexing.shared.metadata.SharedIndexIntellijMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadata;
import com.intellij.indexing.shared.metadata.SharedIndexMetadataInfo;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureCapability;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.indexing.FileBasedIndexVersionInfo;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "", "indexName", "", "indexKind", "indexInfrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "sharedIndexInfo", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "generationStatistics", "Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;", "generationTime", "Ljava/time/ZonedDateTime;", "intellij", "Lcom/intellij/indexing/shared/metadata/SharedIndexIntellijMetadata;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;Ljava/time/ZonedDateTime;Lcom/intellij/indexing/shared/metadata/SharedIndexIntellijMetadata;)V", "getGenerationStatistics", "()Lcom/intellij/indexing/shared/metadata/SharedIndexGenerationStatistics;", "getGenerationTime", "()Ljava/time/ZonedDateTime;", "getIndexInfrastructureVersion", "()Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "getIndexKind", "()Ljava/lang/String;", "getIndexName", "getIntellij", "()Lcom/intellij/indexing/shared/metadata/SharedIndexIntellijMetadata;", "getSharedIndexInfo", "()Lcom/intellij/indexing/shared/metadata/SharedIndexMetadataInfo;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.indexing.shared"})
public final class SharedIndexMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String indexName;
    @NotNull
    private final String indexKind;
    @NotNull
    private final SharedIndexInfrastructureVersion indexInfrastructureVersion;
    @NotNull
    private final SharedIndexMetadataInfo sharedIndexInfo;
    @NotNull
    private final SharedIndexGenerationStatistics generationStatistics;
    @NotNull
    private final ZonedDateTime generationTime;
    @NotNull
    private final SharedIndexIntellijMetadata intellij;
    @NotNull
    public static final String METADATA_VERSION = "7";
    @NotNull
    private static final Companion.TextValue.1 TextValue = new Companion.LoadSaveValue<String>(){

        @Nullable
        public String loadValue(@Nullable JsonNode node) {
            JsonNode jsonNode = node;
            return jsonNode != null ? jsonNode.asText() : null;
        }

        public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            node.put(key, value);
        }
    };
    @NotNull
    private static final Companion.BooleanValue.1 BooleanValue = new Companion.LoadSaveValue<Boolean>(){

        @Nullable
        public Boolean loadValue(@Nullable JsonNode node) {
            JsonNode jsonNode = node;
            return jsonNode != null ? Boolean.valueOf(jsonNode.asBoolean()) : null;
        }

        public void saveValue(@NotNull ObjectNode node, @NotNull String key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            node.put(key, value);
        }
    };
    @NotNull
    private static final Companion.IntValue.1 IntValue = new Companion.LoadSaveValue<Integer>(){

        @Nullable
        public Integer loadValue(@Nullable JsonNode node) {
            JsonNode jsonNode = node;
            return jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
        }

        public void saveValue(@NotNull ObjectNode node, @NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            node.put(key, value);
        }
    };
    @NotNull
    private static final Companion.FiledBasedIndexInfoValue.1 FiledBasedIndexInfoValue = new Companion.LoadSaveValue<FileBasedIndexVersionInfo>(){

        @Nullable
        public FileBasedIndexVersionInfo loadValue(@Nullable JsonNode node) {
            if (!(node instanceof ObjectNode)) {
                return null;
            }
            String string = SharedIndexMetadata.access$getTextValue$cp().loadValue(((ObjectNode)node).get("version"));
            if (string == null) {
                return null;
            }
            String version = string;
            Boolean bl = SharedIndexMetadata.access$getBooleanValue$cp().loadValue(((ObjectNode)node).get("needs_forward_index"));
            if (bl == null) {
                return null;
            }
            boolean needsForwardIndex = bl;
            return new FileBasedIndexVersionInfo(version, needsForwardIndex);
        }

        public void saveValue(@NotNull ObjectNode node, @NotNull String key, @NotNull FileBasedIndexVersionInfo value) {
            ObjectNode objectNode;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ObjectNode $this$saveValue_u24lambda_u240 = objectNode = node.putObject(key);
            boolean bl = false;
            Companion.TextValue.1 v0 = SharedIndexMetadata.access$getTextValue$cp();
            Intrinsics.checkNotNullExpressionValue((Object)$this$saveValue_u24lambda_u240, (String)"this");
            v0.saveValue($this$saveValue_u24lambda_u240, "version", value.getVersion());
            SharedIndexMetadata.access$getBooleanValue$cp().saveValue($this$saveValue_u24lambda_u240, "needs_forward_index", value.getNeedsForwardIndex());
        }
    };

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull SharedIndexGenerationStatistics generationStatistics, @NotNull ZonedDateTime generationTime, @NotNull SharedIndexIntellijMetadata intellij) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        Intrinsics.checkNotNullParameter((Object)generationStatistics, (String)"generationStatistics");
        Intrinsics.checkNotNullParameter((Object)generationTime, (String)"generationTime");
        Intrinsics.checkNotNullParameter((Object)intellij, (String)"intellij");
        this.indexName = indexName;
        this.indexKind = indexKind;
        this.indexInfrastructureVersion = indexInfrastructureVersion;
        this.sharedIndexInfo = sharedIndexInfo;
        this.generationStatistics = generationStatistics;
        this.generationTime = generationTime;
        this.intellij = intellij;
    }

    public /* synthetic */ SharedIndexMetadata(String string, String string2, SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion, SharedIndexMetadataInfo sharedIndexMetadataInfo, SharedIndexGenerationStatistics sharedIndexGenerationStatistics, ZonedDateTime zonedDateTime, SharedIndexIntellijMetadata sharedIndexIntellijMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sharedIndexMetadataInfo = new SharedIndexMetadataInfo(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 0x10) != 0) {
            sharedIndexGenerationStatistics = new SharedIndexGenerationStatistics(MapsKt.sortedMapOf((Pair[])new Pair[0]), MapsKt.sortedMapOf((Pair[])new Pair[0]));
        }
        if ((n & 0x20) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now().withNano(0);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now().withNano(0)");
            zonedDateTime = zonedDateTime2;
        }
        if ((n & 0x40) != 0) {
            sharedIndexIntellijMetadata = SharedIndexIntellijMetadata.Companion.current$intellij_indexing_shared();
        }
        this(string, string2, sharedIndexInfrastructureVersion, sharedIndexMetadataInfo, sharedIndexGenerationStatistics, zonedDateTime, sharedIndexIntellijMetadata);
    }

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    @NotNull
    public final String getIndexKind() {
        return this.indexKind;
    }

    @NotNull
    public final SharedIndexInfrastructureVersion getIndexInfrastructureVersion() {
        return this.indexInfrastructureVersion;
    }

    @NotNull
    public final SharedIndexMetadataInfo getSharedIndexInfo() {
        return this.sharedIndexInfo;
    }

    @NotNull
    public final SharedIndexGenerationStatistics getGenerationStatistics() {
        return this.generationStatistics;
    }

    @NotNull
    public final ZonedDateTime getGenerationTime() {
        return this.generationTime;
    }

    @NotNull
    public final SharedIndexIntellijMetadata getIntellij() {
        return this.intellij;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SharedIndexMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.indexName, (Object)((SharedIndexMetadata)other).indexName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.indexKind, (Object)((SharedIndexMetadata)other).indexKind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sharedIndexInfo, (Object)((SharedIndexMetadata)other).sharedIndexInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.indexInfrastructureVersion), (Object)((Object)((SharedIndexMetadata)other).indexInfrastructureVersion));
    }

    public int hashCode() {
        int result2 = this.indexName.hashCode();
        result2 = 31 * result2 + this.indexKind.hashCode();
        result2 = 31 * result2 + this.sharedIndexInfo.hashCode();
        result2 = 31 * result2 + this.indexInfrastructureVersion.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "SharedIndexMetadata(" + this.indexName + ", " + this.indexKind + "', " + this.indexInfrastructureVersion + ", " + this.sharedIndexInfo + ")";
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull SharedIndexGenerationStatistics generationStatistics, @NotNull ZonedDateTime generationTime) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        Intrinsics.checkNotNullParameter((Object)generationStatistics, (String)"generationStatistics");
        Intrinsics.checkNotNullParameter((Object)generationTime, (String)"generationTime");
        this(indexName, indexKind, indexInfrastructureVersion, sharedIndexInfo, generationStatistics, generationTime, null, 64, null);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo, @NotNull SharedIndexGenerationStatistics generationStatistics) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        Intrinsics.checkNotNullParameter((Object)generationStatistics, (String)"generationStatistics");
        this(indexName, indexKind, indexInfrastructureVersion, sharedIndexInfo, generationStatistics, null, null, 96, null);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion, @NotNull SharedIndexMetadataInfo sharedIndexInfo) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        Intrinsics.checkNotNullParameter((Object)sharedIndexInfo, (String)"sharedIndexInfo");
        this(indexName, indexKind, indexInfrastructureVersion, sharedIndexInfo, null, null, null, 112, null);
    }

    @JvmOverloads
    public SharedIndexMetadata(@NotNull String indexName, @NotNull String indexKind, @NotNull SharedIndexInfrastructureVersion indexInfrastructureVersion) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)indexKind, (String)"indexKind");
        Intrinsics.checkNotNullParameter((Object)((Object)indexInfrastructureVersion), (String)"indexInfrastructureVersion");
        this(indexName, indexKind, indexInfrastructureVersion, null, null, null, null, 120, null);
    }

    @JvmStatic
    @NotNull
    public static final String getMetadataPath() {
        return Companion.getMetadataPath();
    }

    @JvmStatic
    @NotNull
    public static final Path getMetadataPath(@NotNull Path chunkRootPath) {
        return Companion.getMetadataPath(chunkRootPath);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final byte[] toJsonBytes(@NotNull SharedIndexMetadata metadata, boolean reproducible) {
        return Companion.toJsonBytes(metadata, reproducible);
    }

    @JvmStatic
    @Nullable
    public static final SharedIndexMetadata readSharedIndexMetadata(@NotNull Path chunkRoot) throws IOException {
        return Companion.readSharedIndexMetadata(chunkRoot);
    }

    public static final /* synthetic */ Companion.BooleanValue.1 access$getBooleanValue$cp() {
        return BooleanValue;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007*\u0004\u0004\u0007\n\u0014\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001HB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0017H\u0007J\u001d\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001a0%H\u0082\bJ\u001e\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001e2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*J\u001a\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020 2\b\b\u0002\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u0004\u0018\u00010\u001e2\u0006\u00100\u001a\u00020\u001cJ\u0010\u00101\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020\u001cJ\u0012\u00101\u001a\u0004\u0018\u00010 2\b\u00102\u001a\u0004\u0018\u00010#J\u000e\u00103\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eJK\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H6\u0018\u000105\"\b\b\u0000\u00106*\u00020\u0001*\u00020\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H6082\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120:\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010;J3\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u000105*\u00020\u001c2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120:\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010<J3\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020>\u0018\u000105*\u00020\u001c2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120:\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010<J(\u0010?\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010@\u001a\u00020\u00122\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020>0BH\u0002J@\u0010C\u001a\u00020\u001a\"\b\b\u0000\u00106*\u00020\u0001*\u00020\u001c2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H6082\u0006\u0010@\u001a\u00020\u00122\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H60BH\u0002J(\u0010C\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010@\u001a\u00020\u00122\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120BH\u0003J\u001a\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u000105*\u00020\u001cH\u0002J2\u0010E\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H6\u0018\u000105\"\b\b\u0000\u00106*\u00020\u0001*\u00020\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H608H\u0002J\u001c\u0010F\u001a\u00020\u001a*\u00020 2\u0006\u0010G\u001a\u00020\u00172\b\b\u0002\u0010-\u001a\u00020.R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006I"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion;", "", "()V", "BooleanValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$BooleanValue$1;", "FiledBasedIndexInfoValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$FiledBasedIndexInfoValue$1;", "IntValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$IntValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$IntValue$1;", "METADATA_DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getMETADATA_DATE_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "METADATA_VERSION", "", "TextValue", "com/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$TextValue$1;", "getMetadataPath", "Ljava/nio/file/Path;", "chunkRootPath", "putIndexesVersion", "", "root", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "infrastructureVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "readSharedIndexMetadata", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata;", "chunkRoot", "renderJson", "", "builder", "Lkotlin/Function1;", "selectBestSuitableIndex", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "ideVersion", "candidates", "", "toJsonBytes", "metadata", "reproducible", "", "tryReadInfrastructureVersionOnly", "node", "tryReadSharedIndexMetadata", "metadataBytes", "writeVersionInfo", "mapFromPath", "Ljava/util/SortedMap;", "Y", "loadValue", "Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "path", "", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;[Ljava/lang/String;)Ljava/util/SortedMap;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;[Ljava/lang/String;)Ljava/util/SortedMap;", "mapIntFromPath", "", "putIntObjectFromMap", "name", "map", "", "putObjectFromMap", "saveValue", "toMap", "writeAsJson", "file", "LoadSaveValue", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexMetadata.kt\ncom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,401:1\n167#1,7:482\n175#1,5:500\n167#1,13:505\n1603#2,9:402\n1855#2:411\n1856#2:413\n1612#2:414\n1603#2,9:415\n1855#2:424\n1856#2:426\n1612#2:427\n1603#2,9:429\n1855#2:438\n1856#2:440\n1612#2:441\n1603#2,9:442\n1855#2:451\n1856#2:453\n1612#2:454\n1603#2,9:455\n1855#2:464\n1856#2:466\n1612#2:467\n1477#2:468\n1502#2,3:469\n1505#2,3:479\n1549#2:490\n1620#2,3:491\n1855#2,2:494\n1855#2,2:496\n1855#2,2:498\n1549#2:518\n1620#2,3:519\n1855#2,2:522\n1045#2:524\n1855#2,2:525\n1#3:412\n1#3:425\n1#3:428\n1#3:439\n1#3:452\n1#3:465\n1#3:489\n361#4,7:472\n37#5,2:527\n*S KotlinDebug\n*F\n+ 1 SharedIndexMetadata.kt\ncom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion\n*L\n200#1:482,7\n200#1:500,5\n293#1:505,13\n100#1:402,9\n100#1:411\n100#1:413\n100#1:414\n102#1:415,9\n102#1:424\n102#1:426\n102#1:427\n132#1:429,9\n132#1:438\n132#1:440\n132#1:441\n138#1:442,9\n138#1:451\n138#1:453\n138#1:454\n141#1:455,9\n141#1:464\n141#1:466\n141#1:467\n161#1:468\n161#1:469,3\n161#1:479,3\n223#1:490\n223#1:491,3\n223#1:494,2\n241#1:496,2\n247#1:498,2\n313#1:518\n313#1:519,3\n313#1:522,2\n332#1:524\n332#1:525,2\n100#1:412\n102#1:425\n132#1:439\n138#1:452\n141#1:465\n161#1:472,7\n345#1:527,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DateTimeFormatter getMETADATA_DATE_FORMAT() {
            return DateTimeFormatter.ISO_DATE_TIME.withLocale(Locale.US);
        }

        @JvmStatic
        @NotNull
        public final String getMetadataPath() {
            return "metadata.json";
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final SharedIndexInfrastructureVersion tryReadInfrastructureVersionOnly(@NotNull ObjectNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            var4_2 = node.get("indexes");
            v0 = var4_2 instanceof ObjectNode != false ? (ObjectNode)var4_2 : null;
            if (v0 == null) {
                return null;
            }
            indexesNode = v0;
            caps = new LinkedHashMap<K, V>();
            var5_5 = indexesNode.get("capabilities");
            v1 = var5_5 instanceof ObjectNode != false ? (String[])var5_5 : null;
            if (v1 != null) {
                capabilitiesNode = v1;
                $i$a$-let-SharedIndexMetadata$Companion$tryReadInfrastructureVersionOnly$1 = false;
                v2 = capabilitiesNode.fieldNames();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"capabilitiesNode.fieldNames()");
                var8_9 = v2;
                while (var8_9.hasNext()) {
                    capName = (String[])var8_9.next();
                    if (IndexInfrastructureCapability.find((String)capName) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)cap, (String)"IndexInfrastructureCapab\u2026find(capName) ?: continue");
                    var11_12 = capabilitiesNode.get((String)capName);
                    v3 /* !! */  = var11_12 instanceof ObjectNode != false ? (ObjectNode)var11_12 : null;
                    if (v3 /* !! */  == null || (v3 /* !! */  = SharedIndexMetadata.Companion.toMap(v3 /* !! */ )) == null) continue;
                    data /* !! */  = v3 /* !! */ ;
                    caps.put(cap, data /* !! */ );
                }
            }
            capabilitiesNode = new String[]{"base_versions"};
            v4 = this.mapFromPath(indexesNode, capabilitiesNode);
            if (v4 == null) {
                return null;
            }
            baseVersions = v4;
            $i$a$-let-SharedIndexMetadata$Companion$tryReadInfrastructureVersionOnly$1 = new String[]{"file_index_versions"};
            v5 = this.mapFromPath(indexesNode, SharedIndexMetadata.access$getFiledBasedIndexInfoValue$cp(), $i$a$-let-SharedIndexMetadata$Companion$tryReadInfrastructureVersionOnly$1);
            if (v5 == null) {
                return null;
            }
            fileIndexVersions = v5;
            var8_9 = new String[]{"stub_index_versions"};
            v6 = this.mapFromPath(indexesNode, var8_9);
            if (v6 == null) {
                return null;
            }
            stubIndexVersions = v6;
            capName = new String[]{"stub_file_element_type_versions"};
            v7 = this.mapFromPath(indexesNode, capName);
            if (v7 == null) {
                return null;
            }
            stubFileElementTypeVersions = v7;
            cap = new String[]{"composite_binary_stub_file_builder_versions"};
            v8 = this.mapFromPath(indexesNode, cap);
            if (v8 == null) {
                return null;
            }
            compositeBinaryStubFileBuilderVersions = v8;
            var11_12 = new String[]{"hash_provider_versions"};
            v9 = this.mapFromPath(indexesNode, var11_12);
            if (v9 == null) {
                return null;
            }
            hashProviderVersions = v9;
            var12_13 = indexesNode.get("os");
            v10 = var11_12 = var12_13 instanceof ArrayNode != false ? (String[])var12_13 : null;
            if (var11_12 == null) ** GOTO lbl-1000
            var13_14 = (Iterable)var11_12;
            $i$f$mapNotNull = false;
            var15_16 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var20_23 = $this$forEach$iv$iv$iv.iterator();
            while (var20_23.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var20_23.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                it = (JsonNode)element$iv$iv;
                $i$a$-mapNotNull-SharedIndexMetadata$Companion$tryReadInfrastructureVersionOnly$osNames$1 = false;
                if (it.asText() == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var13_14 = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            if (var13_14 == null) ** GOTO lbl-1000
            $this$mapNotNullTo$iv$iv = var13_14;
            $i$f$mapNotNull = false;
            $i$f$mapNotNullTo = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var22_26 = $this$forEach$iv$iv$iv.iterator();
            while (var22_26.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var22_26.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                p0 = (String)element$iv$iv;
                $i$a$-mapNotNull-SharedIndexMetadata$Companion$tryReadInfrastructureVersionOnly$osNames$2 = false;
                if (IndexInfrastructureOs.find(p0) == null) continue;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var15_16 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (var15_16 != null) {
                v11 = var15_16;
            } else lbl-1000:
            // 3 sources

            {
                v11 = SetsKt.emptySet();
            }
            osNames = v11;
            return new SharedIndexInfrastructureVersion(caps, osNames, (Map<String, String>)baseVersions, (Map<String, FileBasedIndexVersionInfo>)fileIndexVersions, (Map<String, String>)stubIndexVersions, (Map<String, String>)stubFileElementTypeVersions, (Map<String, String>)compositeBinaryStubFileBuilderVersions, (Map<String, String>)hashProviderVersions);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexMetadata tryReadSharedIndexMetadata(@NotNull ObjectNode node) {
            Object object;
            SharedIndexInfrastructureVersion indexVersions;
            SharedIndexGenerationStatistics generationStatistics;
            SharedIndexMetadataInfo metadataInfo;
            ZonedDateTime generated;
            String indexName;
            String indexKind;
            block36: {
                block35: {
                    Object object2;
                    Object $i$f$mapNotNull2;
                    JsonNode jsonNode;
                    String string6;
                    String[] stringArray;
                    String[] $this$mapNotNull$iv;
                    String[] stringArray2;
                    SharedIndexLineup lineup;
                    ObjectNode it;
                    JsonNode jsonNode22;
                    block34: {
                        block33: {
                            void $this$mapNotNullTo$iv$iv;
                            JsonNode jsonNode3;
                            Iterable<String> destination$iv$iv;
                            ObjectNode sources;
                            block32: {
                                Object object3;
                                block31: {
                                    void $this$mapNotNullTo$iv$iv2;
                                    Object it2;
                                    Object object4;
                                    block30: {
                                        block29: {
                                            void $this$mapNotNullTo$iv$iv3;
                                            SharedIndexLineup sharedIndexLineup;
                                            Object $this$tryReadSharedIndexMetadata_u24lambda_u242;
                                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                            JsonNode jsonNode4 = node.get("metadata_version");
                                            if (!Intrinsics.areEqual((Object)(jsonNode4 != null ? jsonNode4.asText() : null), (Object)SharedIndexMetadata.METADATA_VERSION)) {
                                                return null;
                                            }
                                            JsonNode jsonNode5 = node.get("sources");
                                            ObjectNode objectNode = jsonNode5 instanceof ObjectNode ? (ObjectNode)jsonNode5 : null;
                                            if (objectNode == null) {
                                                return null;
                                            }
                                            sources = objectNode;
                                            JsonNode jsonNode6 = sources.get("kind");
                                            String string2 = jsonNode6 != null ? jsonNode6.asText() : null;
                                            if (string2 == null) {
                                                return null;
                                            }
                                            indexKind = string2;
                                            JsonNode jsonNode7 = sources.get("name");
                                            String string3 = jsonNode7 != null ? jsonNode7.asText() : null;
                                            if (string3 == null) {
                                                return null;
                                            }
                                            indexName = string3;
                                            Object object5 = this;
                                            try {
                                                String string4;
                                                $this$tryReadSharedIndexMetadata_u24lambda_u242 = object5;
                                                boolean bl = false;
                                                JsonNode jsonNode8 = sources.get("generated");
                                                String string5 = string4 = jsonNode8 != null ? jsonNode8.asText() : null;
                                                if (string5 == null) {
                                                    return null;
                                                }
                                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"sources.get(\"generated\")?.asText() ?: return null");
                                                $this$tryReadSharedIndexMetadata_u24lambda_u242 = Result.constructor-impl((Object)ZonedDateTime.parse(string4, super.getMETADATA_DATE_FORMAT()));
                                            }
                                            catch (Throwable bl) {
                                                $this$tryReadSharedIndexMetadata_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                            }
                                            object5 = $this$tryReadSharedIndexMetadata_u24lambda_u242;
                                            Throwable throwable = Result.exceptionOrNull-impl((Object)object5);
                                            if (throwable != null) {
                                                Throwable it3 = throwable;
                                                boolean jsonNode22 = false;
                                                return null;
                                            }
                                            generated = (ZonedDateTime)object5;
                                            jsonNode22 = node.get("lineup");
                                            ObjectNode objectNode2 = jsonNode22 instanceof ObjectNode ? (ObjectNode)jsonNode22 : null;
                                            if (objectNode2 != null) {
                                                it = objectNode2;
                                                boolean string6 = false;
                                                sharedIndexLineup = SharedIndexLineup.Companion.tryReadLineup(it);
                                            } else {
                                                sharedIndexLineup = null;
                                            }
                                            lineup = sharedIndexLineup;
                                            Object object6 = sources.get("jdk_hash");
                                            jsonNode22 = object6 != null && (object6 = object6.asText()) != null ? StringKt.nullize$default((String)object6, (boolean)false, (int)1, null) : null;
                                            stringArray2 = sources.get("jdk_aliases");
                                            object4 = stringArray2 instanceof ArrayNode ? (ArrayNode)stringArray2 : null;
                                            if (object4 == null) break block29;
                                            $this$mapNotNull$iv = (String[])object4;
                                            boolean $i$f$mapNotNull2 = false;
                                            stringArray = $this$mapNotNull$iv;
                                            Collection destination$iv$iv2 = new ArrayList();
                                            boolean $i$f$mapNotNullTo = false;
                                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv3;
                                            boolean $i$f$forEach = false;
                                            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                                            while (iterator.hasNext()) {
                                                String it$iv$iv;
                                                Object element$iv$iv$iv;
                                                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                                boolean bl = false;
                                                it2 = (JsonNode)element$iv$iv;
                                                boolean bl2 = false;
                                                Object object7 = it2;
                                                if ((object7 != null && (object7 = object7.asText()) != null ? StringKt.nullize$default((String)object7, (boolean)false, (int)1, null) : null) == null) continue;
                                                it$iv$iv = it$iv$iv;
                                                boolean bl3 = false;
                                                destination$iv$iv2.add(it$iv$iv);
                                            }
                                            object4 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                                            if (object4 != null) break block30;
                                        }
                                        object4 = CollectionsKt.emptyList();
                                    }
                                    it = object4;
                                    Object object8 = sources.get("project_id");
                                    string6 = object8 != null && (object8 = object8.asText()) != null ? StringKt.nullize$default((String)object8, (boolean)false, (int)1, null) : null;
                                    Object object9 = sources.get("project_vcs_commit_id");
                                    stringArray2 = object9 != null && (object9 = object9.asText()) != null ? StringKt.nullize$default((String)object9, (boolean)false, (int)1, null) : null;
                                    Object object10 = sources.get("maven_package");
                                    $this$mapNotNull$iv = object10 != null && (object10 = object10.asText()) != null ? StringKt.nullize$default((String)object10, (boolean)false, (int)1, null) : null;
                                    jsonNode = sources.get("maven_included_packages");
                                    object3 = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
                                    if (object3 == null) break block31;
                                    Iterable $this$mapNotNull$iv2 = (Iterable)object3;
                                    boolean $i$f$mapNotNull3 = false;
                                    Iterable $i$f$forEach = $this$mapNotNull$iv2;
                                    destination$iv$iv = new ArrayList();
                                    boolean $i$f$mapNotNullTo = false;
                                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                                    boolean $i$f$forEach2 = false;
                                    it2 = $this$forEach$iv$iv$iv.iterator();
                                    while (it2.hasNext()) {
                                        String it$iv$iv;
                                        Object element$iv$iv$iv;
                                        Object element$iv$iv = element$iv$iv$iv = it2.next();
                                        boolean bl = false;
                                        JsonNode it4 = (JsonNode)element$iv$iv;
                                        boolean bl4 = false;
                                        Object object11 = it4;
                                        if ((object11 != null && (object11 = object11.asText()) != null ? StringKt.nullize$default((String)object11, (boolean)false, (int)1, null) : null) == null) continue;
                                        it$iv$iv = it$iv$iv;
                                        boolean bl5 = false;
                                        destination$iv$iv.add(it$iv$iv);
                                    }
                                    object3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                    if (object3 != null) break block32;
                                }
                                object3 = $i$f$mapNotNull2 = SetsKt.emptySet();
                            }
                            if ((object2 = (jsonNode3 = sources.get("generic_jar_names")) instanceof ArrayNode ? (ArrayNode)jsonNode3 : null) == null) break block33;
                            Iterable $this$mapNotNull$iv3 = (Iterable)object2;
                            boolean $i$f$mapNotNull4 = false;
                            destination$iv$iv = $this$mapNotNull$iv3;
                            Collection destination$iv$iv3 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                String it$iv$iv;
                                Object element$iv$iv$iv;
                                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl = false;
                                JsonNode it5 = (JsonNode)element$iv$iv;
                                boolean bl6 = false;
                                Object object12 = it5;
                                if ((object12 != null && (object12 = object12.asText()) != null ? StringKt.nullize$default((String)object12, (boolean)false, (int)1, null) : null) == null) continue;
                                it$iv$iv = it$iv$iv;
                                boolean bl7 = false;
                                destination$iv$iv3.add(it$iv$iv);
                            }
                            object2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
                            if (object2 != null) break block34;
                        }
                        object2 = SetsKt.emptySet();
                    }
                    stringArray = object2;
                    metadataInfo = new SharedIndexMetadataInfo((List<String>)it, (String)jsonNode22, string6, (String)stringArray2, (String)$this$mapNotNull$iv, (Set<String>)$i$f$mapNotNull2, (Set<String>)stringArray, lineup);
                    string6 = node.get("generation_statistics");
                    ObjectNode objectNode = string6 instanceof ObjectNode ? (ObjectNode)string6 : null;
                    if (objectNode == null) {
                        return null;
                    }
                    ObjectNode nodeGenerationStatistics = objectNode;
                    stringArray2 = new String[]{"file_index_usages"};
                    SortedMap<String, Integer> sortedMap = this.mapIntFromPath(nodeGenerationStatistics, stringArray2);
                    if (sortedMap == null) {
                        return null;
                    }
                    SortedMap<String, Integer> fileBasedIndexUsages = sortedMap;
                    $this$mapNotNull$iv = new String[]{"stub_file_element_type_usages"};
                    SortedMap<String, Integer> sortedMap2 = this.mapIntFromPath(nodeGenerationStatistics, $this$mapNotNull$iv);
                    if (sortedMap2 == null) {
                        return null;
                    }
                    SortedMap<String, Integer> stubFileElementTypeUsages = sortedMap2;
                    generationStatistics = new SharedIndexGenerationStatistics(fileBasedIndexUsages, stubFileElementTypeUsages);
                    SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = this.tryReadInfrastructureVersionOnly(node);
                    if (sharedIndexInfrastructureVersion == null) {
                        return null;
                    }
                    indexVersions = sharedIndexInfrastructureVersion;
                    jsonNode = node.get("intellij");
                    object = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
                    if (object == null) break block35;
                    ObjectNode it6 = object;
                    boolean bl = false;
                    SharedIndexIntellijMetadata sharedIndexIntellijMetadata = SharedIndexIntellijMetadata.Companion.readIntellijMetadata$intellij_indexing_shared(it6);
                    object = sharedIndexIntellijMetadata;
                    if (sharedIndexIntellijMetadata != null) break block36;
                }
                return null;
            }
            Object intellij = object;
            Intrinsics.checkNotNullExpressionValue((Object)generated, (String)"generated");
            return new SharedIndexMetadata(indexName, indexKind, indexVersions, metadataInfo, generationStatistics, generated, (SharedIndexIntellijMetadata)intellij);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final SharedIndexLookupResult selectBestSuitableIndex(@NotNull SharedIndexInfrastructureVersion ideVersion, @NotNull List<SharedIndexLookupResult> candidates) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)ideVersion), (String)"ideVersion");
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            Iterable $this$groupBy$iv = candidates;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                SharedIndexLookupResult it = (SharedIndexLookupResult)element$iv$iv;
                boolean bl = false;
                SharedIndexMetadata key$iv$iv = it.getSharedIndexMetadata();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map nodes = destination$iv$iv;
            SharedIndexMetadata sharedIndexMetadata = ideVersion.pickBestSuitableMetadata(nodes.keySet());
            if (sharedIndexMetadata == null) {
                return null;
            }
            SharedIndexMetadata best = sharedIndexMetadata;
            List list = (List)nodes.get(best);
            return list != null ? (SharedIndexLookupResult)CollectionsKt.firstOrNull((List)list) : null;
        }

        private final byte[] renderJson(Function1<? super ObjectNode, Unit> builder) {
            boolean $i$f$renderJson = false;
            try {
                ObjectMapper om = new ObjectMapper();
                ObjectNode root = om.createObjectNode();
                root.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                builder.invoke((Object)root);
                byte[] byArray = om.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
                return byArray;
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to generate shared index metadata JSON. " + t.getMessage(), t);
            }
        }

        @JvmStatic
        @NotNull
        public final Path getMetadataPath(@NotNull Path chunkRootPath) {
            Intrinsics.checkNotNullParameter((Object)chunkRootPath, (String)"chunkRootPath");
            Path path = chunkRootPath.resolve(this.getMetadataPath());
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"chunkRootPath.resolve(getMetadataPath())");
            return path;
        }

        public final void writeAsJson(@NotNull SharedIndexMetadata $this$writeAsJson, @NotNull Path file, boolean reproducible) {
            Intrinsics.checkNotNullParameter((Object)$this$writeAsJson, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            byte[] bytes = this.toJsonBytes($this$writeAsJson, reproducible);
            Files.write(file, bytes, new OpenOption[0]);
        }

        public static /* synthetic */ void writeAsJson$default(Companion companion, SharedIndexMetadata sharedIndexMetadata, Path path, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.writeAsJson(sharedIndexMetadata, path, bl);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final byte[] toJsonBytes(@NotNull SharedIndexMetadata metadata, boolean reproducible) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                void it;
                ArrayNode it2;
                Collection collection;
                ObjectNode objectNode;
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                Intrinsics.checkNotNullExpressionValue((Object)root$iv, (String)"root");
                ObjectNode root = root$iv;
                boolean bl = false;
                SharedIndexMetadataInfo addon = metadata.getSharedIndexInfo();
                ObjectNode sources = objectNode = root.putObject("sources");
                boolean bl2 = false;
                sources.put("generated", Companion.getMETADATA_DATE_FORMAT().format(reproducible ? Instant.ofEpochMilli(0L).atZone(ZoneId.of("UTC")) : metadata.getGenerationTime()));
                sources.put("os", IndexInfrastructureOs.getOs().getOsName());
                sources.put("os_name", SystemInfo.getOsNameAndVersion());
                sources.put("kind", metadata.getIndexKind());
                sources.put("name", metadata.getIndexName());
                String string = addon.getJdkHash();
                if (string != null) {
                    String it3 = string;
                    boolean bl3 = false;
                    sources.put("jdk_hash", it3);
                }
                Collection collection2 = addon.getJdkAliases();
                if (collection2.isEmpty()) {
                    boolean bl4 = false;
                    collection = null;
                } else {
                    collection = collection2;
                }
                List list = (List)collection;
                if (list != null) {
                    Iterator $this$mapTo$iv$iv;
                    List aliases = list;
                    boolean bl5 = false;
                    ArrayNode aliasesNode = sources.putArray("jdk_aliases");
                    boolean bl6 = false;
                    Iterable $this$map$iv = aliases;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it4;
                        Object item$iv$iv = iterator.next();
                        String string2 = (String)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl7 = false;
                        String string3 = it4.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        collection3.add(((Object)StringsKt.trim((CharSequence)string3)).toString());
                    }
                    Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it5 = (String)element$iv;
                        boolean bl8 = false;
                        aliasesNode.add(it5);
                    }
                }
                String string4 = addon.getProjectId();
                if (string4 != null) {
                    String it6 = string4;
                    boolean bl9 = false;
                    sources.put("project_id", it6);
                }
                String string5 = addon.getProjectVcsCommitId();
                if (string5 != null) {
                    String it7 = string5;
                    boolean bl10 = false;
                    sources.put("project_vcs_commit_id", it7);
                }
                String string6 = addon.getMavenPackage();
                if (string6 != null) {
                    String it8 = string6;
                    boolean bl11 = false;
                    sources.put("maven_package", it8);
                }
                if (!((Collection)addon.getMavenIncludedPackages()).isEmpty()) {
                    it2 = sources.putArray("maven_included_packages");
                    boolean bl12 = false;
                    Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)addon.getMavenIncludedPackages());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String pkg = (String)element$iv;
                        boolean bl13 = false;
                        it2.add(pkg);
                    }
                }
                if (!((Collection)addon.getGenericJarNames()).isEmpty()) {
                    it2 = sources.putArray("generic_jar_names");
                    boolean bl14 = false;
                    Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)addon.getGenericJarNames());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String name = (String)element$iv;
                        boolean bl15 = false;
                        it2.add(name);
                    }
                }
                Object statisticsNode = objectNode = root.putObject("generation_statistics");
                boolean bl16 = false;
                Intrinsics.checkNotNullExpressionValue((Object)statisticsNode, (String)"statisticsNode");
                Companion.putIntObjectFromMap((ObjectNode)statisticsNode, "file_index_usages", (Map<String, Integer>)metadata.getGenerationStatistics().getFileBasedIndexUsages());
                Companion.putIntObjectFromMap((ObjectNode)statisticsNode, "stub_file_element_type_usages", (Map<String, Integer>)metadata.getGenerationStatistics().getStubFileElementTypeUsages());
                SharedIndexLineup sharedIndexLineup = addon.getLineup();
                if (sharedIndexLineup != null) {
                    statisticsNode = sharedIndexLineup;
                    ObjectNode it9 = statisticsNode;
                    boolean bl17 = false;
                    root.putObject("lineup").put("name", it9.getName()).put("indexed_file_count", it9.getIndexedFileCount()).put("creation_stamp", reproducible ? 0L : it9.getCreationStamp());
                }
                statisticsNode = SharedIndexIntellijMetadata.Companion.current$intellij_indexing_shared();
                SharedIndexIntellijMetadata.Companion companion = SharedIndexIntellijMetadata.Companion;
                boolean bl18 = false;
                Object object = Intrinsics.areEqual((Object)metadata.getIndexKind(), (Object)"project-turbocharged") ? it : SharedIndexIntellijMetadata.copy$default((SharedIndexIntellijMetadata)it, null, null, null, MapsKt.sortedMapOf((Pair[])new Pair[0]), null, 23, null);
                ObjectNode objectNode2 = root.putObject("intellij");
                Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"root.putObject(\"intellij\")");
                companion.putIntellijMetadata$intellij_indexing_shared((SharedIndexIntellijMetadata)object, objectNode2);
                Companion.putIndexesVersion(root, metadata.getIndexInfrastructureVersion());
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        public static /* synthetic */ byte[] toJsonBytes$default(Companion companion, SharedIndexMetadata sharedIndexMetadata, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.toJsonBytes(sharedIndexMetadata, bl);
        }

        @JvmStatic
        @Nullable
        public final SharedIndexMetadata readSharedIndexMetadata(@NotNull Path chunkRoot) throws IOException {
            Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
            Path metadataPath = this.getMetadataPath(chunkRoot);
            byte[] metadataBytes = Files.readAllBytes(metadataPath);
            return this.tryReadSharedIndexMetadata(metadataBytes);
        }

        @Nullable
        public final SharedIndexMetadata tryReadSharedIndexMetadata(@Nullable byte[] metadataBytes) {
            if (metadataBytes == null) {
                return null;
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode jsonNode = om.readTree(metadataBytes);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                return null;
            }
            ObjectNode root = objectNode;
            return this.tryReadSharedIndexMetadata(root);
        }

        @NotNull
        public final byte[] writeVersionInfo(@NotNull SharedIndexInfrastructureVersion infrastructureVersion) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)((Object)infrastructureVersion), (String)"infrastructureVersion");
            Companion this_$iv = this;
            boolean $i$f$renderJson = false;
            try {
                ObjectMapper om$iv = new ObjectMapper();
                ObjectNode root$iv = om$iv.createObjectNode();
                root$iv.put("metadata_version", SharedIndexMetadata.METADATA_VERSION);
                Intrinsics.checkNotNullExpressionValue((Object)root$iv, (String)"root");
                ObjectNode root = root$iv;
                boolean bl = false;
                Companion.putIndexesVersion(root, infrastructureVersion);
                byte[] byArray2 = om$iv.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root$iv);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"om.writerWithDefaultPret\u2026).writeValueAsBytes(root)");
            }
            catch (Throwable t$iv) {
                throw new RuntimeException("Failed to generate shared index metadata JSON. " + t$iv.getMessage(), t$iv);
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        private final void putIndexesVersion(ObjectNode root, SharedIndexInfrastructureVersion infrastructureVersion) {
            void $this$mapTo$iv$iv;
            Object cap;
            ObjectNode objectNode;
            ObjectNode indexes2 = objectNode = root.putObject("indexes");
            boolean bl = false;
            indexes2.put("weak_hash", infrastructureVersion.getWeakVersionHash());
            Map<IndexInfrastructureCapability, Map<String, String>> map = infrastructureVersion.getCapabilities();
            Intrinsics.checkNotNullExpressionValue(map, (String)"infrastructureVersion.capabilities");
            if (!map.isEmpty()) {
                ObjectNode objectNode2;
                ObjectNode caps = objectNode2 = indexes2.putObject("capabilities");
                boolean bl2 = false;
                Map<IndexInfrastructureCapability, Map<String, String>> map2 = infrastructureVersion.getCapabilities();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"infrastructureVersion.capabilities");
                for (Map.Entry<IndexInfrastructureCapability, Map<String, String>> entry : map2.entrySet()) {
                    cap = entry.getKey();
                    Map<String, String> versions = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)caps, (String)"caps");
                    String string = ((IndexInfrastructureCapability)cap).getCapabilityName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cap.capabilityName");
                    Intrinsics.checkNotNullExpressionValue(versions, (String)"versions");
                    Companion.putObjectFromMap(caps, string, versions);
                }
            }
            ArrayNode os = indexes2.putArray("os");
            boolean bl3 = false;
            Set<IndexInfrastructureOs> set = infrastructureVersion.getSupportedOs();
            Intrinsics.checkNotNullExpressionValue(set, (String)"infrastructureVersion.supportedOs");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            cap = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IndexInfrastructureOs indexInfrastructureOs = (IndexInfrastructureOs)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getOsName());
            }
            Iterable $this$forEach$iv = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                os.add(it);
            }
            Intrinsics.checkNotNullExpressionValue((Object)indexes2, (String)"indexes");
            Map<String, String> map3 = infrastructureVersion.getBaseIndexes();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"infrastructureVersion.baseIndexes");
            Companion.putObjectFromMap(indexes2, "base_versions", map3);
            LoadSaveValue loadSaveValue = FiledBasedIndexInfoValue;
            Map<String, FileBasedIndexVersionInfo> map4 = infrastructureVersion.getFileBasedIndexVersionInfos();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"infrastructureVersion.fileBasedIndexVersionInfos");
            Companion.putObjectFromMap(indexes2, loadSaveValue, "file_index_versions", map4);
            Map<String, String> map5 = infrastructureVersion.getStubIndexVersions();
            Intrinsics.checkNotNullExpressionValue(map5, (String)"infrastructureVersion.stubIndexVersions");
            Companion.putObjectFromMap(indexes2, "stub_index_versions", map5);
            Map<String, String> map6 = infrastructureVersion.getStubFileElementTypeVersions();
            Intrinsics.checkNotNullExpressionValue(map6, (String)"infrastructureVersion.stubFileElementTypeVersions");
            Companion.putObjectFromMap(indexes2, "stub_file_element_type_versions", map6);
            SortedMap<String, String> sortedMap = infrastructureVersion.getCompositeBinaryStubFileBuilderVersions();
            Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"infrastructureVersion.co\u2026ryStubFileBuilderVersions");
            Companion.putObjectFromMap(indexes2, "composite_binary_stub_file_builder_versions", (Map<String, String>)sortedMap);
            Map<String, String> map7 = infrastructureVersion.getHashProviderVersions();
            Intrinsics.checkNotNullExpressionValue(map7, (String)"infrastructureVersion.hashProviderVersions");
            Companion.putObjectFromMap(indexes2, "hash_provider_versions", map7);
        }

        @JvmName(name="putObjectFromMap")
        private final void putObjectFromMap(ObjectNode $this$putObjectFromMap, String name, Map<String, String> map) {
            this.putObjectFromMap($this$putObjectFromMap, TextValue, name, map);
        }

        private final void putIntObjectFromMap(ObjectNode $this$putIntObjectFromMap, String name, Map<String, Integer> map) {
            this.putObjectFromMap($this$putIntObjectFromMap, IntValue, name, map);
        }

        /*
         * WARNING - void declaration
         */
        private final <Y> void putObjectFromMap(ObjectNode $this$putObjectFromMap, LoadSaveValue<Y> saveValue, String name, Map<String, ? extends Y> map) {
            void $this$forEach$iv;
            ObjectNode objectNode;
            ObjectNode obj = objectNode = $this$putObjectFromMap.putObject(name);
            boolean bl = false;
            Iterable $this$sortedBy$iv = map.entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    it = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)string);
                    bl = false;
                    String string2 = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)obj, (String)"obj");
                saveValue.saveValue(obj, k, v);
            }
        }

        private final SortedMap<String, String> mapFromPath(ObjectNode $this$mapFromPath, String ... path) {
            return this.mapFromPath($this$mapFromPath, TextValue, Arrays.copyOf(path, path.length));
        }

        private final SortedMap<String, Integer> mapIntFromPath(ObjectNode $this$mapIntFromPath, String ... path) {
            return this.mapFromPath($this$mapIntFromPath, IntValue, Arrays.copyOf(path, path.length));
        }

        private final SortedMap<String, String> toMap(ObjectNode $this$toMap) {
            return this.toMap($this$toMap, TextValue);
        }

        private final <Y> SortedMap<String, Y> mapFromPath(ObjectNode $this$mapFromPath, LoadSaveValue<Y> loadValue, String ... path) {
            if (path.length == 0) {
                return this.toMap($this$mapFromPath, loadValue);
            }
            String first = (String)ArraysKt.first((Object[])path);
            JsonNode jsonNode = $this$mapFromPath.get(first);
            ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
            if (objectNode == null) {
                return null;
            }
            ObjectNode child = objectNode;
            Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])path, (int)1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            return this.mapFromPath(child, loadValue, Arrays.copyOf(stringArray, stringArray.length));
        }

        private final <Y> SortedMap<String, Y> toMap(ObjectNode $this$toMap, LoadSaveValue<Y> loadValue) {
            HashMap result2 = new HashMap();
            Iterator iterator = $this$toMap.fieldNames();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"this.fieldNames()");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Y value;
                String key = (String)iterator2.next();
                if (loadValue.loadValue($this$toMap.get(key)) == null) {
                    return null;
                }
                Map map = result2;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                map.put(key, value);
            }
            return (SortedMap)ImmutableSortedMap.copyOf((Map)result2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bb\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00018\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/indexing/shared/metadata/SharedIndexMetadata$Companion$LoadSaveValue;", "Y", "", "loadValue", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "saveValue", "", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "key", "", "value", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/String;Ljava/lang/Object;)V", "intellij.indexing.shared"})
        private static interface LoadSaveValue<Y> {
            @Nullable
            public Y loadValue(@Nullable JsonNode var1);

            public void saveValue(@NotNull ObjectNode var1, @NotNull String var2, @NotNull Y var3);
        }
    }
}

