/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionEventsCollector;
import org.jetbrains.qodana.staticAnalysis.stat.InspectionFingerprintAggregatorService;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J,\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "filetypes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$CountsInfo;", "getProject", "()Lcom/intellij/openapi/project/Project;", "iterateFilesAndAct", "", "action", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "logFingerprint", "registerAnalyzedFile", "file", "registerExistingFile", "registerFile", "defaultInfo", "incrementer", "Companion", "CountsInfo", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nInspectionFingerprintAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n766#2:65\n857#2,2:66\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService\n*L\n60#1:65\n60#1:66,2\n60#1:68,2\n*E\n"})
public final class InspectionFingerprintAggregatorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, CountsInfo> filetypes;

    public InspectionFingerprintAggregatorService(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.filetypes = new ConcurrentHashMap();
        this.iterateFilesAndAct((Function1<? super PsiFile, Unit>)((Function1)new Function1<PsiFile, Unit>(){

            public final void invoke(@NotNull PsiFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.registerExistingFile(it);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void iterateFilesAndAct(Function1<? super PsiFile, Unit> action) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        PsiManager psiManager2 = psiManager;
        ApplicationManager.getApplication().runReadAction(new Runnable(this, psiManager2, action){
            final /* synthetic */ InspectionFingerprintAggregatorService this$0;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ Function1<PsiFile, Unit> $action;
            {
                this.this$0 = $receiver;
                this.$psiManager = $psiManager;
                this.$action = $action;
            }

            public final void run() {
                ProjectFileIndex.getInstance((Project)this.this$0.getProject()).iterateContent(new ContentIterator(this.$psiManager, this.$action){
                    final /* synthetic */ PsiManager $psiManager;
                    final /* synthetic */ Function1<PsiFile, Unit> $action;
                    {
                        this.$psiManager = $psiManager;
                        this.$action = $action;
                    }

                    public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            PsiFile psiFile2 = this.$psiManager.findFile(fileOrDir);
                            if (psiFile2 == null) break block0;
                            PsiFile psiFile3 = psiFile2;
                            Function1<PsiFile, Unit> function1 = this.$action;
                            PsiFile it = psiFile3;
                            boolean bl = false;
                            function1.invoke((Object)it);
                        }
                        return true;
                    }
                });
            }
        });
    }

    private final void registerFile(PsiFile file, CountsInfo defaultInfo, Function1<? super CountsInfo, Unit> incrementer) {
        if (file.getLanguage().getAssociatedFileType() == null) {
            return;
        }
        LanguageFileType languageFileType = file.getLanguage().getAssociatedFileType();
        Intrinsics.checkNotNull((Object)languageFileType);
        String string = languageFileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.language.associatedFileType!!.name");
        String filetype = string;
        this.filetypes.compute(filetype, new BiFunction(defaultInfo, incrementer){
            final /* synthetic */ CountsInfo $defaultInfo;
            final /* synthetic */ Function1<CountsInfo, Unit> $incrementer;
            {
                this.$defaultInfo = $defaultInfo;
                this.$incrementer = $incrementer;
            }

            @Nullable
            public final CountsInfo apply(@NotNull String string, @Nullable CountsInfo v) {
                CountsInfo countsInfo;
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                if (v == null) {
                    countsInfo = this.$defaultInfo;
                } else {
                    this.$incrementer.invoke((Object)v);
                    countsInfo = v;
                }
                return countsInfo;
            }
        });
    }

    private final void registerExistingFile(PsiFile file) {
        this.registerFile(file, new CountsInfo(1, 0), (Function1<? super CountsInfo, Unit>)((Function1)registerExistingFile.1.INSTANCE));
    }

    public final void registerAnalyzedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.registerFile(file, new CountsInfo(1, 1), (Function1<? super CountsInfo, Unit>)((Function1)registerAnalyzedFile.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public final void logFingerprint() {
        void $this$filterTo$iv$iv;
        Set<Map.Entry<String, CountsInfo>> set = this.filetypes.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"filetypes.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            boolean bl2 = ((CharSequence)k).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            String key = (String)entry.getKey();
            CountsInfo value = (CountsInfo)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            InspectionEventsCollector.Companion.logInspectionFingerprint(key, value.getTotalCount(), value.getAnalyzedCount(), this.project);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nInspectionFingerprintAggregatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n29#2,3:65\n*S KotlinDebug\n*F\n+ 1 InspectionFingerprintAggregatorService.kt\norg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$Companion\n*L\n15#1:65,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InspectionFingerprintAggregatorService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InspectionFingerprintAggregatorService> serviceClass$iv = InspectionFingerprintAggregatorService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (InspectionFingerprintAggregatorService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/InspectionFingerprintAggregatorService$CountsInfo;", "", "totalCount", "", "analyzedCount", "(II)V", "getAnalyzedCount", "()I", "setAnalyzedCount", "(I)V", "getTotalCount", "setTotalCount", "intellij.qodana"})
    private static final class CountsInfo {
        private int totalCount;
        private int analyzedCount;

        public CountsInfo(int totalCount, int analyzedCount) {
            this.totalCount = totalCount;
            this.analyzedCount = analyzedCount;
        }

        public final int getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(int n) {
            this.totalCount = n;
        }

        public final int getAnalyzedCount() {
            return this.analyzedCount;
        }

        public final void setAnalyzedCount(int n) {
            this.analyzedCount = n;
        }
    }
}

