/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.xml.XmlNamedReferenceHost;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlNamedReferenceProviderBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Internal
final class NamedReferenceProviders {
    private static final ExtensionPointName<XmlNamedReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.xml.namedReferenceProvider");
    private final Map<Class<?>, ByHostClass> myByHostClass = new ConcurrentHashMap(2);
    private final Map<Class<?>, Collection<PsiSymbolReferenceProvider>> myByTargetClass = new ConcurrentHashMap();

    @NotNull
    static NamedReferenceProviders getInstance() {
        NamedReferenceProviders namedReferenceProviders = (NamedReferenceProviders)ApplicationManager.getApplication().getService(NamedReferenceProviders.class);
        if (namedReferenceProviders == null) {
            NamedReferenceProviders.$$$reportNull$$$0(0);
        }
        return namedReferenceProviders;
    }

    public NamedReferenceProviders() {
        EP_NAME.addChangeListener(() -> this.myByHostClass.clear(), null);
        EP_NAME.addChangeListener(() -> this.myByTargetClass.clear(), null);
    }

    @NotNull
    Collection<XmlNamedReferenceProviderBean> getNamedReferenceProviderBeans(@NotNull XmlNamedReferenceHost element) {
        String hostName;
        if (element == null) {
            NamedReferenceProviders.$$$reportNull$$$0(1);
        }
        if ((hostName = element.getHostName()) == null) {
            List<XmlNamedReferenceProviderBean> list = Collections.emptyList();
            if (list == null) {
                NamedReferenceProviders.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection<XmlNamedReferenceProviderBean> collection = this.byHostClass(element).byHostName(hostName);
        if (collection == null) {
            NamedReferenceProviders.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    private ByHostClass byHostClass(@NotNull XmlNamedReferenceHost element) {
        if (element == null) {
            NamedReferenceProviders.$$$reportNull$$$0(4);
        }
        ByHostClass byHostClass = this.myByHostClass.computeIfAbsent(element.getClass(), NamedReferenceProviders::byHostClassInner);
        if (byHostClass == null) {
            NamedReferenceProviders.$$$reportNull$$$0(5);
        }
        return byHostClass;
    }

    @NotNull
    private static ByHostClass byHostClassInner(@NotNull Class<?> hostClass) {
        if (hostClass == null) {
            NamedReferenceProviders.$$$reportNull$$$0(6);
        }
        SmartList result2 = new SmartList();
        for (XmlNamedReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!bean.getHostElementClass().isAssignableFrom(hostClass)) continue;
            result2.add(bean);
        }
        return new ByHostClass((List<XmlNamedReferenceProviderBean>)result2);
    }

    @NotNull
    @NotNull Collection<@NotNull PsiSymbolReferenceProvider> getNamedReferenceProviders(@NotNull Symbol target) {
        if (target == null) {
            NamedReferenceProviders.$$$reportNull$$$0(7);
        }
        Collection collection = this.myByTargetClass.computeIfAbsent(target.getClass(), NamedReferenceProviders::byTargetClassInner);
        if (collection == null) {
            NamedReferenceProviders.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    private static Collection<PsiSymbolReferenceProvider> byTargetClassInner(@NotNull Class<?> targetClass) {
        if (targetClass == null) {
            NamedReferenceProviders.$$$reportNull$$$0(9);
        }
        SmartList result2 = new SmartList();
        for (XmlNamedReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!targetClass.isAssignableFrom(bean.getResolveTargetClass())) continue;
            result2.add((PsiSymbolReferenceProvider)bean.getInstance());
        }
        SmartList smartList = result2;
        if (smartList == null) {
            NamedReferenceProviders.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/impl/NamedReferenceProviders";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/impl/NamedReferenceProviders";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedReferenceProviderBeans";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byHostClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedReferenceProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "byTargetClassInner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNamedReferenceProviderBeans";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byHostClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byHostClassInner";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNamedReferenceProviders";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "byTargetClassInner";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 4, 6, 7, 9 -> new IllegalArgumentException(string2);
        };
    }

    private static final class ByHostClass {
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseSensitiveMap;
        private final Map<String, List<XmlNamedReferenceProviderBean>> myCaseInsensitiveMap;

        ByHostClass(@NotNull List<XmlNamedReferenceProviderBean> beans) {
            if (beans == null) {
                ByHostClass.$$$reportNull$$$0(0);
            }
            HashMap<String, List<XmlNamedReferenceProviderBean>> caseSensitiveMap = new HashMap<String, List<XmlNamedReferenceProviderBean>>();
            Map caseInsensitiveMap = CollectionFactory.createCaseInsensitiveStringMap();
            for (XmlNamedReferenceProviderBean bean : beans) {
                Map<String, List<XmlNamedReferenceProviderBean>> map2 = bean.caseSensitive ? caseSensitiveMap : caseInsensitiveMap;
                for (String hostName : bean.getHostNames()) {
                    map2.computeIfAbsent(hostName, __ -> new SmartList()).add(bean);
                }
            }
            CollectionFactory.trimMap((Map)caseInsensitiveMap);
            this.myCaseSensitiveMap = caseSensitiveMap;
            this.myCaseInsensitiveMap = caseInsensitiveMap;
        }

        @NotNull
        Collection<XmlNamedReferenceProviderBean> byHostName(@NotNull String hostName) {
            if (hostName == null) {
                ByHostClass.$$$reportNull$$$0(1);
            }
            List list = ContainerUtil.concat((List)((List)ObjectUtils.notNull(this.myCaseSensitiveMap.get(hostName), Collections.emptyList())), (List)((List)ObjectUtils.notNull(this.myCaseInsensitiveMap.get(hostName), Collections.emptyList())));
            if (list == null) {
                ByHostClass.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beans";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/impl/NamedReferenceProviders$ByHostClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/impl/NamedReferenceProviders$ByHostClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byHostName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byHostName";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

