/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"attributeKeyMapping", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributeKeyMapping", "()Ljava/util/Map;", "isCustomTag", "", "file", "Lcom/intellij/psi/PsiFile;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "isHtmlLikeFile", "isHtmlTagName", "descriptor", "Lcom/intellij/xml/XmlElementDescriptor;", "intellij.xml.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nXmlCustomTagHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPassKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1747#2,3:140\n*S KotlinDebug\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPassKt\n*L\n124#1:140,3\n*E\n"})
public final class XmlCustomTagHighlightingPassKt {
    @NotNull
    private static final Map<TextAttributesKey, TextAttributesKey> attributeKeyMapping;

    @NotNull
    public static final Map<TextAttributesKey, TextAttributesKey> getAttributeKeyMapping() {
        return attributeKeyMapping;
    }

    public static final boolean isCustomTag(@NotNull PsiFile file, @NotNull XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        XmlElementDescriptor xmlElementDescriptor = tag.getDescriptor();
        if (xmlElementDescriptor == null) {
            return false;
        }
        XmlElementDescriptor descriptor = xmlElementDescriptor;
        if (descriptor instanceof XmlCustomElementDescriptor) {
            return ((XmlCustomElementDescriptor)descriptor).isCustomElement();
        }
        return XmlCustomTagHighlightingPassKt.isHtmlLikeFile(file) && !XmlCustomTagHighlightingPassKt.isHtmlTagName(descriptor, tag);
    }

    private static final boolean isHtmlLikeFile(PsiFile file) {
        boolean bl;
        block3: {
            List list = file.getViewProvider().getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"file.viewProvider.allFiles");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof HtmlCompatibleFile)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl || HtmlUtil.supportsXmlTypedHandlers(file);
    }

    private static final boolean isHtmlTagName(XmlElementDescriptor descriptor, XmlTag tag) {
        XmlElementDescriptor htmlDescriptor;
        if (descriptor instanceof HtmlElementDescriptorImpl) {
            return true;
        }
        XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(tag.getNamespace(), true);
        if (nsDescriptor instanceof HtmlNSDescriptorImpl && (htmlDescriptor = ((HtmlNSDescriptorImpl)nsDescriptor).getElementDescriptorByName(tag.getName())) != null) {
            return Intrinsics.areEqual((Object)descriptor.getName(), (Object)htmlDescriptor.getName());
        }
        return false;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)XmlHighlighterColors.HTML_TAG_NAME, (Object)XmlHighlighterColors.HTML_CUSTOM_TAG_NAME), TuplesKt.to((Object)XmlHighlighterColors.XML_TAG_NAME, (Object)XmlHighlighterColors.XML_CUSTOM_TAG_NAME)};
        attributeKeyMapping = MapsKt.mapOf((Pair[])pairArray);
    }
}

