/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomTagHighlightingPassKt;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u001a0\u001a0\u0019H\u0002J\u001b\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0002\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/xml/XmlCustomTagHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "myHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "kotlin.jvm.PlatformType", "myHolder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "applyHighlighting", "", "node", "Lcom/intellij/lang/ASTNode;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "doApplyInformationToEditor", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getCustomNames", "", "", "hasKey", "", "keys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "([Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Z", "highlight", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "key", "(Lcom/intellij/lang/ASTNode;[Lcom/intellij/openapi/editor/colors/TextAttributesKey;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "replaceTextAttributeKeys", "newAttributesKeys", "([Lcom/intellij/openapi/editor/colors/TextAttributesKey;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.xml.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nXmlCustomTagHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPass\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,139:1\n1137#2,3:140\n11335#3:143\n11670#3,3:144\n1282#3,2:149\n37#4,2:147\n*S KotlinDebug\n*F\n+ 1 XmlCustomTagHighlightingPass.kt\ncom/intellij/xml/XmlCustomTagHighlightingPass\n*L\n69#1:140,3\n86#1:143\n86#1:144,3\n93#1:149,2\n86#1:147,2\n*E\n"})
public final class XmlCustomTagHighlightingPass
extends TextEditorHighlightingPass {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final HighlightInfoHolder myHolder;
    private final SyntaxHighlighter myHighlighter;

    public XmlCustomTagHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(file.getProject(), editor.getDocument(), true);
        this.file = file;
        this.myHolder = new HighlightInfoHolder(this.file, new HighlightInfoFilter[0]);
        this.myHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.file.getLanguage(), (Project)this.file.getProject(), (VirtualFile)this.file.getVirtualFile());
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        this.file.acceptChildren((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(this){
            final /* synthetic */ XmlCustomTagHighlightingPass this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitXmlTag(@NotNull XmlTag tag) {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                    super.visitXmlTag(tag);
                    XmlElementDescriptor xmlElementDescriptor = tag.getDescriptor();
                    if (xmlElementDescriptor == null) {
                        return;
                    }
                    XmlElementDescriptor descriptor = xmlElementDescriptor;
                    if (descriptor instanceof AnyXmlElementDescriptor && !XmlCustomTagHighlightingPass.access$getCustomNames(this.this$0).contains(tag.getName())) {
                        return;
                    }
                    if (!XmlCustomTagHighlightingPassKt.isCustomTag(this.this$0.getFile(), tag)) break block4;
                    ASTNode aSTNode = tag.getNode();
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        XmlCustomTagHighlightingPass xmlCustomTagHighlightingPass = this.this$0;
                        ASTNode it = aSTNode2;
                        boolean bl = false;
                        ASTNode[] aSTNodeArray = it.getChildren(null);
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"it.getChildren(null)");
                        for (ASTNode child : aSTNodeArray) {
                            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                            IElementType iElementType = child.getElementType();
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"child.elementType");
                            XmlCustomTagHighlightingPass.access$applyHighlighting(xmlCustomTagHighlightingPass, child, iElementType);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Set<String> getCustomNames() {
        Set set;
        String string2 = HtmlUtil.getEntitiesString((PsiElement)this.file, "HtmlUnknownTag");
        if (string2 != null) {
            char[] cArray = new char[]{','};
            Sequence sequence = StringsKt.splitToSequence$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (sequence != null) {
                void $this$mapTo$iv;
                Sequence sequence2 = sequence;
                Collection destination$iv = new HashSet();
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv.iterator();
                while (true) {
                    void it;
                    if (!iterator.hasNext()) {
                        set = (HashSet)destination$iv;
                        return set;
                    }
                    Object item$iv = iterator.next();
                    String string3 = (String)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(StringUtil.toLowerCase((String)it));
                }
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private final void applyHighlighting(ASTNode node, IElementType elementType) {
        if (!(node instanceof LeafElement)) {
            return;
        }
        IElementType effectiveElementType = Intrinsics.areEqual((Object)elementType, (Object)XmlElementType.XML_NAME) ? XmlElementType.XML_TAG_NAME : elementType;
        Object[] objectArray = this.myHighlighter.getTokenHighlights(effectiveElementType);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"myHighlighter.getTokenHi\u2026hts(effectiveElementType)");
        Object[] attributesKeys = objectArray;
        Object[] newAttributesKeys = this.replaceTextAttributeKeys((TextAttributesKey[])attributesKeys);
        if (!Arrays.equals(newAttributesKeys, attributesKeys)) {
            this.myHolder.add(this.highlight(node, (TextAttributesKey[])newAttributesKeys));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final TextAttributesKey[] replaceTextAttributeKeys(TextAttributesKey[] newAttributesKeys) {
        if (this.hasKey(newAttributesKeys)) {
            void $this$mapTo$iv$iv;
            TextAttributesKey[] $this$map$iv = newAttributesKeys;
            boolean $i$f$map = false;
            TextAttributesKey[] textAttributesKeyArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TextAttributesKey textAttributesKey = XmlCustomTagHighlightingPassKt.getAttributeKeyMapping().get(it);
                if (textAttributesKey == null) {
                    textAttributesKey = it;
                }
                collection.add(textAttributesKey);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TextAttributesKey[0]);
        }
        return newAttributesKeys;
    }

    private final boolean hasKey(TextAttributesKey[] keys) {
        TextAttributesKey textAttributesKey;
        block1: {
            TextAttributesKey[] $this$firstOrNull$iv = keys;
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                TextAttributesKey element$iv;
                TextAttributesKey it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!XmlCustomTagHighlightingPassKt.getAttributeKeyMapping().containsKey(it)) continue;
                textAttributesKey = element$iv;
                break block1;
            }
            textAttributesKey = null;
        }
        return textAttributesKey != null;
    }

    private final HighlightInfo highlight(ASTNode node, TextAttributesKey[] key2) {
        String description2 = ApplicationManager.getApplication().isUnitTestMode() ? "Custom tag name" : null;
        HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).severity(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(node);
        EditorColorsScheme editorColorsScheme = this.getColorsScheme();
        if (editorColorsScheme == null) {
            editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        }
        HighlightInfo.Builder builder3 = builder2.textAttributes((TextAttributes)LayeredTextAttributes.create((EditorColorsScheme)editorColorsScheme, (TextAttributesKey[])key2));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newHighlightInfo(INFORMA\u2026faultColorScheme(), key))");
        HighlightInfo.Builder textAttributes = builder3;
        if (description2 != null) {
            HighlightInfo.Builder builder4 = textAttributes.description(description2);
            Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"textAttributes.description(description)");
            textAttributes = builder4;
        }
        return textAttributes.create();
    }

    public void doApplyInformationToEditor() {
        List highlights = new ArrayList();
        int n = this.myHolder.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = this.myHolder.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)highlightInfo, (String)"myHolder[i]");
            highlights.add(highlightInfo);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)highlights, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    public static final /* synthetic */ Set access$getCustomNames(XmlCustomTagHighlightingPass $this) {
        return $this.getCustomNames();
    }

    public static final /* synthetic */ void access$applyHighlighting(XmlCustomTagHighlightingPass $this, ASTNode node, IElementType elementType) {
        $this.applyHighlighting(node, elementType);
    }
}

