/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0004 !\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0003J\u0018\u0010\u0018\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0007R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "container", "Lcom/intellij/ui/components/JBPanel;", "logCreationCallback", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "projectLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "tabContent", "Lcom/intellij/ui/content/Content;", "<set-?>", "ui", "getUi", "()Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "addMainUi", "", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "disposeContent", "disposeMainUi", "executeOnMainUiCreated", "consumer", "Lcom/intellij/util/Consumer;", "initTabContent", "content", "updateDisplayName", "waitMainUiCreation", "Lcom/google/common/util/concurrent/ListenableFuture;", "Companion", "DisplayNameSupplier", "VcsLogContentPreloader", "VcsLogVisibilityPredicate", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogContentProvider.kt\ncom/intellij/vcs/log/impl/VcsLogContentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class VcsLogContentProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsProjectLog projectLog;
    @NotNull
    private final JBPanel<JBPanel<?>> container;
    @Nullable
    private Content tabContent;
    @Nullable
    private MainVcsLogUi ui;
    @Nullable
    private SettableFuture<MainVcsLogUi> logCreationCallback;
    @NotNull
    public static final String TAB_NAME = "Log";
    @NotNull
    public static final String MAIN_LOG_ID = "MAIN";

    public VcsLogContentProvider(@NotNull Project project2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.projectLog = VcsProjectLog.Companion.getInstance(project2);
            this.container = new JBPanel((LayoutManager)new BorderLayout());
            project2.getMessageBus().connect(this.projectLog.getCoroutineScope$intellij_platform_vcs_log_impl()).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

                @Override
                public void logCreated(@NotNull VcsLogManager manager) {
                    Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                    this.addMainUi(manager);
                }

                @Override
                public void logDisposed(@NotNull VcsLogManager manager) {
                    Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                    this.disposeMainUi();
                }
            });
            VcsLogManager vcsLogManager = this.projectLog.getLogManager();
            if (vcsLogManager == null) break block0;
            VcsLogManager it = vcsLogManager;
            boolean bl = false;
            this.addMainUi(it);
        }
    }

    @Nullable
    public final MainVcsLogUi getUi() {
        return this.ui;
    }

    @Override
    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.projectLog.isDisposing()) {
            return;
        }
        Content content2 = this.tabContent = content;
        Intrinsics.checkNotNull((Object)content2);
        content2.setTabName(TAB_NAME);
        this.updateDisplayName();
        this.projectLog.createLogInBackground(true);
        content.setComponent((JComponent)this.container);
        content.setDisposer(() -> VcsLogContentProvider.initTabContent$lambda$1(this));
    }

    @RequiresEdt
    private final void addMainUi(VcsLogManager logManager2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.ui == null) {
            MainVcsLogUi mainVcsLogUi = this.ui = logManager2.createLogUi(MAIN_LOG_ID, VcsLogTabLocation.TOOL_WINDOW, false);
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            VcsLogPanel panel2 = new VcsLogPanel(logManager2, mainVcsLogUi);
            this.container.add((Component)((Object)panel2), (Object)"Center");
            DataManager.registerDataProvider((JComponent)((JComponent)this.container), (DataProvider)panel2);
            this.updateDisplayName();
            MainVcsLogUi mainVcsLogUi2 = this.ui;
            Intrinsics.checkNotNull((Object)mainVcsLogUi2);
            mainVcsLogUi2.getFilterUi().addFilterListener(() -> VcsLogContentProvider.addMainUi$lambda$2(this));
            if (this.logCreationCallback != null) {
                SettableFuture<MainVcsLogUi> settableFuture = this.logCreationCallback;
                Intrinsics.checkNotNull(settableFuture);
                settableFuture.set((Object)this.ui);
                this.logCreationCallback = null;
            }
        }
    }

    private final void updateDisplayName() {
        if (this.tabContent != null && this.ui != null) {
            Content content = this.tabContent;
            Intrinsics.checkNotNull((Object)content);
            MainVcsLogUi mainVcsLogUi = this.ui;
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            content.setDisplayName(VcsLogTabsManager.Companion.generateDisplayName(mainVcsLogUi));
        }
    }

    @RequiresEdt
    private final void disposeMainUi() {
        block1: {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.container.removeAll();
            DataManager.removeDataProvider((JComponent)((JComponent)this.container));
            SettableFuture<MainVcsLogUi> settableFuture = this.logCreationCallback;
            if (settableFuture != null) {
                SettableFuture<MainVcsLogUi> callback2 = settableFuture;
                boolean bl = false;
                this.logCreationCallback = null;
                callback2.set(null);
            }
            MainVcsLogUi mainVcsLogUi = this.ui;
            if (mainVcsLogUi == null) break block1;
            MainVcsLogUi oldUi = mainVcsLogUi;
            boolean bl = false;
            this.ui = null;
            Disposer.dispose((Disposable)oldUi);
        }
    }

    @RequiresEdt
    public final void executeOnMainUiCreated(@NotNull Consumer<? super MainVcsLogUi> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ApplicationManager.getApplication().assertIsDispatchThread();
        ListenableFuture<MainVcsLogUi> future2 = this.waitMainUiCreation();
        future2.addListener(() -> VcsLogContentProvider.executeOnMainUiCreated$lambda$5(future2, consumer), MoreExecutors.directExecutor());
    }

    @RequiresEdt
    @NotNull
    public final ListenableFuture<MainVcsLogUi> waitMainUiCreation() {
        SettableFuture settableFuture;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.ui != null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.ui);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(ui)");
            return listenableFuture;
        }
        if (this.logCreationCallback != null) {
            SettableFuture<MainVcsLogUi> settableFuture2 = this.logCreationCallback;
            Intrinsics.checkNotNull(settableFuture2);
            settableFuture2.set(null);
        }
        this.logCreationCallback = settableFuture = SettableFuture.create();
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"settableFuture");
        return (ListenableFuture)settableFuture;
    }

    @Override
    public void disposeContent() {
        this.disposeMainUi();
    }

    private static final void initTabContent$lambda$1(VcsLogContentProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.disposeContent();
        this$0.tabContent = null;
    }

    private static final void addMainUi$lambda$2(VcsLogContentProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateDisplayName();
    }

    private static final void executeOnMainUiCreated$lambda$5(ListenableFuture $future, Consumer $consumer) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        try {
            MainVcsLogUi result2 = (MainVcsLogUi)$future.get();
            if (result2 != null) {
                $consumer.consume((Object)result2);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$Companion;", "", "()V", "MAIN_LOG_ID", "", "Lorg/jetbrains/annotations/NonNls;", "TAB_NAME", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "()V", "get", "intellij.platform.vcs.log.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string2 = VcsLogBundle.message("vcs.log.tab.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"vcs.log.tab.name\")");
            return string2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogContentPreloader;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider$Preloader;", "()V", "preloadTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @Override
        public void preloadTabContent(@NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            content.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)ChangesViewContentManager.TabOrderWeight.BRANCHES.getWeight());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "()V", "test", "", "project", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogVisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return !VcsProjectLog.Companion.getLogProviders(project2).isEmpty();
        }
    }
}

