/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementGenerator;
import com.intellij.vcs.log.graph.api.printer.PrintElementPresentationManager;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.impl.print.PrintElementGeneratorImpl;
import com.intellij.vcs.log.graph.impl.print.elements.EdgePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.impl.print.elements.SimplePrintElementImpl;
import com.intellij.vcs.log.graph.impl.print.elements.TerminalEdgePrintElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 32\u00020\u0001:\u000234B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB=\b\u0007\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000e2\n\u0010 \u001a\u00060!R\u00020\u0000H\u0002J&\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010\u000e0#2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0018\u00102\u001a\u00020\u00072\u0006\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0018\u00102\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u000eH\u0002R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementGenerator;", "graph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "presentationManager", "Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;", "showLongEdges", "", "elementComparator", "Ljava/util/Comparator;", "Lcom/intellij/vcs/log/graph/api/elements/GraphElement;", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;ZLjava/util/Comparator;)V", "linearGraph", "longEdgeSize", "", "visiblePartSize", "edgeWithArrowSize", "(Lcom/intellij/vcs/log/graph/api/LinearGraph;Lcom/intellij/vcs/log/graph/api/printer/PrintElementPresentationManager;Ljava/util/Comparator;III)V", "cache", "Lcom/intellij/util/containers/SLRUMap;", "", "edgesInRowGenerator", "Lcom/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator;", "recommendedWidth", "getRecommendedWidth", "()I", "recommendedWidth$delegate", "Lkotlin/Lazy;", "calculateRecommendedWidth", "collectElements", "", "rowIndex", "builder", "Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$PrintElementBuilder;", "createEndPositionFunction", "Lkotlin/Function1;", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "visibleRowIndex", "up", "getArrowType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "edge", "normalEdge", "Lcom/intellij/vcs/log/graph/utils/NormalEdge;", "getAttachmentDistance", "e1", "getPrintElements", "", "Lcom/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement;", "getSortedVisibleElementsInRow", "isEdgeVisibleInRow", "Companion", "PrintElementBuilder", "intellij.platform.vcs.log.graph.impl"})
@SourceDebugExtension(value={"SMAP\nPrintElementGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrintElementGeneratorImpl.kt\ncom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n1864#2,2:310\n1855#2,2:312\n1866#2:314\n1864#2,3:315\n857#2,2:318\n857#2,2:320\n857#2,2:322\n*S KotlinDebug\n*F\n+ 1 PrintElementGeneratorImpl.kt\ncom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl\n*L\n127#1:310,2\n132#1:312,2\n127#1:314\n171#1:315,3\n245#1:318,2\n248#1:320,2\n252#1:322,2\n*E\n"})
public final class PrintElementGeneratorImpl
implements PrintElementGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinearGraph linearGraph;
    @NotNull
    private final PrintElementPresentationManager presentationManager;
    @NotNull
    private final Comparator<GraphElement> elementComparator;
    private final int longEdgeSize;
    private final int visiblePartSize;
    private final int edgeWithArrowSize;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> cache;
    @NotNull
    private final EdgesInRowGenerator edgesInRowGenerator;
    @NotNull
    private final Lazy recommendedWidth$delegate;
    @NotNull
    private static final Logger LOG;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    public static final int LONG_EDGE_SIZE = 30;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int CACHE_SIZE = 100;
    private static final int SAMPLE_SIZE = 20000;
    private static final double K = 0.1;

    @TestOnly
    public PrintElementGeneratorImpl(@NotNull LinearGraph linearGraph, @NotNull PrintElementPresentationManager presentationManager, @NotNull Comparator<GraphElement> elementComparator, int longEdgeSize, int visiblePartSize, int edgeWithArrowSize) {
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter((Object)presentationManager, (String)"presentationManager");
        Intrinsics.checkNotNullParameter(elementComparator, (String)"elementComparator");
        this.linearGraph = linearGraph;
        this.presentationManager = presentationManager;
        this.elementComparator = elementComparator;
        this.longEdgeSize = longEdgeSize;
        this.visiblePartSize = visiblePartSize;
        this.edgeWithArrowSize = edgeWithArrowSize;
        this.cache = new SLRUMap(100, 200);
        this.edgesInRowGenerator = new EdgesInRowGenerator(this.linearGraph);
        this.recommendedWidth$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ PrintElementGeneratorImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return PrintElementGeneratorImpl.access$calculateRecommendedWidth(this.this$0);
            }
        }));
    }

    public final int getRecommendedWidth() {
        Lazy lazy = this.recommendedWidth$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementPresentationManager presentationManager, boolean showLongEdges, @NotNull Comparator<GraphElement> elementComparator) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)presentationManager, (String)"presentationManager");
        Intrinsics.checkNotNullParameter(elementComparator, (String)"elementComparator");
        this(graph, presentationManager, elementComparator, showLongEdges ? 1000 : 30, showLongEdges ? 250 : 1, showLongEdges ? 30 : Integer.MAX_VALUE);
    }

    private final int calculateRecommendedWidth() {
        int nodesCount = this.linearGraph.nodesCount();
        if (nodesCount == 0) {
            return 0;
        }
        if (nodesCount == 1) {
            return 1;
        }
        int n = Math.min(20000, nodesCount);
        double sum2 = 0.0;
        double sumSquares = 0.0;
        int edgesCount = 0;
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet<NormalEdge>()");
        Set currentNormalEdges = set;
        for (int i = 0; i < n; ++i) {
            List<GraphEdge> adjacentEdges;
            Intrinsics.checkNotNullExpressionValue(this.linearGraph.getAdjacentEdges(i, EdgeFilter.ALL), (String)"linearGraph.getAdjacentEdges(i, EdgeFilter.ALL)");
            int upArrows = 0;
            int downArrows = 0;
            for (GraphEdge graphEdge : adjacentEdges) {
                NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(graphEdge);
                if (normalEdge != null) {
                    if (LinearGraphUtils.isEdgeUp(graphEdge, i)) {
                        currentNormalEdges.remove(normalEdge);
                        continue;
                    }
                    currentNormalEdges.add(normalEdge);
                    continue;
                }
                if (graphEdge.getType() == GraphEdgeType.DOTTED_ARROW_UP) {
                    ++upArrows;
                    continue;
                }
                ++downArrows;
            }
            int newEdgesCount = 0;
            for (NormalEdge e3 : currentNormalEdges) {
                Intrinsics.checkNotNullExpressionValue((Object)e3, (String)"e");
                if (this.isEdgeVisibleInRow(e3, i)) {
                    ++newEdgesCount;
                    continue;
                }
                EdgePrintElement.Type arrow = this.getArrowType(e3, i);
                if (arrow == EdgePrintElement.Type.DOWN) {
                    ++downArrows;
                    continue;
                }
                if (arrow != EdgePrintElement.Type.UP) continue;
                ++upArrows;
            }
            int n2 = Math.max(edgesCount + upArrows, newEdgesCount + downArrows);
            double weight = (double)2 / ((double)n * 1.1) * (1.0 + -0.9 * (double)i / (double)(n - 1));
            sum2 += (double)n2 * weight;
            sumSquares += (double)n2 * (double)n2 * weight;
            edgesCount = newEdgesCount;
        }
        double average = sum2;
        double deviation = Math.sqrt(sumSquares - average * average);
        return (int)Math.round(average + deviation);
    }

    /*
     * WARNING - void declaration
     */
    private final void collectElements(int rowIndex, PrintElementBuilder builder2) {
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        Function1<GraphEdge, Integer> upPosition = this.createEndPositionFunction(rowIndex - 1, true);
        Function1<GraphEdge, Integer> downPosition = this.createEndPositionFunction(rowIndex + 1, false);
        Iterable $this$forEachIndexed$iv = visibleElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl = false;
            void var15_15 = element;
            if (var15_15 instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                builder2.consumeNode((GraphNode)element, position);
                List<GraphEdge> list = this.linearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL);
                Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026odeIndex, EdgeFilter.ALL)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GraphEdge edge = (GraphEdge)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)edge, (String)"edge");
                    EdgePrintElement.Type arrowType = this.getArrowType(edge, rowIndex);
                    Integer down = (Integer)downPosition.invoke((Object)edge);
                    Integer up = (Integer)upPosition.invoke((Object)edge);
                    if (down != null) {
                        builder2.consumeDownEdge(edge, position, down, arrowType == EdgePrintElement.Type.DOWN);
                    }
                    if (up == null) continue;
                    builder2.consumeUpEdge(edge, up, position, arrowType == EdgePrintElement.Type.UP);
                }
                continue;
            }
            if (!(var15_15 instanceof GraphEdge)) continue;
            EdgePrintElement.Type arrowType = this.getArrowType((GraphEdge)element, rowIndex);
            Integer down = (Integer)downPosition.invoke((Object)element);
            Integer up = (Integer)upPosition.invoke((Object)element);
            if (down != null) {
                builder2.consumeDownEdge((GraphEdge)element, position, down, arrowType == EdgePrintElement.Type.DOWN);
            } else if (arrowType == EdgePrintElement.Type.DOWN) {
                builder2.consumeArrow((GraphEdge)element, position, arrowType);
            }
            if (up != null) {
                builder2.consumeUpEdge((GraphEdge)element, up, position, arrowType == EdgePrintElement.Type.UP);
                continue;
            }
            if (arrowType != EdgePrintElement.Type.UP) continue;
            builder2.consumeArrow((GraphEdge)element, position, arrowType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex, boolean up) {
        if (visibleRowIndex < 0 || visibleRowIndex >= this.linearGraph.nodesCount()) {
            return createEndPositionFunction.1.INSTANCE;
        }
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>(visibleElementsInNextRow.size());
        Iterable $this$forEachIndexed$iv = visibleElementsInNextRow;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphElement graphElement = (GraphElement)item$iv;
            int position = n;
            boolean bl = false;
            Integer n2 = position;
            ((Map)toPosition).put(element, n2);
        }
        return (Function1)new Function1<GraphEdge, Integer>(toPosition, this, up){
            final /* synthetic */ HashMap<GraphElement, Integer> $toPosition;
            final /* synthetic */ PrintElementGeneratorImpl this$0;
            final /* synthetic */ boolean $up;
            {
                this.$toPosition = $toPosition;
                this.this$0 = $receiver;
                this.$up = $up;
                super(1);
            }

            @Nullable
            public final Integer invoke(@NotNull GraphEdge edge) {
                Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
                Integer n = this.$toPosition.get(edge);
                if (n == null) {
                    Integer nodeIndex;
                    PrintElementGeneratorImpl printElementGeneratorImpl = this.this$0;
                    boolean bl = this.$up;
                    HashMap<GraphElement, Integer> hashMap = this.$toPosition;
                    PrintElementGeneratorImpl $this$invoke_u24lambda_u240 = printElementGeneratorImpl;
                    boolean bl2 = false;
                    Integer n2 = nodeIndex = bl ? edge.getUpNodeIndex() : edge.getDownNodeIndex();
                    n = nodeIndex != null ? hashMap.get(PrintElementGeneratorImpl.access$getLinearGraph$p($this$invoke_u24lambda_u240).getGraphNode(nodeIndex)) : null;
                }
                return n;
            }
        };
    }

    private final EdgePrintElement.Type getArrowType(GraphEdge edge, int rowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge != null) {
            return this.getArrowType(normalEdge, rowIndex);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[edge.getType().ordinal()]) {
            case 1: 
            case 2: {
                if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), rowIndex - 1)) break;
                return EdgePrintElement.Type.DOWN;
            }
            case 3: {
                if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), rowIndex + 1)) break;
                return EdgePrintElement.Type.UP;
            }
            default: {
                LOG.error("Unknown special edge type " + edge.getType() + " at row " + rowIndex);
            }
        }
        return null;
    }

    private final EdgePrintElement.Type getArrowType(NormalEdge normalEdge, int rowIndex) {
        int edgeSize = normalEdge.down - normalEdge.up;
        int upOffset = rowIndex - normalEdge.up;
        int downOffset = normalEdge.down - rowIndex;
        if (edgeSize >= this.longEdgeSize) {
            if (upOffset == this.visiblePartSize) {
                LOG.assertTrue(downOffset != this.visiblePartSize, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == this.visiblePartSize) {
                return EdgePrintElement.Type.UP;
            }
        }
        if (edgeSize >= this.edgeWithArrowSize) {
            if (upOffset == 1) {
                LOG.assertTrue(downOffset != 1, (Object)("Both up and down arrow at row " + rowIndex));
                return EdgePrintElement.Type.DOWN;
            }
            if (downOffset == 1) {
                return EdgePrintElement.Type.UP;
            }
        }
        return null;
    }

    private final boolean isEdgeVisibleInRow(GraphEdge edge, int visibleRowIndex) {
        NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return false;
        }
        NormalEdge normalEdge2 = normalEdge;
        return this.isEdgeVisibleInRow(normalEdge2, visibleRowIndex);
    }

    private final boolean isEdgeVisibleInRow(NormalEdge normalEdge, int visibleRowIndex) {
        return normalEdge.down - normalEdge.up < this.longEdgeSize || this.getAttachmentDistance(normalEdge, visibleRowIndex) <= this.visiblePartSize;
    }

    private final List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        GraphEdge it;
        List graphElements = (List)this.cache.get((Object)rowIndex);
        if (graphElements != null) {
            return graphElements;
        }
        ArrayList<GraphNode> result2 = new ArrayList<GraphNode>();
        result2.add(this.linearGraph.getGraphNode(rowIndex));
        Set<GraphEdge> set = this.edgesInRowGenerator.getEdgesInRow(rowIndex);
        Intrinsics.checkNotNullExpressionValue(set, (String)"edgesInRowGenerator.getEdgesInRow(rowIndex)");
        Iterable $this$filterTo$iv = set;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            it = (GraphEdge)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.isEdgeVisibleInRow(it, rowIndex)) continue;
            ((Collection)result2).add(element$iv);
        }
        if (rowIndex > 0) {
            List<GraphEdge> list = this.linearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL);
            Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026 - 1, EdgeFilter.SPECIAL)");
            $this$filterTo$iv = list;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeDown(it, rowIndex - 1)) continue;
                ((Collection)result2).add(element$iv);
            }
        }
        if (rowIndex < this.linearGraph.nodesCount() - 1) {
            List<GraphEdge> list = this.linearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL);
            Intrinsics.checkNotNullExpressionValue(list, (String)"linearGraph.getAdjacentE\u2026 + 1, EdgeFilter.SPECIAL)");
            $this$filterTo$iv = list;
            $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                it = (GraphEdge)element$iv;
                boolean bl = false;
                if (!LinearGraphUtils.isEdgeUp(it, rowIndex + 1)) continue;
                ((Collection)result2).add(element$iv);
            }
        }
        Collections.sort((List)result2, this.elementComparator);
        this.cache.put((Object)rowIndex, result2);
        return result2;
    }

    @Override
    @NotNull
    public Collection<PrintElementWithGraphElement> getPrintElements(int rowIndex) {
        PrintElementBuilder builder2 = new PrintElementBuilder(rowIndex);
        this.collectElements(rowIndex, builder2);
        return builder2.build();
    }

    private final int getAttachmentDistance(NormalEdge e1, int rowIndex) {
        return Math.min(rowIndex - e1.up, e1.down - rowIndex);
    }

    public static final /* synthetic */ LinearGraph access$getLinearGraph$p(PrintElementGeneratorImpl $this) {
        return $this.linearGraph;
    }

    public static final /* synthetic */ int access$calculateRecommendedWidth(PrintElementGeneratorImpl $this) {
        return $this.calculateRecommendedWidth();
    }

    static {
        Logger logger = Logger.getInstance(PrintElementGeneratorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(PrintElementGeneratorImpl::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$Companion;", "", "()V", "CACHE_SIZE", "", "K", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LONG_EDGE_PART_SIZE", "LONG_EDGE_SIZE", "SAMPLE_SIZE", "VERY_LONG_EDGE_PART_SIZE", "VERY_LONG_EDGE_SIZE", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0003J&\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl$PrintElementBuilder;", "", "rowIndex", "", "(Lcom/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl;I)V", "nodes", "Ljava/util/ArrayList;", "Lcom/intellij/vcs/log/graph/impl/print/elements/PrintElementWithGraphElement;", "result", "build", "", "consumeArrow", "", "edge", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "position", "arrowType", "Lcom/intellij/vcs/log/graph/EdgePrintElement$Type;", "consumeDownEdge", "upPosition", "downPosition", "hasArrow", "", "consumeNode", "node", "Lcom/intellij/vcs/log/graph/api/elements/GraphNode;", "consumeUpEdge", "intellij.platform.vcs.log.graph.impl"})
    private final class PrintElementBuilder {
        private final int rowIndex;
        @NotNull
        private final ArrayList<PrintElementWithGraphElement> result;
        @NotNull
        private final ArrayList<PrintElementWithGraphElement> nodes;

        public PrintElementBuilder(int rowIndex) {
            this.rowIndex = rowIndex;
            this.result = new ArrayList();
            this.nodes = new ArrayList();
        }

        public final void consumeNode(@NotNull GraphNode node, int position) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.nodes.add(new SimplePrintElementImpl(this.rowIndex, position, node, PrintElementGeneratorImpl.this.presentationManager));
        }

        public final void consumeDownEdge(@NotNull GraphEdge edge, int upPosition, int downPosition, boolean hasArrow) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            this.result.add(new EdgePrintElementImpl(this.rowIndex, upPosition, downPosition, EdgePrintElement.Type.DOWN, edge, hasArrow, PrintElementGeneratorImpl.this.presentationManager));
        }

        public final void consumeUpEdge(@NotNull GraphEdge edge, int upPosition, int downPosition, boolean hasArrow) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            this.result.add(new EdgePrintElementImpl(this.rowIndex, downPosition, upPosition, EdgePrintElement.Type.UP, edge, hasArrow, PrintElementGeneratorImpl.this.presentationManager));
        }

        public final void consumeArrow(@NotNull GraphEdge edge, int position, @NotNull EdgePrintElement.Type arrowType) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)((Object)arrowType), (String)"arrowType");
            this.result.add(new TerminalEdgePrintElement(this.rowIndex, position, arrowType, edge, PrintElementGeneratorImpl.this.presentationManager));
        }

        @NotNull
        public final Collection<PrintElementWithGraphElement> build() {
            this.result.addAll((Collection<PrintElementWithGraphElement>)this.nodes);
            return this.result;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GraphEdgeType.values().length];
            try {
                nArray[GraphEdgeType.DOTTED_ARROW_DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphEdgeType.NOT_LOAD_COMMIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GraphEdgeType.DOTTED_ARROW_UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

