/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0001\u00a8\u0006\u000b"}, d2={"isBig", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "isIndexingPaused", "Lcom/intellij/vcs/log/data/index/VcsLogModifiableIndex;", "isScheduledForIndexing", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "root", "needIndexing", "toggleIndexing", "", "intellij.platform.vcs.log.impl"})
@JvmName(name="VcsLogIndexUtils")
@SourceDebugExtension(value={"SMAP\nVcsLogIndexUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogIndexUtils.kt\ncom/intellij/vcs/log/data/index/VcsLogIndexUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n766#2:48\n857#2,2:49\n766#2:51\n857#2,2:52\n766#2:54\n857#2,2:55\n1747#2,3:57\n766#2:60\n857#2,2:61\n1855#2,2:63\n766#2:65\n857#2,2:66\n*S KotlinDebug\n*F\n+ 1 VcsLogIndexUtils.kt\ncom/intellij/vcs/log/data/index/VcsLogIndexUtils\n*L\n14#1:48\n14#1:49,2\n15#1:51\n15#1:52,2\n24#1:54\n24#1:55,2\n34#1:57,3\n35#1:60\n35#1:61,2\n35#1:63,2\n39#1:65\n39#1:66,2\n*E\n"})
public final class VcsLogIndexUtils {
    /*
     * WARNING - void declaration
     */
    public static final boolean needIndexing(@NotNull VcsLogModifiableIndex $this$needIndexing) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$needIndexing, (String)"<this>");
        Set<VirtualFile> set = $this$needIndexing.getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"indexingRoots");
        Set<VirtualFile> rootsForIndexing = set;
        if (rootsForIndexing.isEmpty()) {
            return false;
        }
        Iterable $this$filter$iv = rootsForIndexing;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VcsLogIndex vcsLogIndex = $this$needIndexing;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!VcsLogIndexUtils.isScheduledForIndexing(vcsLogIndex, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scheduledForIndexing = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = rootsForIndexing;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!VcsLogIndexUtils.isBig(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List bigRepositories = (List)destination$iv$iv2;
        return !((Collection)bigRepositories).isEmpty() || !((Collection)scheduledForIndexing).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isIndexingPaused(@NotNull VcsLogModifiableIndex $this$isIndexingPaused) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isIndexingPaused, (String)"<this>");
        Set<VirtualFile> set = $this$isIndexingPaused.getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"indexingRoots");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VcsLogIndex vcsLogIndex = $this$isIndexingPaused;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!VcsLogIndexUtils.isScheduledForIndexing(vcsLogIndex, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scheduledForIndexing = (List)destination$iv$iv;
        return scheduledForIndexing.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static final void toggleIndexing(@NotNull VcsLogModifiableIndex $this$toggleIndexing) {
        Object it;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)$this$toggleIndexing, (String)"<this>");
            Set<VirtualFile> set = $this$toggleIndexing.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"indexingRoots");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    VcsLogIndex vcsLogIndex = $this$toggleIndexing;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!VcsLogIndexUtils.isScheduledForIndexing(vcsLogIndex, it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            Iterator $this$filterTo$iv$iv;
            Set<VirtualFile> set = $this$toggleIndexing.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"indexingRoots");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl2 = $this$filterTo$iv$iv.iterator();
            while (bl2.hasNext()) {
                Object element$iv$iv = bl2.next();
                VirtualFile it2 = (VirtualFile)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                if (!(!VcsLogIndexUtils.isBig(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it3 = (VirtualFile)element$iv;
                boolean bl4 = false;
                VcsLogBigRepositoriesList.getInstance().addRepository(it3);
            }
        } else {
            void $this$filterTo$iv$iv;
            boolean resumed = false;
            Set<VirtualFile> set = $this$toggleIndexing.getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"indexingRoots");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it4 = (VirtualFile)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it4, (String)"it");
                if (!VcsLogIndexUtils.isBig(it4)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (VirtualFile root : (List)destination$iv$iv) {
                resumed |= VcsLogBigRepositoriesList.getInstance().removeRepository(root);
            }
            if (resumed) {
                $this$toggleIndexing.scheduleIndex(false);
            }
        }
    }

    public static final boolean isBig(@NotNull VirtualFile $this$isBig) {
        Intrinsics.checkNotNullParameter((Object)$this$isBig, (String)"<this>");
        return VcsLogBigRepositoriesList.getInstance().isBig($this$isBig);
    }

    public static final boolean isScheduledForIndexing(@NotNull VcsLogIndex $this$isScheduledForIndexing, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)$this$isScheduledForIndexing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return $this$isScheduledForIndexing.isIndexingEnabled(root) && !$this$isScheduledForIndexing.isIndexed(root);
    }
}

