/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.plugin.ui.DirectoryComboBoxWithButtons;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.GridBag;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private static final Condition<ScopeDescriptor> SCOPE_FILTER = descriptor -> IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(descriptor.getDisplayName()) || !(descriptor.getScope() instanceof ModuleWithDependenciesScope);
    private final Project myProject;
    @NotNull
    private SearchScope myScope;
    private Consumer<? super SearchScope> myConsumer;
    private Scopes.Type myScopeType;
    private boolean myUpdating;
    private final ActionToolbarImpl myToolbar;
    private final JPanel myScopeDetailsPanel;
    private final ModulesComboBox myModulesComboBox;
    private final DirectoryComboBoxWithButtons myDirectoryComboBox;
    private final ScopeChooserCombo myScopesComboBox;
    private String myCurrentNamedScope;

    public ScopePanel(@NotNull Project project2, Disposable parent) {
        if (project2 == null) {
            ScopePanel.$$$reportNull$$$0(0);
        }
        super(null);
        this.myUpdating = false;
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myModulesComboBox = new ModulesComboBox();
        this.myScopesComboBox = new ScopeChooserCombo();
        this.myCurrentNamedScope = null;
        this.myProject = project2;
        this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
        this.myScopeType = Scopes.Type.PROJECT;
        Module[] allModules = ModuleManager.getInstance((Project)project2).getModules();
        this.myModulesComboBox.setModules(Arrays.asList(allModules));
        if (allModules.length > 0) {
            this.myModulesComboBox.setSelectedModule(allModules[0]);
        }
        this.myModulesComboBox.addActionListener(e -> this.setScopeFromUI());
        this.myModulesComboBox.setMinimumAndPreferredWidth(JBUIScale.scale((int)300));
        this.myScopesComboBox.initialize(project2, true, false, (Object)"", SCOPE_FILTER).onSuccess(o -> {
            this.myScopesComboBox.getComboBox().addActionListener(e -> this.setScopeFromUI());
            if (this.myCurrentNamedScope != null) {
                this.myScopesComboBox.selectItem((Object)this.myCurrentNamedScope);
                this.myCurrentNamedScope = null;
            }
        });
        Disposer.register((Disposable)parent, (Disposable)this.myScopesComboBox);
        this.myDirectoryComboBox = new DirectoryComboBoxWithButtons(this.myProject);
        this.myDirectoryComboBox.setCallback(() -> this.setScopeFromUI());
        this.myScopeDetailsPanel.add(Scopes.Type.PROJECT.toString(), new JLabel());
        this.myScopeDetailsPanel.add(Scopes.Type.MODULE.toString(), ScopePanel.shrinkWrap((JComponent)this.myModulesComboBox));
        this.myScopeDetailsPanel.add(Scopes.Type.DIRECTORY.toString(), this.myDirectoryComboBox);
        this.myScopeDetailsPanel.add(Scopes.Type.NAMED.toString(), ScopePanel.shrinkWrap((JComponent)this.myScopesComboBox));
        boolean fullVersion = !PlatformUtils.isDataGrip();
        DefaultActionGroup scopeActionGroup = fullVersion ? new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.project", (Object[])new Object[0]), Scopes.Type.PROJECT), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.module", (Object[])new Object[0]), Scopes.Type.MODULE), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED)}) : new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.scope", (Object[])new Object[0]), Scopes.Type.NAMED), new ScopeToggleAction(FindBundle.message((String)"find.popup.scope.directory", (Object[])new Object[0]), Scopes.Type.DIRECTORY)});
        this.myToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ScopePanel", (ActionGroup)scopeActionGroup, true);
        this.myToolbar.setTargetComponent((JComponent)this.myToolbar);
        this.myToolbar.setForceMinimumSize(true);
        this.myToolbar.setLayoutPolicy(0);
        GridBagLayout layout = new GridBagLayout();
        GridBag constraint = new GridBag();
        this.setLayout(layout);
        this.add((Component)this.myToolbar, constraint.nextLine());
        this.add((Component)this.myScopeDetailsPanel, constraint.insetLeft(10).weightx(1.0).fillCellHorizontally());
    }

    private void selectNamedScope(String selectedScope) {
        this.myCurrentNamedScope = selectedScope;
        this.myScopesComboBox.selectItem((Object)selectedScope);
    }

    private static JComponent shrinkWrap(JComponent component2) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component2, "West");
        wrapper.add(Box.createHorizontalGlue(), "Center");
        return wrapper;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        if (recentDirectories == null) {
            ScopePanel.$$$reportNull$$$0(1);
        }
        this.myDirectoryComboBox.setRecentDirectories(recentDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScope(@Nullable SearchScope selectedScope) {
        Scopes.Type scopeType = Scopes.getType(selectedScope);
        this.myUpdating = true;
        try {
            if (selectedScope instanceof ModuleWithDependenciesScope) {
                ModuleWithDependenciesScope scope2 = (ModuleWithDependenciesScope)selectedScope;
                this.myModulesComboBox.setItem((Object)scope2.getModule());
            } else if (selectedScope instanceof GlobalSearchScopesCore.DirectoryScope) {
                GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)selectedScope;
                this.myDirectoryComboBox.setDirectory(directoryScope.getDirectory());
                this.myDirectoryComboBox.setRecursive(directoryScope.isWithSubdirectories());
            } else if (selectedScope != null && scopeType == Scopes.Type.NAMED) {
                this.selectNamedScope(selectedScope.getDisplayName());
            }
        }
        finally {
            this.myUpdating = false;
        }
        this.showScope(scopeType);
    }

    public void setScopesFromContext(@Nullable SearchScope scope2) {
        if (scope2 != null) {
            this.myScope = scope2;
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
            Scopes.Type foundScope = null;
            this.myUpdating = true;
            try {
                VirtualFile files2;
                Editor editor;
                Module module;
                boolean moduleFound = false;
                boolean directoryFound = false;
                boolean namedScopeFound = false;
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                if (modules.length > 0) {
                    module = modules[0];
                    this.myModulesComboBox.setSelectedModule(module);
                    VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
                    if (roots.length > 0) {
                        VirtualFile root = roots[0];
                        this.myDirectoryComboBox.setDirectory(root.isDirectory() ? root : root.getParent());
                    }
                }
                if ((module = (Module)PlatformCoreDataKeys.MODULE.getData(context)) != null) {
                    moduleFound = true;
                    this.myModulesComboBox.setSelectedModule(module);
                }
                if ((editor = (Editor)CommonDataKeys.HOST_EDITOR.getData(context)) != null) {
                    VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
                    if (file != null) {
                        this.myDirectoryComboBox.setDirectory(file.getParent());
                    }
                    this.selectNamedScope(PredefinedSearchScopeProviderImpl.getCurrentFileScopeName());
                    this.setScope(scope2);
                    return;
                }
                FindModel findModel = new FindModel();
                for (FindInProjectExtension extension : FindInProjectExtension.EP_NAME.getExtensionList()) {
                    namedScopeFound = extension.initModelFromContext(findModel, context);
                    if (!namedScopeFound) continue;
                    this.selectNamedScope(findModel.getCustomScopeName());
                    foundScope = Scopes.Type.NAMED;
                    break;
                }
                if ((files2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context)) != null && ((VirtualFile[])files2).length > 0) {
                    VirtualFile directory;
                    VirtualFile ancestor;
                    SearchScope selectedFilesScope;
                    Module fileModule;
                    if (!moduleFound && (fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)files2[0], (Project)this.myProject)) != null) {
                        this.myModulesComboBox.setSelectedModule(fileModule);
                    }
                    if (!namedScopeFound && (selectedFilesScope = PredefinedSearchScopeProviderImpl.getSelectedFilesScope((Project)this.myProject, (DataContext)context, null)) != null) {
                        this.selectNamedScope(selectedFilesScope.getDisplayName());
                    }
                    if (((VirtualFile[])files2).length == 1) {
                        directoryFound = true;
                        VirtualFile file = files2[0];
                        this.myDirectoryComboBox.setDirectory(file.isDirectory() ? file : file.getParent());
                        if (foundScope == null) {
                            foundScope = Scopes.Type.DIRECTORY;
                        }
                    } else {
                        for (VirtualFile file : files2) {
                            if (!file.isDirectory()) continue;
                            this.myDirectoryComboBox.setDirectory(file);
                            directoryFound = true;
                            break;
                        }
                        if (foundScope == null) {
                            foundScope = Scopes.Type.NAMED;
                        }
                    }
                    if (!directoryFound && (ancestor = VfsUtil.getCommonAncestor(List.of(files2))) != null) {
                        this.myDirectoryComboBox.setDirectory(ancestor);
                        directoryFound = true;
                    }
                    if (!directoryFound && (directory = files2[0].getParent()) != null) {
                        this.myDirectoryComboBox.setDirectory(directory);
                    }
                }
            }
            finally {
                this.myUpdating = false;
            }
            this.showScope(foundScope == null ? Scopes.Type.PROJECT : foundScope);
        });
    }

    public void setScopeConsumer(@Nullable Consumer<? super SearchScope> consumer) {
        this.myConsumer = consumer;
    }

    @NotNull
    public SearchScope getScope() {
        SearchScope searchScope = this.myScope;
        if (searchScope == null) {
            ScopePanel.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    private void setScopeFromUI() {
        if (this.myUpdating) {
            return;
        }
        switch (this.myScopeType) {
            case PROJECT: {
                this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
                break;
            }
            case MODULE: {
                Module module = this.myModulesComboBox.getSelectedModule();
                if (module == null) {
                    return;
                }
                this.myScope = GlobalSearchScope.moduleScope((Module)module);
                break;
            }
            case DIRECTORY: {
                VirtualFile directory = this.myDirectoryComboBox.getDirectory();
                if (directory == null) {
                    return;
                }
                this.myScope = GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)directory, (boolean)this.myDirectoryComboBox.isRecursive());
                break;
            }
            case NAMED: {
                SearchScope namedScope = this.myScopesComboBox.getSelectedScope();
                if (namedScope == null) {
                    return;
                }
                this.myScope = namedScope;
            }
        }
        if (this.myConsumer != null) {
            this.myConsumer.accept((SearchScope)this.myScope);
        }
    }

    private void showScope(@NotNull Scopes.Type scopeType) {
        if (scopeType == null) {
            ScopePanel.$$$reportNull$$$0(3);
        }
        this.myScopeType = scopeType;
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, scopeType.toString());
        if (this.myScopeType == Scopes.Type.MODULE) {
            this.myModulesComboBox.requestFocus();
        } else if (this.myScopeType == Scopes.Type.DIRECTORY) {
            this.myDirectoryComboBox.getComboBox().requestFocus();
        } else if (this.myScopeType == Scopes.Type.NAMED) {
            this.myScopesComboBox.requestFocus();
        }
        this.setScopeFromUI();
        this.myToolbar.updateActionsImmediately();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRecentDirectories";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    class ScopeToggleAction
    extends DumbAwareToggleAction {
        private final Scopes.Type myScopeType;

        ScopeToggleAction(@NotNull String text2, Scopes.Type scopeType) {
            if (text2 == null) {
                ScopeToggleAction.$$$reportNull$$$0(0);
            }
            if (scopeType == null) {
                ScopeToggleAction.$$$reportNull$$$0(1);
            }
            super(text2);
            this.myScopeType = scopeType;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(2);
            }
            return this.myScopeType == ScopePanel.this.myScopeType;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ScopeToggleAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(4);
            }
            ScopePanel.this.showScope(this.myScopeType);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ScopePanel$ScopeToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel$ScopeToggleAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

