/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.spell.lists.WordList;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableWordListAdapter;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/WordListAdapter;", "Lai/grazie/spell/lists/WordList;", "Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "()V", "contains", "", "word", "", "caseSensitive", "isAlien", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nWordListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/spellchecker/grazie/dictionary/WordListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1726#2,3:45\n1747#2,3:48\n1747#2,3:51\n*S KotlinDebug\n*F\n+ 1 WordListAdapter.kt\ncom/intellij/spellchecker/grazie/dictionary/WordListAdapter\n*L\n9#1:45,3\n14#1:48,3\n19#1:51,3\n*E\n"})
public final class WordListAdapter
extends EditableWordListAdapter
implements WordList {
    public final boolean isAlien(@NotNull String word) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl2 = false;
                    if (it.contains(word) == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && !WordList.contains$default(this.getAggregator(), word, false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (caseSensitive) {
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    Boolean bl3;
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl4 = false;
                    Boolean bl5 = bl3 = it.contains(word);
                    if (bl5 == null) {
                        bl2 = false;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)bl5, (String)"it.contains(word) ?: false");
                        bl2 = bl3;
                    }
                    if (!bl2) continue;
                    return true;
                }
                bl = false;
            }
        } else {
            String string2 = word.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String lowered = string2;
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl6;
                    boolean bl7;
                    Boolean bl8;
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl9 = false;
                    Boolean bl10 = bl8 = it.contains(word);
                    if (bl10 == null) {
                        bl7 = false;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)bl10, (String)"it.contains(word) ?: false");
                        bl7 = bl8;
                    }
                    if (bl7) return true;
                    Boolean bl11 = bl8 = it.contains(lowered);
                    if (bl11 == null) {
                        bl6 = false;
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"it.contains(lowered) ?: false");
                        bl6 = bl8;
                    }
                    if (bl6) {
                        return true;
                    }
                    boolean bl12 = false;
                    if (!bl12) continue;
                    return true;
                }
                bl = false;
            }
        }
        boolean inDictionary = bl;
        if (inDictionary) return true;
        if (!this.getAggregator().contains(word, caseSensitive)) return false;
        return true;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (Dictionary dictionary : this.getDictionaries().values()) {
            dictionary.consumeSuggestions(word, (Consumer<String>)((Consumer)arg_0 -> WordListAdapter.suggest$lambda$3(word, result2, arg_0)));
        }
        result2.addAll((Collection)this.getAggregator().suggest(word));
        result2.remove("");
        return result2;
    }

    private static final void suggest$lambda$3(String $word, LinkedHashSet $result, String it) {
        Intrinsics.checkNotNullParameter((Object)$word, (String)"$word");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (((CharSequence)it).length() == 0) {
            return;
        }
        int distance = Levenshtein.INSTANCE.distance($word, it, 4);
        if (distance <= 3) {
            $result.add(it);
        }
    }
}

