/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.openapi.progress.ProgressSink;
import com.intellij.openapi.progress.SinkKt;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.TextToDetailsProgressSink;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a8\u0006\r"}, d2={"askReviewCommitCancel", "", "worker", "Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;", "commitActionText", "", "confirmCommitWithSkippedFiles", "", "getDescription", "textToDetailsSinkContext", "Lkotlin/coroutines/CoroutineContext;", "sink", "Lcom/intellij/openapi/progress/ProgressSink;", "intellij.platform.vcs.impl"})
public final class TodoCheckinHandlerKt {
    @NotNull
    public static final CoroutineContext textToDetailsSinkContext(@Nullable ProgressSink sink) {
        if (sink == null) {
            return (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return (CoroutineContext)SinkKt.asContextElement((ProgressSink)new TextToDetailsProgressSink(sink));
    }

    private static final boolean confirmCommitWithSkippedFiles(TodoCheckinHandlerWorker worker, @NlsContexts.Button String commitActionText) {
        String string2 = VcsBundle.message("checkin.dialog.title.todo", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"checkin.dialog.title.todo\")");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string2, TodoCheckinHandlerKt.getDescription(worker)).icon(UIUtil.getWarningIcon())).yesText(commitActionText);
        String string3 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText()");
        return ((MessageDialogBuilder.YesNo)yesNo.noText(string3)).ask(worker.getProject());
    }

    @Messages.YesNoCancelResult
    private static final int askReviewCommitCancel(TodoCheckinHandlerWorker worker, @NlsContexts.Button String commitActionText) {
        String string2 = VcsBundle.message("checkin.dialog.title.todo", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"checkin.dialog.title.todo\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel = (MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(string2, TodoCheckinHandlerKt.getDescription(worker)).icon(UIUtil.getWarningIcon());
        String string3 = VcsBundle.message("todo.in.new.review.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"todo.in.new.review.button\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string3)).noText(commitActionText);
        String string4 = CommonBundle.getCancelButtonText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCancelButtonText()");
        return yesNoCancel2.cancelText(string4).show(worker.getProject());
    }

    @NlsContexts.DialogMessage
    private static final String getDescription(TodoCheckinHandlerWorker worker) {
        String string2;
        int added2 = worker.getAddedOrEditedTodos().size();
        int changed2 = worker.getInChangedTodos().size();
        int skipped = worker.getSkipped().size();
        if (added2 == 0 && changed2 == 0) {
            Object[] objectArray = new Object[]{skipped};
            String string3 = VcsBundle.message("todo.handler.only.skipped", objectArray);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"todo.handler.only.skipped\", skipped)");
        } else if (changed2 == 0) {
            Object[] objectArray = new Object[]{added2, skipped};
            String string4 = VcsBundle.message("todo.handler.only.added", objectArray);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"todo.handler.only.added\", added, skipped)");
        } else if (added2 == 0) {
            Object[] objectArray = new Object[]{changed2, skipped};
            String string5 = VcsBundle.message("todo.handler.only.in.changed", objectArray);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"todo.handler.on\u2026anged\", changed, skipped)");
        } else {
            Object[] objectArray = new Object[]{added2, changed2, skipped};
            String string6 = VcsBundle.message("todo.handler.only.both", objectArray);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"todo.handler.on\u2026 added, changed, skipped)");
        }
        return string2;
    }

    public static final /* synthetic */ boolean access$confirmCommitWithSkippedFiles(TodoCheckinHandlerWorker worker, String commitActionText) {
        return TodoCheckinHandlerKt.confirmCommitWithSkippedFiles(worker, commitActionText);
    }

    public static final /* synthetic */ int access$askReviewCommitCancel(TodoCheckinHandlerWorker worker, String commitActionText) {
        return TodoCheckinHandlerKt.askReviewCommitCancel(worker, commitActionText);
    }
}

