/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter;
import com.intellij.completion.ngram.slp.modeling.Model;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.translating.Vocabulary;
import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.VocabularyWithLimit;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ml/ngram/NGramModelSerializer;", "", "()V", "loadNGrams", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "path", "Ljava/nio/file/Path;", "nGramLength", "", "saveNGrams", "", "runner", "intellij.platform.ml.impl"})
public final class NGramModelSerializer {
    @NotNull
    public static final NGramModelSerializer INSTANCE = new NGramModelSerializer();

    private NGramModelSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveNGrams(@NotNull Path path2, @NotNull NGramIncrementalModelRunner runner) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Closeable closeable = new ObjectOutputStream(Files.newOutputStream(path2, new OpenOption[0]));
        Throwable throwable = null;
        try {
            ObjectOutputStream oos = (ObjectOutputStream)closeable;
            boolean bl = false;
            oos.writeDouble(runner.getLambda());
            Vocabulary vocabulary = runner.getVocabulary();
            Intrinsics.checkNotNull((Object)vocabulary, (String)"null cannot be cast to non-null type com.intellij.internal.ml.ngram.VocabularyWithLimit");
            VocabularyWithLimit vocabulary2 = (VocabularyWithLimit)vocabulary;
            oos.writeInt(vocabulary2.getMaxVocabularySize());
            oos.writeInt(vocabulary2.getRecentSequence().getMaxSequenceLength());
            vocabulary2.writeExternal(oos);
            Model model2 = runner.getModel();
            Intrinsics.checkNotNull((Object)model2, (String)"null cannot be cast to non-null type com.intellij.completion.ngram.slp.modeling.ngram.NGramModel");
            Counter counter = ((NGramModel)model2).getCounter();
            Intrinsics.checkNotNull((Object)counter, (String)"null cannot be cast to non-null type com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter");
            ArrayTrieCounter counter2 = (ArrayTrieCounter)counter;
            counter2.writeExternal((ObjectOutput)oos);
            oos.writeInt(runner.getPrevTokens$intellij_platform_ml_impl().size());
            for (String file : runner.getPrevTokens$intellij_platform_ml_impl()) {
                oos.writeObject(file);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final NGramIncrementalModelRunner loadNGrams(@Nullable Path path2, int nGramLength) throws IOException {
        if (path2 != null && Files.exists(path2, new LinkOption[0])) {
            NGramIncrementalModelRunner nGramIncrementalModelRunner;
            Closeable closeable = new ObjectInputStream(Files.newInputStream(path2, new OpenOption[0]));
            Throwable throwable = null;
            try {
                ObjectInputStream ois = (ObjectInputStream)closeable;
                boolean bl = false;
                double lambda = ois.readDouble();
                int maxVocabularySize = ois.readInt();
                int maxSequenceSize = ois.readInt();
                VocabularyWithLimit vocabulary = new VocabularyWithLimit(maxVocabularySize, nGramLength, maxSequenceSize, 0, 8, null);
                vocabulary.readExternal(ois);
                ArrayTrieCounter counter = new ArrayTrieCounter();
                counter.readExternal((ObjectInput)ois);
                NGramIncrementalModelRunner runner = NGramIncrementalModelRunner.Companion.createModelRunner(nGramLength, lambda, counter, vocabulary);
                int prevFilesSize = ois.readInt();
                for (int i = 0; i < prevFilesSize; ++i) {
                    List<String> list = runner.getPrevTokens$intellij_platform_ml_impl();
                    Object object = ois.readObject();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    list.add((String)object);
                }
                nGramIncrementalModelRunner = runner;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return nGramIncrementalModelRunner;
        }
        return NGramIncrementalModelRunner.Companion.createNewModelRunner$default(NGramIncrementalModelRunner.Companion, nGramLength, 0.0, 2, null);
    }
}

