/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ROStatusChange
extends StructuralChange {
    private final boolean myOldStatus;

    public ROStatusChange(long id, String path2, boolean oldStatus) {
        super(id, path2);
        this.myOldStatus = oldStatus;
    }

    public ROStatusChange(DataInput in) throws IOException {
        super(in);
        this.myOldStatus = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.myOldStatus);
    }

    public boolean getOldStatus() {
        return this.myOldStatus;
    }

    @Override
    public void revertOn(RootEntry root, boolean warnOnFileNotFound) {
        Entry e = root.findEntry(this.myPath);
        if (e == null) {
            this.cannotRevert(this.myPath, warnOnFileNotFound);
            return;
        }
        e.setReadOnly(this.myOldStatus);
    }

    @Override
    public void accept(ChangeVisitor v) throws ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

