/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.paths.PathReferenceManagerImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlPathReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){

            @Override
            public void visitXmlAttributeValue(@NotNull XmlAttributeValue value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                XmlPathReferenceInspection.this.checkRefs(value2, holder);
            }

            @Override
            public void visitXmlDoctype(@NotNull XmlDoctype xmlDoctype) {
                if (xmlDoctype == null) {
                    1.$$$reportNull$$$0(1);
                }
                XmlPathReferenceInspection.this.checkRefs(xmlDoctype, holder);
            }

            @Override
            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(2);
                }
                XmlPathReferenceInspection.this.checkRefs(tag, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "xmlDoctype";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttributeValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlDoctype";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private void checkRefs(@NotNull XmlElement element, @NotNull ProblemsHolder holder) {
        PsiReference[] references;
        if (element == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(2);
        }
        if ((references = element.getReferences()).length == 0) {
            return;
        }
        if (XmlHighlightVisitor.isInjectedWithoutValidation(element)) {
            return;
        }
        boolean isHtml = HtmlUtil.isHtmlTagContainingFile(element);
        if (isHtml ^ this.isForHtml()) {
            return;
        }
        if (!isHtml && XmlHighlightVisitor.skipValidation(element)) {
            return;
        }
        Collection<PsiReference> unresolved = this.getUnresolvedReferencesToAnnotate(references);
        for (PsiReference reference : unresolved) {
            holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), isHtml ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @NotNull
    private Collection<PsiReference> getUnresolvedReferencesToAnnotate(PsiReference[] references) {
        HashMap<TextRange, PsiReference> unresolvedReferences = new HashMap<TextRange, PsiReference>();
        for (PsiReference reference : ContainerUtil.concat((Object[])references, PathReferenceManagerImpl::remergeWrappedReferences)) {
            TextRange rangeInElement;
            TextRange elementRange;
            if (!XmlHighlightVisitor.isUrlReference(reference) || !this.needToCheckRef(reference) || (elementRange = reference.getElement().getTextRange()) == null || elementRange.isEmpty() || unresolvedReferences.containsKey(rangeInElement = reference.getRangeInElement()) && unresolvedReferences.get(rangeInElement) == null) continue;
            if (XmlHighlightVisitor.hasBadResolve(reference, true)) {
                if (reference.isSoft()) continue;
                unresolvedReferences.putIfAbsent(rangeInElement, reference);
                continue;
            }
            unresolvedReferences.put(rangeInElement, null);
        }
        List list = ContainerUtil.skipNulls(unresolvedReferences.values());
        if (list == null) {
            XmlPathReferenceInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected boolean needToCheckRef(PsiReference reference) {
        return true;
    }

    protected boolean isForHtml() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlPathReferenceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedReferencesToAnnotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkRefs";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

