/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyConfigurationModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyConfigurationModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.model.ext.ResolvedPropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.CompactToMapCatalogDependencyTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FakeElementTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.dependencies.FakeArtifactElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactDependencyModelImpl
extends DependencyModelImpl
implements ArtifactDependencyModel {
    @Nullable
    private GradleDslClosure myConfigurationElement;
    protected boolean mySetThrough;
    protected boolean versionCatalogDependency;
    @NotNull
    private static final Pattern WRAPPED_VARIABLE_FORM = Pattern.compile("\\$\\{(.*)}");
    @NotNull
    private static final Pattern UNWRAPPED_VARIABLE_FORM = Pattern.compile("\\$(([a-zA-Z0-9_]\\w*)(\\.([a-zA-Z0-9_]\\w+))*)");

    public ArtifactDependencyModelImpl(@Nullable GradleDslClosure configurationElement, @NotNull String configurationName, @NotNull DependencyModelImpl.Maintainer maintainer) {
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(0);
        }
        if (maintainer == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(1);
        }
        super(configurationName, maintainer);
        this.mySetThrough = false;
        this.versionCatalogDependency = false;
        this.myConfigurationElement = configurationElement;
    }

    @Override
    @NotNull
    public ArtifactDependencySpec getSpec() {
        String name2 = this.name().toString();
        assert (name2 != null);
        return new ArtifactDependencySpecImpl(name2, this.group().toString(), this.version().toString(), this.classifier().toString(), this.extension().toString());
    }

    @Override
    @NotNull
    public String compactNotation() {
        String string = this.getSpec().compactNotation();
        if (string == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public abstract ResolvedPropertyModel name();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel group();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel version();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel classifier();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel extension();

    @Override
    @NotNull
    public abstract ResolvedPropertyModel completeModel();

    @Override
    @Nullable
    public DependencyConfigurationModel configuration() {
        if (this.myConfigurationElement == null) {
            return null;
        }
        return new DependencyConfigurationModelImpl(this.myConfigurationElement);
    }

    @Override
    public void enableSetThrough() {
        this.mySetThrough = true;
    }

    @Override
    public void disableSetThrough() {
        this.mySetThrough = false;
    }

    @Override
    public boolean isVersionCatalogDependency() {
        return this.versionCatalogDependency;
    }

    @Override
    public void markAsVersionCatalogDependency() {
        this.versionCatalogDependency = true;
    }

    @NotNull
    private static GradleDslLiteral createLiteral(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName) {
        if (parent == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(3);
        }
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(4);
        }
        GradleNameElement name2 = GradleNameElement.create(configurationName);
        GradleDslLiteral literal = new GradleDslLiteral(parent, name2);
        literal.setElementType(PropertyType.REGULAR);
        parent.setNewElement(literal);
        GradleDslLiteral gradleDslLiteral = literal;
        if (gradleDslLiteral == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(5);
        }
        return gradleDslLiteral;
    }

    private static void initializeLiteral(@NotNull GradleDslLiteral literal, @NotNull Object value, @NotNull List<ArtifactDependencySpec> excludes) {
        if (literal == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(6);
        }
        if (value == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(7);
        }
        if (excludes == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(8);
        }
        literal.setValue(value);
        ArtifactDependencyModelImpl.addExcludes(literal, excludes);
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ReferenceTo reference, @NotNull List<ArtifactDependencySpec> excludes) {
        if (parent == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(9);
        }
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(10);
        }
        if (reference == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(11);
        }
        if (excludes == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(12);
        }
        GradleDslLiteral literal = ArtifactDependencyModelImpl.createLiteral(parent, configurationName);
        ArtifactDependencyModelImpl.initializeLiteral(literal, reference, excludes);
    }

    static void createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (parent == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(13);
        }
        if (configurationName == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(14);
        }
        if (dependency == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(15);
        }
        if (excludes == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(16);
        }
        GradleDslLiteral literal = ArtifactDependencyModelImpl.createLiteral(parent, configurationName);
        ArtifactDependencyModelImpl.initializeLiteral(literal, ArtifactDependencyModelImpl.createCompactNotationForLiterals(literal, dependency), excludes);
    }

    private static void addExcludes(@NotNull GradleDslLiteral literal, @NotNull List<ArtifactDependencySpec> excludes) {
        if (literal == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(17);
        }
        if (excludes == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(18);
        }
        if (!excludes.isEmpty()) {
            GradleDslClosure closure = new GradleDslClosure(literal.getParent(), null, literal.getNameElement());
            for (ArtifactDependencySpec exclude : excludes) {
                GradleDslExpressionMap map = new GradleDslExpressionMap(closure, GradleNameElement.create("exclude"));
                String group2 = exclude.getGroup();
                if (group2 != null) {
                    GradleDslLiteral groupEntry = new GradleDslLiteral(map, GradleNameElement.create("group"));
                    groupEntry.setValue(FakeArtifactElement.shouldInterpolate(group2) ? GradlePropertyModel.iStr(group2) : group2);
                    map.setNewElement(groupEntry);
                }
                GradleDslLiteral moduleEntry = new GradleDslLiteral(map, GradleNameElement.create("module"));
                String module = exclude.getName();
                moduleEntry.setValue(FakeArtifactElement.shouldInterpolate(module) ? GradlePropertyModel.iStr(module) : module);
                map.setNewElement(moduleEntry);
                closure.setNewElement(map);
            }
            literal.setNewClosureElement(closure);
        }
    }

    @NotNull
    protected static String createCompactNotationForLiterals(@NotNull GradleDslElement dslElement, @NotNull ArtifactDependencySpec spec) {
        if (dslElement == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(19);
        }
        if (spec == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(20);
        }
        ArrayList segments = Lists.newArrayList((Object[])new String[]{spec.getGroup(), spec.getName(), spec.getVersion(), spec.getClassifier(), spec.getExtension()});
        boolean shouldInterpolate = false;
        StringBuilder compactNotation = new StringBuilder();
        for (int currentElementIdx = 0; currentElementIdx < segments.size(); ++currentElementIdx) {
            String segment = (String)segments.get(currentElementIdx);
            if (segment == null) continue;
            if (currentElementIdx == 4) {
                compactNotation.append("@");
            } else if (currentElementIdx > 0) {
                compactNotation.append(":");
            }
            if (FakeArtifactElement.shouldInterpolate(segment)) {
                String value;
                shouldInterpolate = true;
                Matcher wrappedValueMatcher = WRAPPED_VARIABLE_FORM.matcher(segment);
                Matcher unwrappedValueMatcher = UNWRAPPED_VARIABLE_FORM.matcher(segment);
                String interpolatedVariable = null;
                if (wrappedValueMatcher.find()) {
                    interpolatedVariable = wrappedValueMatcher.group(1);
                } else if (unwrappedValueMatcher.find()) {
                    interpolatedVariable = unwrappedValueMatcher.group(1);
                }
                String string = value = interpolatedVariable != null ? dslElement.getDslFile().getParser().convertReferenceToExternalText(dslElement, interpolatedVariable, true) : segment;
                if (Pattern.compile("([a-zA-Z0-9_]\\w*)").matcher(value).matches()) {
                    compactNotation.append("$").append(value);
                    continue;
                }
                if (WRAPPED_VARIABLE_FORM.matcher(value).matches() || UNWRAPPED_VARIABLE_FORM.matcher(value).matches()) {
                    compactNotation.append(value);
                    continue;
                }
                compactNotation.append("${").append(value).append("}");
                continue;
            }
            compactNotation.append(segment);
        }
        String string = shouldInterpolate ? GradlePropertyModel.iStr(compactNotation.toString()) : compactNotation.toString();
        if (string == null) {
            ArtifactDependencyModelImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maintainer";
                break;
            }
            case 2: 
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "compactNotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteral";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompactNotationForLiterals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLiteral";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "initializeLiteral";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createNew";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExcludes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCompactNotationForLiterals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 21 -> new IllegalStateException(string);
        };
    }

    static class CompactNotationStrategy
    implements NotationStrategy {
        @NotNull
        private GradleDslSimpleExpression myDslExpression;
        private boolean mySetThrough;

        CompactNotationStrategy(@NotNull GradleDslSimpleExpression dslExpression, boolean setThrough) {
            if (dslExpression == null) {
                CompactNotationStrategy.$$$reportNull$$$0(0);
            }
            this.myDslExpression = dslExpression;
            this.mySetThrough = setThrough;
        }

        @NotNull
        public ResolvedPropertyModel createModelFor(@NotNull String name2, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpecImpl, String> setFunc, boolean canDelete, PropertyTransform additionalTransformer) {
            if (name2 == null) {
                CompactNotationStrategy.$$$reportNull$$$0(1);
            }
            if (getFunc == null) {
                CompactNotationStrategy.$$$reportNull$$$0(2);
            }
            if (setFunc == null) {
                CompactNotationStrategy.$$$reportNull$$$0(3);
            }
            GradleDslSimpleExpression element = this.mySetThrough ? PropertyUtil.resolveElement(this.myDslExpression) : this.myDslExpression;
            FakeArtifactElement fakeElement = new FakeArtifactElement(element.getParent(), GradleNameElement.fake(name2), element, getFunc, setFunc, canDelete);
            GradlePropertyModelBuilder builder = GradlePropertyModelBuilder.create(fakeElement);
            if (additionalTransformer != null) {
                builder = builder.addTransform(additionalTransformer);
            }
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = builder.addTransform(new FakeElementTransform()).buildResolved();
            if (resolvedPropertyModelImpl == null) {
                CompactNotationStrategy.$$$reportNull$$$0(4);
            }
            return resolvedPropertyModelImpl;
        }

        @NotNull
        public ResolvedPropertyModel createModelFor(@NotNull String name2, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpecImpl, String> setFunc, boolean canDelete) {
            if (name2 == null) {
                CompactNotationStrategy.$$$reportNull$$$0(5);
            }
            if (getFunc == null) {
                CompactNotationStrategy.$$$reportNull$$$0(6);
            }
            if (setFunc == null) {
                CompactNotationStrategy.$$$reportNull$$$0(7);
            }
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor(name2, getFunc, setFunc, canDelete, null);
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(8);
            }
            return resolvedPropertyModel;
        }

        @Override
        public boolean isValidDSL() {
            String value = this.myDslExpression.getValue(String.class);
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            return this.name().getValueType() != GradlePropertyModel.ValueType.NONE;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("name", ArtifactDependencySpec::getName, ArtifactDependencySpecImpl::setName, false);
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(9);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("group", ArtifactDependencySpec::getGroup, ArtifactDependencySpecImpl::setGroup, true);
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(10);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("version", ArtifactDependencySpec::getVersion, ArtifactDependencySpecImpl::setVersion, true, new CompactToMapCatalogDependencyTransform());
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(11);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("classifier", ArtifactDependencySpec::getClassifier, ArtifactDependencySpecImpl::setClassifier, true);
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(12);
            }
            return resolvedPropertyModel;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            ResolvedPropertyModel resolvedPropertyModel = this.createModelFor("extension", ArtifactDependencySpec::getExtension, ArtifactDependencySpecImpl::setExtension, true);
            if (resolvedPropertyModel == null) {
                CompactNotationStrategy.$$$reportNull$$$0(13);
            }
            return resolvedPropertyModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 8, 9, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslExpression";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getFunc";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setFunc";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$CompactNotationStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$CompactNotationStrategy";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createModelFor";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "version";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classifier";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createModelFor";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }

    static class MapNotationStrategy
    implements NotationStrategy {
        @NotNull
        private GradleDslExpressionMap myDslElement;

        MapNotationStrategy(@NotNull GradleDslExpressionMap dslElement) {
            if (dslElement == null) {
                MapNotationStrategy.$$$reportNull$$$0(0);
            }
            this.myDslElement = dslElement;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            GradleDslLiteral module = this.myDslElement.getPropertyElement("module", GradleDslLiteral.class);
            if (module != null) {
                FakeArtifactElement element = new FakeArtifactElement(this.myDslElement, GradleNameElement.fake("name"), module, ArtifactDependencySpec::getName, ArtifactDependencySpecImpl::setName, false);
                ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(element).addTransform(new FakeElementTransform()).buildResolved();
                if (resolvedPropertyModelImpl == null) {
                    MapNotationStrategy.$$$reportNull$$$0(1);
                }
                return resolvedPropertyModelImpl;
            }
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "name").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotationStrategy.$$$reportNull$$$0(2);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        public boolean isValidDSL() {
            return this.myDslElement.getLiteral("name", String.class) != null || this.myDslElement.getLiteral("module", String.class) != null;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel group() {
            GradleDslLiteral module = this.myDslElement.getPropertyElement("module", GradleDslLiteral.class);
            if (module != null) {
                FakeArtifactElement element = new FakeArtifactElement(this.myDslElement, GradleNameElement.fake("group"), module, ArtifactDependencySpec::getGroup, ArtifactDependencySpecImpl::setGroup, false);
                ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create(element).addTransform(new FakeElementTransform()).buildResolved();
                if (resolvedPropertyModelImpl == null) {
                    MapNotationStrategy.$$$reportNull$$$0(3);
                }
                return resolvedPropertyModelImpl;
            }
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "group").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotationStrategy.$$$reportNull$$$0(4);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel version() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "version").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotationStrategy.$$$reportNull$$$0(5);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel classifier() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "classifier").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotationStrategy.$$$reportNull$$$0(6);
            }
            return resolvedPropertyModelImpl;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel extension() {
            ResolvedPropertyModelImpl resolvedPropertyModelImpl = GradlePropertyModelBuilder.create((GradlePropertiesDslElement)this.myDslElement, "ext").buildResolved();
            if (resolvedPropertyModelImpl == null) {
                MapNotationStrategy.$$$reportNull$$$0(7);
            }
            return resolvedPropertyModelImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$MapNotationStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$MapNotationStrategy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "version";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classifier";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    static interface NotationStrategy {
        public boolean isValidDSL();

        public ResolvedPropertyModel name();

        public ResolvedPropertyModel group();

        public ResolvedPropertyModel version();

        public ResolvedPropertyModel classifier();

        public ResolvedPropertyModel extension();
    }

    static class DynamicNotation
    extends ArtifactDependencyModelImpl {
        private GradleDslExpression myDslExpression;

        DynamicNotation(@NotNull String configurationName, @NotNull GradleDslExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
            if (configurationName == null) {
                DynamicNotation.$$$reportNull$$$0(0);
            }
            if (dslExpression == null) {
                DynamicNotation.$$$reportNull$$$0(1);
            }
            if (maintainer == null) {
                DynamicNotation.$$$reportNull$$$0(2);
            }
            super(configurationElement, configurationName, maintainer);
            this.myDslExpression = dslExpression;
        }

        @Nullable
        private static GradleDslExpression resolveExpression(@NotNull GradleDslExpression expression) {
            GradleDslElement element;
            if (expression == null) {
                DynamicNotation.$$$reportNull$$$0(3);
            }
            if ((element = PropertyUtil.followElement(expression)) instanceof GradleDslExpression) {
                expression = (GradleDslExpression)element;
            }
            return expression;
        }

        private NotationStrategy getStrategy() {
            GradleDslExpression resolvedExpression = DynamicNotation.resolveExpression(this.myDslExpression);
            if (resolvedExpression instanceof GradleDslExpressionMap) {
                return new MapNotationStrategy((GradleDslExpressionMap)resolvedExpression);
            }
            if (this.myDslExpression instanceof GradleDslSimpleExpression) {
                return new CompactNotationStrategy((GradleDslSimpleExpression)this.myDslExpression, this.mySetThrough);
            }
            return null;
        }

        @Override
        @NotNull
        public ResolvedPropertyModel name() {
            ResolvedPropertyModel resolvedPropertyModel = this.getStrategy().name();
            if (resolvedPropertyModel == null) {
                DynamicNotation.$$$reportNull$$$0(4);
            }
            return resolvedPropertyModel;
        }

        @Override
        @Nullable
        public ResolvedPropertyModel group() {
            return this.getStrategy().group();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel version() {
            return this.getStrategy().version();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel classifier() {
            return this.getStrategy().classifier();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel extension() {
            return this.getStrategy().extension();
        }

        @Override
        @Nullable
        public ResolvedPropertyModel completeModel() {
            return GradlePropertyModelBuilder.create(this.myDslExpression).buildResolved();
        }

        @Override
        @Nullable
        protected GradleDslElement getDslElement() {
            return this.myDslExpression;
        }

        @Override
        void setDslElement(@NotNull GradleDslElement dslElement) {
            if (dslElement == null) {
                DynamicNotation.$$$reportNull$$$0(5);
            }
            this.myDslExpression = (GradleDslExpression)dslElement;
        }

        @Override
        @Nullable
        public PsiElement getPsiElement() {
            return this.myDslExpression.getExpression();
        }

        public boolean isValidDSL() {
            return this.getStrategy().isValidDSL();
        }

        @Nullable
        static DynamicNotation create(@NotNull String configurationName, @NotNull GradleDslExpression dslExpression, @Nullable GradleDslClosure configurationElement, @NotNull DependencyModelImpl.Maintainer maintainer, @Nullable String platformMethodName) {
            if (configurationName == null) {
                DynamicNotation.$$$reportNull$$$0(6);
            }
            if (dslExpression == null) {
                DynamicNotation.$$$reportNull$$$0(7);
            }
            if (maintainer == null) {
                DynamicNotation.$$$reportNull$$$0(8);
            }
            DynamicNotation result = platformMethodName == null ? new DynamicNotation(configurationName, dslExpression, configurationElement, maintainer) : new PlatformArtifactDependencyModelImpl.DynamicNotation(configurationName, dslExpression, configurationElement, maintainer, platformMethodName);
            return result.isValidDSL() ? result : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationName";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslExpression";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maintainer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$DynamicNotation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dslElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/ArtifactDependencyModelImpl$DynamicNotation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveExpression";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setDslElement";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

